/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsImpl;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.StatusBarUpdater;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Alarm;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonCodeAnalyzerImpl
extends DaemonCodeAnalyzerEx
implements JDOMExternalizable,
NamedComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
    private static final Key<List<LineMarkerInfo>> MARKERS_IN_EDITOR_DOCUMENT_KEY = Key.create((String)"MARKERS_IN_EDITOR_DOCUMENT");
    private static final Key<List<HighlightInfo>> FILE_LEVEL_HIGHLIGHTS = Key.create((String)"FILE_LEVEL_HIGHLIGHTS");
    private final Project myProject;
    private final DaemonCodeAnalyzerSettings mySettings;
    @NotNull
    private final EditorTracker myEditorTracker;
    private DaemonProgressIndicator myUpdateProgress;
    private final Runnable myUpdateRunnable;
    private final Alarm myAlarm;
    private boolean myUpdateByTimerEnabled;
    private final Collection<VirtualFile> myDisabledHintsFiles;
    private final Collection<VirtualFile> myDisabledHighlightingFiles;
    private final FileStatusMap myFileStatusMap;
    private DaemonCodeAnalyzerSettings myLastSettings;
    private volatile IntentionHintComponent myLastIntentionHint;
    private volatile boolean myDisposed;
    private volatile boolean myInitialized;
    @NonNls
    private static final String DISABLE_HINTS_TAG = "disable_hints";
    @NonNls
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String URL_ATT = "url";
    private final PassExecutorService myPassExecutorService;
    private volatile boolean allowToInterrupt;
    private int myDisableCount;

    public DaemonCodeAnalyzerImpl(@NotNull Project project, @NotNull DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings, @NotNull EditorTracker editorTracker, @NotNull NamedScopeManager namedScopeManager, @NotNull DependencyValidationManager dependencyValidationManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (daemonCodeAnalyzerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "daemonCodeAnalyzerSettings", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (editorTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTracker", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (namedScopeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedScopeManager", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (dependencyValidationManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyValidationManager", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myUpdateRunnable = this.createUpdateRunnable();
        this.myAlarm = new Alarm();
        this.myUpdateByTimerEnabled = true;
        this.myDisabledHintsFiles = new THashSet();
        this.myDisabledHighlightingFiles = new THashSet();
        this.allowToInterrupt = true;
        this.myDisableCount = 0;
        this.myProject = project;
        this.mySettings = daemonCodeAnalyzerSettings;
        this.myEditorTracker = editorTracker;
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)daemonCodeAnalyzerSettings).clone();
        this.myFileStatusMap = new FileStatusMap(project);
        this.myPassExecutorService = new PassExecutorService(project);
        Disposer.register((Disposable)this, (Disposable)this.myPassExecutorService);
        Disposer.register((Disposable)this, (Disposable)this.myFileStatusMap);
        DaemonProgressIndicator.setDebug(LOG.isDebugEnabled());
        assert (!this.myInitialized) : "Double Initializing";
        Disposer.register((Disposable)this, (Disposable)new StatusBarUpdater(project));
        this.myInitialized = true;
        this.myDisposed = false;
        this.myFileStatusMap.markAllFilesDirty();
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                assert (DaemonCodeAnalyzerImpl.this.myInitialized) : "Disposing not initialized component";
                assert (!DaemonCodeAnalyzerImpl.this.myDisposed) : "Double dispose";
                DaemonCodeAnalyzerImpl.this.stopProcess(false, "Dispose");
                DaemonCodeAnalyzerImpl.this.myDisposed = true;
                DaemonCodeAnalyzerImpl.this.myLastSettings = null;
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public static List<HighlightInfo> getHighlights(@NotNull Document document, HighlightSeverity minSeverity, @NotNull Project project) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerImpl.processHighlights(document, project, minSeverity, 0, document.getTextLength(), (Processor<HighlightInfo>)new CommonProcessors.CollectProcessor(infos));
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<HighlightInfo> getFileLevelHighlights(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (infos == null) continue;
            for (HighlightInfo info : infos) {
                result.add(info);
            }
        }
        ArrayList<HighlightInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        return arrayList;
    }

    @Override
    public void cleanFileLevelHighlights(@NotNull Project project, int group, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "cleanFileLevelHighlights"));
        }
        if (psiFile == null) {
            return;
        }
        FileViewProvider provider = psiFile.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (infos == null) continue;
            ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : infos) {
                if (info.getGroup() != group) continue;
                manager.removeTopComponent(fileEditor, info.fileLevelComponent);
                infosToRemove.add(info);
            }
            infos.removeAll(infosToRemove);
        }
    }

    @Override
    public void addFileLevelHighlight(@NotNull Project project, int group, @NotNull HighlightInfo info, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            FileLevelIntentionComponent component = new FileLevelIntentionComponent(info.getDescription(), info.getSeverity(), info.getGutterIconRenderer(), info.quickFixActionRanges, project, psiFile, ((TextEditor)fileEditor).getEditor());
            manager.addTopComponent(fileEditor, (JComponent)((Object)component));
            ArrayList<HighlightInfo> fileLevelInfos = (ArrayList<HighlightInfo>)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (fileLevelInfos == null) {
                fileLevelInfos = new ArrayList<HighlightInfo>();
                fileEditor.putUserData(FILE_LEVEL_HIGHLIGHTS, fileLevelInfos);
            }
            info.fileLevelComponent = component;
            info.setGroup(group);
            fileLevelInfos.add(info);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> runMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull ProgressIndicator progress) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
        }
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && !virtualFile.getFileType().isBinary()) {
            List<TextEditorHighlightingPass> passes = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject).instantiateMainPasses(psiFile, document, HighlightInfoProcessor.getEmpty());
            Collections.sort(passes, new Comparator<TextEditorHighlightingPass>(){

                @Override
                public int compare(TextEditorHighlightingPass o1, TextEditorHighlightingPass o2) {
                    if (o1 instanceof GeneralHighlightingPass) {
                        return -1;
                    }
                    if (o2 instanceof GeneralHighlightingPass) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (TextEditorHighlightingPass pass : passes) {
                pass.doCollectInformation(progress);
                result.addAll(pass.getInfos());
            }
        }
        ArrayList<HighlightInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
        }
        return arrayList;
    }

    @NotNull
    public List<HighlightInfo> runPasses(@NotNull PsiFile file, @NotNull Document document, @NotNull TextEditor textEditor, @NotNull int[] toIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (textEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        List<HighlightInfo> list = this.runPasses(file, document, Collections.singletonList(textEditor), toIgnore, canChangeDocument, callbackWhileWaiting);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<HighlightInfo> runPasses(@NotNull PsiFile file, @NotNull Document document, @NotNull List<TextEditor> textEditors, @NotNull int[] toIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (textEditors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditors", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        assert (this.myInitialized);
        assert (!this.myDisposed);
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.assertIsDispatchThread();
        if (application.isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Must not start highlighting from within write action, or deadlock is imminent");
        }
        DaemonProgressIndicator.setDebug(true);
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        UIUtil.dispatchAllInvocationEvents();
        while (RefreshQueueImpl.isRefreshInProgress() || HeavyProcessLatch.INSTANCE.isRunning()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        UIUtil.dispatchAllInvocationEvents();
        Project project = file.getProject();
        this.setUpdateByTimerEnabled(false);
        FileStatusMap.getAndClearLog();
        FileStatusMap fileStatusMap = this.getFileStatusMap();
        fileStatusMap.allowDirt(canChangeDocument);
        HashMap<FileEditor, HighlightingPass[]> map = new HashMap<FileEditor, HighlightingPass[]>();
        for (TextEditor textEditor : textEditors) {
            TextEditorBackgroundHighlighter highlighter = (TextEditorBackgroundHighlighter)textEditor.getBackgroundHighlighter();
            List<TextEditorHighlightingPass> passes = highlighter.getPasses(toIgnore);
            HighlightingPass[] array = passes.toArray(new HighlightingPass[passes.size()]);
            assert (array.length != 0) : "Highlighting is disabled for the file " + file;
            map.put((FileEditor)textEditor, array);
        }
        for (int ignoreId : toIgnore) {
            fileStatusMap.markFileUpToDate(document, ignoreId);
        }
        DaemonProgressIndicator progress = this.createUpdateProgress();
        this.myPassExecutorService.submitPasses(map, progress);
        while (progress.isRunning()) {
            try {
                progress.checkCanceled();
                if (callbackWhileWaiting != null) {
                    callbackWhileWaiting.run();
                }
                this.myPassExecutorService.waitFor(50);
                UIUtil.dispatchAllInvocationEvents();
                Throwable savedException = PassExecutorService.getSavedException(progress);
                if (savedException == null) continue;
                throw savedException;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        UIUtil.dispatchAllInvocationEvents();
        UIUtil.dispatchAllInvocationEvents();
        List<HighlightInfo> list = DaemonCodeAnalyzerImpl.getHighlights(document, null, project);
        List<HighlightInfo> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        return list2;
        finally {
            DaemonProgressIndicator.setDebug(false);
            String log = FileStatusMap.getAndClearLog();
            fileStatusMap.allowDirt(true);
            try {
                this.waitForTermination();
            }
            catch (Throwable e) {
                LOG.error(log, e);
            }
        }
    }

    public void prepareForTest() {
        this.setUpdateByTimerEnabled(false);
        this.waitForTermination();
    }

    public void cleanupAfterTest() {
        if (!this.myProject.isOpen()) {
            return;
        }
        this.setUpdateByTimerEnabled(false);
        this.waitForTermination();
    }

    void waitForTermination() {
        this.myPassExecutorService.cancelAll(true);
    }

    @NotNull
    public String getComponentName() {
        if ("DaemonCodeAnalyzer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getComponentName"));
        }
        return "DaemonCodeAnalyzer";
    }

    public void settingsChanged() {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        if (settings.isCodeHighlightingChanged(this.myLastSettings)) {
            this.restart();
        }
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)settings).clone();
    }

    public void updateVisibleHighlighters(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "updateVisibleHighlighters"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    public void setUpdateByTimerEnabled(boolean value) {
        this.myUpdateByTimerEnabled = value;
        this.stopProcess(value, "Update by timer change");
    }

    public void disableUpdateByTimer(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "disableUpdateByTimer"));
        }
        this.setUpdateByTimerEnabled(false);
        ++this.myDisableCount;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DaemonCodeAnalyzerImpl.this.myDisableCount--;
                if (DaemonCodeAnalyzerImpl.this.myDisableCount == 0) {
                    DaemonCodeAnalyzerImpl.this.setUpdateByTimerEnabled(true);
                }
            }
        });
    }

    public boolean isUpdateByTimerEnabled() {
        return this.myUpdateByTimerEnabled;
    }

    public void setImportHintsEnabled(@NotNull PsiFile file, boolean value) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setImportHintsEnabled"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (value) {
            this.myDisabledHintsFiles.remove(vFile);
            this.stopProcess(true, "Import hints change");
        } else {
            this.myDisabledHintsFiles.add(vFile);
            HintManager.getInstance().hideAllHints();
        }
    }

    public void resetImportHintsEnabledForProject() {
        this.myDisabledHintsFiles.clear();
    }

    public void setHighlightingEnabled(@NotNull PsiFile file, boolean value) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setHighlightingEnabled"));
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (value) {
            this.myDisabledHighlightingFiles.remove(virtualFile);
        } else {
            this.myDisabledHighlightingFiles.add(virtualFile);
        }
    }

    public boolean isHighlightingAvailable(@Nullable PsiFile file) {
        if (file == null || !file.isPhysical()) {
            return false;
        }
        if (this.myDisabledHighlightingFiles.contains(PsiUtilCore.getVirtualFile((PsiElement)file))) {
            return false;
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        FileType fileType = file.getFileType();
        return !fileType.isBinary();
    }

    public boolean isImportHintsEnabled(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isImportHintsEnabled"));
        }
        return this.isAutohintsAvailable(file) && !this.myDisabledHintsFiles.contains(file.getVirtualFile());
    }

    public boolean isAutohintsAvailable(PsiFile file) {
        return this.isHighlightingAvailable(file) && !(file instanceof PsiCompiledElement);
    }

    public void restart() {
        this.myFileStatusMap.markAllFilesDirty();
        this.stopProcess(true, "Global restart");
    }

    public void restart(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "restart"));
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
        if (document == null) {
            return;
        }
        this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, document.getTextLength()), file.getTextLength());
        this.stopProcess(true, "Psi file restart");
    }

    @NotNull
    List<TextEditorHighlightingPass> getPassesToShowProgressFor(Document document) {
        List<TextEditorHighlightingPass> allPasses = this.myPassExecutorService.getAllSubmittedPasses();
        ArrayList<TextEditorHighlightingPass> result = new ArrayList<TextEditorHighlightingPass>(allPasses.size());
        for (TextEditorHighlightingPass pass : allPasses) {
            if (pass.getDocument() != document && pass.getDocument() != null) continue;
            result.add(pass);
        }
        ArrayList<TextEditorHighlightingPass> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getPassesToShowProgressFor"));
        }
        return arrayList;
    }

    boolean isAllAnalysisFinished(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isAllAnalysisFinished"));
        }
        if (this.myDisposed) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
        return document != null && document.getModificationStamp() == file.getViewProvider().getModificationStamp() && this.myFileStatusMap.allDirtyScopesAreNull(document);
    }

    @Override
    public boolean isErrorAnalyzingFinished(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isErrorAnalyzingFinished"));
        }
        if (this.myDisposed) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
        return document != null && document.getModificationStamp() == file.getViewProvider().getModificationStamp() && this.myFileStatusMap.getFileDirtyScope(document, 4) == null;
    }

    @Override
    @NotNull
    public FileStatusMap getFileStatusMap() {
        FileStatusMap fileStatusMap = this.myFileStatusMap;
        if (fileStatusMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileStatusMap"));
        }
        return fileStatusMap;
    }

    synchronized boolean isRunning() {
        return this.myUpdateProgress != null && !this.myUpdateProgress.isCanceled();
    }

    synchronized void stopProcess(boolean toRestartAlarm, @NonNls String reason) {
        boolean restart;
        if (!this.allowToInterrupt) {
            throw new RuntimeException("Cannot interrupt daemon");
        }
        this.cancelUpdateProgress(toRestartAlarm, reason);
        this.myAlarm.cancelAllRequests();
        boolean bl = restart = toRestartAlarm && !this.myDisposed && this.myInitialized;
        if (restart) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    DaemonCodeAnalyzerImpl.this.myAlarm.addRequest(DaemonCodeAnalyzerImpl.this.myUpdateRunnable, ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzerImpl.this).mySettings.AUTOREPARSE_DELAY);
                }
            });
        }
    }

    private synchronized void cancelUpdateProgress(boolean start, @NonNls String reason) {
        PassExecutorService.log(this.myUpdateProgress, null, "CancelX", reason, start);
        if (this.myUpdateProgress != null) {
            this.myUpdateProgress.cancel();
            this.myPassExecutorService.cancelAll(false);
            this.myUpdateProgress = null;
        }
    }

    public static boolean processHighlightsNearOffset(@NotNull Document document, @NotNull Project project, final @NotNull HighlightSeverity minSeverity, final int offset, final boolean includeFixRange, final @NotNull Processor<HighlightInfo> processor) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (minSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        return DaemonCodeAnalyzerImpl.processHighlights(document, project, null, 0, document.getTextLength(), new Processor<HighlightInfo>(){

            public boolean process(@NotNull HighlightInfo info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$5", "process"));
                }
                if (!DaemonCodeAnalyzerImpl.isOffsetInsideHighlightInfo(offset, info, includeFixRange)) {
                    return true;
                }
                int compare = info.getSeverity().compareTo(minSeverity);
                return compare < 0 || processor.process((Object)info);
            }
        });
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        return this.findHighlightByOffset(document, offset, includeFixRange, HighlightSeverity.INFORMATION);
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        if (minSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        SmartList foundInfoList = new SmartList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(document, this.myProject, minSeverity, offset, includeFixRange, new Processor<HighlightInfo>((List)foundInfoList){
            final /* synthetic */ List val$foundInfoList;
            {
                this.val$foundInfoList = list;
            }

            public boolean process(@NotNull HighlightInfo info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$6", "process"));
                }
                if (info.getSeverity() == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY) {
                    return true;
                }
                if (!this.val$foundInfoList.isEmpty()) {
                    HighlightInfo foundInfo = (HighlightInfo)this.val$foundInfoList.get(0);
                    int compare = foundInfo.getSeverity().compareTo(info.getSeverity());
                    if (compare < 0) {
                        this.val$foundInfoList.clear();
                    } else if (compare > 0) {
                        return true;
                    }
                }
                this.val$foundInfoList.add(info);
                return true;
            }
        });
        if (foundInfoList.isEmpty()) {
            return null;
        }
        if (foundInfoList.size() == 1) {
            return (HighlightInfo)foundInfoList.get(0);
        }
        return new HighlightInfoComposite((List<HighlightInfo>)foundInfoList);
    }

    private static boolean isOffsetInsideHighlightInfo(int offset, @NotNull HighlightInfo info, boolean includeFixRange) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isOffsetInsideHighlightInfo"));
        }
        RangeHighlighterEx highlighter = info.highlighter;
        if (highlighter == null || !highlighter.isValid()) {
            return false;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (startOffset <= offset && offset <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        RangeMarker fixMarker = info.fixMarker;
        if (fixMarker != null) {
            if (!fixMarker.isValid()) {
                return false;
            }
            startOffset = fixMarker.getStartOffset();
            endOffset = fixMarker.getEndOffset();
            return startOffset <= offset && offset <= endOffset;
        }
        return false;
    }

    @Nullable
    public static List<LineMarkerInfo> getLineMarkers(@NotNull Document document, Project project) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getLineMarkers"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        return (List)markup.getUserData(MARKERS_IN_EDITOR_DOCUMENT_KEY);
    }

    static void setLineMarkers(@NotNull Document document, List<LineMarkerInfo> lineMarkers, Project project) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLineMarkers"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        markup.putUserData(MARKERS_IN_EDITOR_DOCUMENT_KEY, lineMarkers);
    }

    void setLastIntentionHint(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions, boolean hasToRecreate) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (!editor.getSettings().isShowIntentionBulb()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.hideLastIntentionHint();
        IntentionHintComponent hintComponent = IntentionHintComponent.showIntentionHint(project, file, editor, intentions, false);
        if (hasToRecreate) {
            hintComponent.recreate();
        }
        this.myLastIntentionHint = hintComponent;
    }

    void hideLastIntentionHint() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        IntentionHintComponent hint = this.myLastIntentionHint;
        if (hint != null && hint.isVisible()) {
            hint.hide();
            this.myLastIntentionHint = null;
        }
    }

    @Nullable
    IntentionHintComponent getLastIntentionHint() {
        return this.myLastIntentionHint;
    }

    public void writeExternal(@NotNull Element parentNode) throws WriteExternalException {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "writeExternal"));
        }
        Element disableHintsElement = new Element(DISABLE_HINTS_TAG);
        parentNode.addContent(disableHintsElement);
        ArrayList<String> array = new ArrayList<String>();
        for (VirtualFile file : this.myDisabledHintsFiles) {
            if (!file.isValid()) continue;
            array.add(file.getUrl());
        }
        Collections.sort(array);
        for (String url : array) {
            Element fileElement = new Element(FILE_TAG);
            fileElement.setAttribute(URL_ATT, url);
            disableHintsElement.addContent(fileElement);
        }
    }

    public void readExternal(@NotNull Element parentNode) throws InvalidDataException {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "readExternal"));
        }
        this.myDisabledHintsFiles.clear();
        Element element = parentNode.getChild(DISABLE_HINTS_TAG);
        if (element != null) {
            for (Element o : element.getChildren(FILE_TAG)) {
                VirtualFile file;
                Element e = o;
                String url = e.getAttributeValue(URL_ATT);
                if (url == null || (file = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
                this.myDisabledHintsFiles.add(file);
            }
        }
    }

    @NotNull
    private Runnable createUpdateRunnable() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (DaemonCodeAnalyzerImpl.this.myDisposed || !DaemonCodeAnalyzerImpl.this.myProject.isInitialized() || PowerSaveMode.isEnabled()) {
                    return;
                }
                if (HeavyProcessLatch.INSTANCE.isRunning()) {
                    if (DaemonCodeAnalyzerImpl.this.myAlarm.isEmpty()) {
                        DaemonCodeAnalyzerImpl.this.myAlarm.addRequest(DaemonCodeAnalyzerImpl.this.myUpdateRunnable, ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzerImpl.this).mySettings.AUTOREPARSE_DELAY);
                    }
                    return;
                }
                Editor activeEditor = FileEditorManager.getInstance((Project)DaemonCodeAnalyzerImpl.this.myProject).getSelectedTextEditor();
                final PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)DaemonCodeAnalyzerImpl.this.myProject);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PassExecutorService.log(DaemonCodeAnalyzerImpl.this.getUpdateProgress(), null, "Update Runnable. myUpdateByTimerEnabled:", DaemonCodeAnalyzerImpl.this.myUpdateByTimerEnabled, " something disposed:", PowerSaveMode.isEnabled() || DaemonCodeAnalyzerImpl.this.myDisposed || !DaemonCodeAnalyzerImpl.this.myProject.isInitialized(), " activeEditors:", DaemonCodeAnalyzerImpl.this.myProject.isDisposed() ? null : DaemonCodeAnalyzerImpl.this.getSelectedEditors());
                        if (!DaemonCodeAnalyzerImpl.this.myUpdateByTimerEnabled) {
                            return;
                        }
                        if (DaemonCodeAnalyzerImpl.this.myDisposed) {
                            return;
                        }
                        ApplicationManager.getApplication().assertIsDispatchThread();
                        Collection activeEditors = DaemonCodeAnalyzerImpl.this.getSelectedEditors();
                        if (activeEditors.isEmpty()) {
                            return;
                        }
                        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                            return;
                        }
                        if (documentManager.hasUncommitedDocuments()) {
                            documentManager.cancelAndRunWhenAllCommitted("restart daemon when all committed", this);
                            return;
                        }
                        THashMap passes = new THashMap(activeEditors.size());
                        for (FileEditor fileEditor : activeEditors) {
                            BackgroundEditorHighlighter highlighter = fileEditor.getBackgroundHighlighter();
                            if (highlighter == null) continue;
                            HighlightingPass[] highlightingPasses = highlighter.createPassesForEditor();
                            passes.put(fileEditor, highlightingPasses);
                        }
                        DaemonCodeAnalyzerImpl.this.cancelUpdateProgress(true, "Cancel by alarm");
                        DaemonCodeAnalyzerImpl.this.myAlarm.cancelAllRequests();
                        DaemonProgressIndicator progress = DaemonCodeAnalyzerImpl.this.createUpdateProgress();
                        DaemonCodeAnalyzerImpl.this.myPassExecutorService.submitPasses((Map<FileEditor, HighlightingPass[]>)passes, progress);
                    }
                };
                if (activeEditor == null) {
                    runnable.run();
                } else {
                    documentManager.cancelAndRunWhenAllCommitted("start daemon when all committed", runnable);
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "createUpdateRunnable"));
        }
        return runnable;
    }

    @NotNull
    private synchronized DaemonProgressIndicator createUpdateProgress() {
        DaemonProgressIndicator progress = new DaemonProgressIndicator(){

            @Override
            public void stopIfRunning() {
                super.stopIfRunning();
                ((DaemonCodeAnalyzer.DaemonListener)DaemonCodeAnalyzerImpl.this.myProject.getMessageBus().syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC)).daemonFinished();
            }
        };
        progress.start();
        this.myUpdateProgress = progress;
        DaemonProgressIndicator daemonProgressIndicator = progress;
        if (daemonProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "createUpdateProgress"));
        }
        return daemonProgressIndicator;
    }

    public void autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "autoImportReferenceAtCursor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "autoImportReferenceAtCursor"));
        }
        for (ReferenceImporter importer : (ReferenceImporter[])Extensions.getExtensions(ReferenceImporter.EP_NAME)) {
            if (importer.autoImportReferenceAtCursor(editor, file)) break;
        }
    }

    synchronized DaemonProgressIndicator getUpdateProgress() {
        return this.myUpdateProgress;
    }

    public void allowToInterrupt(boolean can) {
        this.allowToInterrupt = can;
    }

    @NotNull
    private Collection<FileEditor> getSelectedEditors() {
        FileEditor[] tabEditors;
        List<Editor> editors = this.getActiveEditors();
        THashSet activeTextEditors = new THashSet(editors.size());
        for (Editor editor : editors) {
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
            activeTextEditors.add(textEditor);
        }
        if (ApplicationManager.getApplication().getCurrentModalityState() != ModalityState.NON_MODAL) {
            THashSet tHashSet = activeTextEditors;
            if (tHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getSelectedEditors"));
            }
            return tHashSet;
        }
        THashSet result = new THashSet();
        THashSet files = new THashSet(activeTextEditors.size());
        for (FileEditor tabEditor : tabEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
            VirtualFile file = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(tabEditor);
            if (file != null) {
                files.add(file);
            }
            result.add(tabEditor);
        }
        for (FileEditor fileEditor : activeTextEditors) {
            VirtualFile file = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(fileEditor);
            if (file != null && files.contains(file)) continue;
            result.add(fileEditor);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getSelectedEditors"));
        }
        return tHashSet;
    }

    @NotNull
    private List<Editor> getActiveEditors() {
        List<Editor> list = this.myEditorTracker.getActiveEditors();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getActiveEditors"));
        }
        return list;
    }
}

