/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

class CodeFoldingPass
extends EditorBoundHighlightingPass
implements PossiblyDumbAware {
    private static final Key<Boolean> THE_FIRST_TIME = Key.create((String)"FirstFoldingPass");
    private volatile Runnable myRunnable;

    CodeFoldingPass(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/CodeFoldingPass", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/CodeFoldingPass", "<init>"));
        }
        super(editor, file, false);
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/CodeFoldingPass", "doCollectInformation"));
        }
        boolean firstTime = CodeFoldingPass.isFirstTime(this.myFile, this.myEditor, THE_FIRST_TIME);
        this.myRunnable = CodeFoldingManager.getInstance(this.myProject).updateFoldRegionsAsync(this.myEditor, firstTime);
    }

    static boolean isFirstTime(PsiFile file, Editor editor, Key<Boolean> key) {
        return file.getUserData(key) == null || editor.getUserData(key) == null;
    }

    static void clearFirstTimeFlag(PsiFile file, Editor editor, Key<Boolean> key) {
        file.putUserData(key, (Object)Boolean.FALSE);
        editor.putUserData(key, (Object)Boolean.FALSE);
    }

    @Override
    public void doApplyInformationToEditor() {
        Runnable runnable = this.myRunnable;
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).getTopLevelFile((PsiElement)this.myFile) == this.myFile) {
            CodeFoldingPass.clearFirstTimeFlag(this.myFile, this.myEditor, THE_FIRST_TIME);
        }
    }

    public boolean isDumbAware() {
        return FoldingUpdate.supportsDumbModeFolding(this.myEditor);
    }
}

