/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManagerImpl;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;

@State(name="DaemonCodeAnalyzerSettings", storages={@Storage(file="$APP_CONFIG$/editor.codeinsight.xml")})
public class DaemonCodeAnalyzerSettingsImpl
extends DaemonCodeAnalyzerSettings
implements PersistentStateComponent<Element>,
Cloneable {
    @Override
    public boolean isCodeHighlightingChanged(DaemonCodeAnalyzerSettings oldSettings) {
        return !JDOMUtil.areElementsEqual((Element)((DaemonCodeAnalyzerSettingsImpl)oldSettings).getState(), (Element)this.getState());
    }

    public DaemonCodeAnalyzerSettingsImpl clone() {
        DaemonCodeAnalyzerSettingsImpl settings = new DaemonCodeAnalyzerSettingsImpl();
        settings.AUTOREPARSE_DELAY = this.AUTOREPARSE_DELAY;
        settings.SHOW_ADD_IMPORT_HINTS = this.SHOW_ADD_IMPORT_HINTS;
        settings.SHOW_METHOD_SEPARATORS = this.SHOW_METHOD_SEPARATORS;
        settings.NO_AUTO_IMPORT_PATTERN = this.NO_AUTO_IMPORT_PATTERN;
        settings.SHOW_SMALL_ICONS_IN_GUTTER = this.SHOW_SMALL_ICONS_IN_GUTTER;
        return settings;
    }

    public Element getState() {
        Element element = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        String profile = InspectionProfileManager.getInstance().getRootProfile().getName();
        if (!"Default".equals(profile)) {
            element.setAttribute("profile", profile);
        }
        return element;
    }

    public void loadState(Element state2) {
        XmlSerializer.deserializeInto((Object)this, (Element)state2);
        InspectionProfileManagerImpl inspectionProfileManager = InspectionProfileManagerImpl.getInstanceImpl();
        inspectionProfileManager.getConverter().storeEditorHighlightingProfile(state2, new InspectionProfileImpl("EditorHighlightingSettings"));
        inspectionProfileManager.setRootProfile(StringUtil.notNullize((String)state2.getAttributeValue("profile"), (String)"Default"));
    }
}

