/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.actions;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.awt.event.InputEvent;

public abstract class BaseCodeCompletionAction
extends AnAction
implements HintManagerImpl.ActionToIgnore,
DumbAware {
    protected BaseCodeCompletionAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    protected static void invokeCompletion(AnActionEvent e, CompletionType type, int time) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        assert (project != null);
        assert (editor != null);
        InputEvent inputEvent = e.getInputEvent();
        new CodeCompletionHandlerBase(type).invokeCompletion(project, editor, time, inputEvent != null && inputEvent.getModifiers() != 0, false);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        e.getPresentation().setEnabled(false);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
            return;
        }
        e.getPresentation().setEnabled(true);
    }
}

