/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionDataEP;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithPsiElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionUtil {
    public static final Key<TailType> TAIL_TYPE_ATTR = LookupItem.TAIL_TYPE_ATTR;
    private static final CompletionData ourGenericCompletionData = new CompletionData(){
        {
            CompletionVariant variant = new CompletionVariant(PsiElement.class, TrueFilter.INSTANCE);
            variant.addCompletionFilter(TrueFilter.INSTANCE, TailType.NONE);
            this.registerVariant(variant);
        }
    };
    private static final HashMap<FileType, NotNullLazyValue<CompletionData>> ourCustomCompletionDatas = new HashMap();
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz ".trim();

    public static boolean startsWith(String text, String prefix) {
        return CompletionUtil.toLowerCase(text).startsWith(CompletionUtil.toLowerCase(prefix));
    }

    private static String toLowerCase(String text) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        switch (settings.COMPLETION_CASE_SENSITIVE) {
            case 2: {
                return text.toLowerCase();
            }
            case 3: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(text.toLowerCase());
                if (buffer.length() > 0) {
                    buffer.setCharAt(0, text.charAt(0));
                }
                return buffer.toString();
            }
        }
        return text;
    }

    @Nullable
    public static CompletionData getCompletionDataByElement(@Nullable PsiElement position, @NotNull PsiFile originalFile) {
        CompletionData mainData;
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/codeInsight/completion/CompletionUtil", "getCompletionDataByElement"));
        }
        if (position == null) {
            return null;
        }
        PsiElement parent = position.getParent();
        Language language = parent == null ? position.getLanguage() : parent.getLanguage();
        LanguageFileType fileType = language.getAssociatedFileType();
        if (fileType != null && (mainData = CompletionUtil.getCompletionDataByFileType((FileType)fileType)) != null) {
            return mainData;
        }
        mainData = CompletionUtil.getCompletionDataByFileType(originalFile.getFileType());
        return mainData != null ? mainData : ourGenericCompletionData;
    }

    @Deprecated
    public static void registerCompletionData(FileType fileType, NotNullLazyValue<CompletionData> completionData) {
        ourCustomCompletionDatas.put((Object)fileType, completionData);
    }

    @Deprecated
    public static void registerCompletionData(FileType fileType, final CompletionData completionData) {
        CompletionUtil.registerCompletionData(fileType, new NotNullLazyValue<CompletionData>(){

            @NotNull
            protected CompletionData compute() {
                CompletionData completionData2 = completionData;
                if (completionData2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionUtil$2", "compute"));
                }
                return completionData2;
            }
        });
    }

    @Nullable
    public static CompletionData getCompletionDataByFileType(FileType fileType) {
        for (CompletionDataEP ep : (CompletionDataEP[])Extensions.getExtensions(CompletionDataEP.EP_NAME)) {
            if (!ep.fileType.equals(fileType.getName())) continue;
            return ep.getHandler();
        }
        NotNullLazyValue lazyValue = (NotNullLazyValue)ourCustomCompletionDatas.get((Object)fileType);
        return lazyValue == null ? null : (CompletionData)lazyValue.getValue();
    }

    public static boolean shouldShowFeature(CompletionParameters parameters, @NonNls String id) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(id, parameters.getPosition().getProject())) {
            FeatureUsageTracker.getInstance().triggerFeatureShown(id);
            return true;
        }
        return false;
    }

    public static String findJavaIdentifierPrefix(CompletionParameters parameters) {
        return CompletionUtil.findJavaIdentifierPrefix(parameters.getPosition(), parameters.getOffset());
    }

    public static String findJavaIdentifierPrefix(PsiElement insertedElement, int offset) {
        return CompletionUtil.findIdentifierPrefix(insertedElement, offset, (ElementPattern<Character>)PlatformPatterns.character().javaIdentifierPart(), (ElementPattern<Character>)PlatformPatterns.character().javaIdentifierStart());
    }

    public static String findReferenceOrAlphanumericPrefix(CompletionParameters parameters) {
        String prefix = CompletionUtil.findReferencePrefix(parameters);
        return prefix == null ? CompletionUtil.findAlphanumericPrefix(parameters) : prefix;
    }

    public static String findAlphanumericPrefix(CompletionParameters parameters) {
        return CompletionUtil.findIdentifierPrefix((PsiElement)parameters.getPosition().getContainingFile(), parameters.getOffset(), (ElementPattern<Character>)PlatformPatterns.character().letterOrDigit(), (ElementPattern<Character>)PlatformPatterns.character().letterOrDigit());
    }

    public static String findIdentifierPrefix(PsiElement insertedElement, int offset, ElementPattern<Character> idPart, ElementPattern<Character> idStart) {
        int start;
        if (insertedElement == null) {
            return "";
        }
        String text = insertedElement.getText();
        int offsetInElement = offset - insertedElement.getTextRange().getStartOffset();
        for (start = offsetInElement - 1; start >= 0 && idPart.accepts((Object)Character.valueOf(text.charAt(start))); --start) {
        }
        while (start + 1 < offsetInElement && !idStart.accepts((Object)Character.valueOf(text.charAt(start + 1)))) {
            ++start;
        }
        return text.substring(start + 1, offsetInElement).trim();
    }

    @Nullable
    public static String findReferencePrefix(CompletionParameters parameters) {
        return CompletionData.getReferencePrefix(parameters.getPosition(), parameters.getOffset());
    }

    static InsertionContext emulateInsertion(InsertionContext oldContext, int newStart, LookupElement item) {
        InsertionContext newContext = CompletionUtil.newContext(oldContext, item);
        CompletionUtil.emulateInsertion(item, newStart, newContext);
        return newContext;
    }

    private static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement) {
        Editor editor = oldContext.getEditor();
        return new InsertionContext(new OffsetMap(editor.getDocument()), '\u0000', new LookupElement[]{forElement}, oldContext.getFile(), editor, oldContext.shouldAddCompletionChar());
    }

    public static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement, int startOffset, int tailOffset) {
        InsertionContext context = CompletionUtil.newContext(oldContext, forElement);
        CompletionUtil.setOffsets(context, startOffset, tailOffset);
        return context;
    }

    public static void emulateInsertion(LookupElement item, int offset, InsertionContext context) {
        CompletionUtil.setOffsets(context, offset, offset);
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        String lookupString = item.getLookupString();
        document.insertString(offset, (CharSequence)lookupString);
        editor.getCaretModel().moveToOffset(context.getTailOffset());
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
        item.handleInsert(context);
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
    }

    private static void setOffsets(InsertionContext context, int offset, int tailOffset) {
        OffsetMap offsetMap = context.getOffsetMap();
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, offset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, tailOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, tailOffset);
        context.setTailOffset(tailOffset);
    }

    @Nullable
    public static PsiElement getTargetElement(LookupElement lookupElement) {
        PsiElement element;
        PsiElement psiElement = lookupElement.getPsiElement();
        if (psiElement != null) {
            return CompletionUtil.getOriginalElement(psiElement);
        }
        Object object = lookupElement.getObject();
        if (object instanceof LookupValueWithPsiElement && (element = ((LookupValueWithPsiElement)object).getElement()) != null) {
            return CompletionUtil.getOriginalElement(element);
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/codeInsight/completion/CompletionUtil", "getOriginalElement"));
        }
        return CompletionUtilCoreImpl.getOriginalElement(psi);
    }

    @NotNull
    public static <T extends PsiElement> T getOriginalOrSelf(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/codeInsight/completion/CompletionUtil", "getOriginalOrSelf"));
        }
        T element = CompletionUtil.getOriginalElement(psi);
        T t = element == null ? psi : element;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionUtil", "getOriginalOrSelf"));
        }
        return t;
    }

    public static LinkedHashSet<String> sortMatching(PrefixMatcher matcher, Collection<String> _names) {
        ProgressManager.checkCanceled();
        ArrayList<String> sorted = new ArrayList<String>();
        for (String name : _names) {
            if (!matcher.prefixMatches(name)) continue;
            sorted.add(name);
        }
        ProgressManager.checkCanceled();
        Collections.sort(sorted, String.CASE_INSENSITIVE_ORDER);
        ProgressManager.checkCanceled();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String name : sorted) {
            if (!matcher.isStartMatch(name)) continue;
            result.add(name);
        }
        ProgressManager.checkCanceled();
        result.addAll(sorted);
        return result;
    }
}

