/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.ReformatCodeProcessor");
    private final Collection<TextRange> myRanges = new ArrayList<TextRange>();
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);

    public ReformatCodeProcessor(Project project, boolean processChangedTextOnly) {
        super(project, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor, boolean processChangedTextOnly) {
        super(processor, COMMAND_NAME, PROGRESS_TEXT);
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, Module module, boolean processChangedTextOnly) {
        super(project, module, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile file, @Nullable TextRange range, boolean processChangedTextOnly) {
        super(project, file, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        if (range != null) {
            this.myRanges.add(range);
        }
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project, files, COMMAND_NAME, postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project, files, PROGRESS_TEXT, commandName, postRunnable, processChangedTextOnly);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(final @NotNull PsiFile file, final boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareTask"));
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
                try {
                    Collection ranges = ReformatCodeProcessor.this.getRangesToFormat(processChangedTextOnly, file);
                    CodeStyleManager.getInstance((Project)ReformatCodeProcessor.this.myProject).reformatText(file, ranges);
                    Boolean bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
                    return bl;
                }
                catch (FilesTooBigForDiffException e) {
                    LOG.info("Error while calculating changed ranges for: " + file.getVirtualFile(), (Throwable)e);
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        Notification notification = new Notification(ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.groupId", (Object[])new Object[0]), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.title", (Object[])new Object[0]), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.text", (Object[])new Object[]{file.getName()}), NotificationType.INFORMATION);
                        notification.notify(file.getProject());
                    }
                    Boolean bl = false;
                    return bl;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    ReformatCodeProcessor.this.myRanges.clear();
                }
            }
        });
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareTask"));
        }
        return futureTask;
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(boolean processChangedTextOnly, PsiFile file) throws FilesTooBigForDiffException {
        if (processChangedTextOnly) {
            List<TextRange> list = FormatChangedTextUtil.getChangedTextRanges(this.myProject, file);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "getRangesToFormat"));
            }
            return list;
        }
        ArrayList arrayList = !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file.getTextRange()});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "getRangesToFormat"));
        }
        return arrayList;
    }
}

