/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.RearrangeCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeCodeProcessor
extends AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance(RearrangeCodeProcessor.class);
    public static final String COMMAND_NAME = "Rearrange code";
    public static final String PROGRESS_TEXT = "Rearranging code...";
    private SelectionModel mySelectionModel;

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        if (previousProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousProcessor", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
    }

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @NotNull SelectionModel selectionModel) {
        if (previousProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousProcessor", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull Project project, @NotNull PsiFile file, @Nullable SelectionModel selectionModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(project, file, PROGRESS_TEXT, COMMAND_NAME, false);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull Project project, @NotNull PsiFile[] files, @NotNull String commandName, @Nullable Runnable postRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(project, files, PROGRESS_TEXT, commandName, postRunnable, false);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(final @NotNull PsiFile file, final boolean processChangedTextOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    Collection<TextRange> ranges = processChangedTextOnly ? FormatChangedTextUtil.getChangedTextRanges(RearrangeCodeProcessor.this.myProject, file) : RearrangeCodeProcessor.this.getRangesToFormat(file);
                    RearrangeCommand rearranger = new RearrangeCommand(RearrangeCodeProcessor.this.myProject, file, RearrangeCodeProcessor.COMMAND_NAME, ranges);
                    if (rearranger.couldRearrange()) {
                        rearranger.run();
                    }
                    return true;
                }
                catch (FilesTooBigForDiffException e) {
                    LOG.info("Error while calculating changed ranges for: " + file.getVirtualFile(), (Throwable)e);
                    return false;
                }
            }
        });
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        return futureTask;
    }

    public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "getRangesToFormat"));
        }
        SmartList ranges = new SmartList();
        if (this.mySelectionModel != null && this.mySelectionModel.hasSelection()) {
            ranges.add(TextRange.create((int)this.mySelectionModel.getSelectionStart(), (int)this.mySelectionModel.getSelectionEnd()));
        } else if (this.mySelectionModel != null && this.mySelectionModel.hasBlockSelection()) {
            int[] starts = this.mySelectionModel.getBlockSelectionStarts();
            int[] ends = this.mySelectionModel.getBlockSelectionEnds();
            for (int i = 0; i < starts.length; ++i) {
                ranges.add(TextRange.create((int)starts[i], (int)ends[i]));
            }
        } else {
            ranges.add(TextRange.create((int)0, (int)file.getTextLength()));
        }
        return ranges;
    }
}

