/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEmmetConfigurable
implements UnnamedConfigurable,
Disposable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JBCheckBox myEnableEmmetJBCheckBox;
    private JBCheckBox myEnablePreviewJBCheckBox;
    private CheckBoxList<ZenCodingFilter> myFiltersCheckBoxList;
    private JPanel myFiltersListPanel;

    public XmlEmmetConfigurable() {
        this.$$$setupUI$$$();
        this.myEnableEmmetJBCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = XmlEmmetConfigurable.this.myEnableEmmetJBCheckBox.isSelected();
                XmlEmmetConfigurable.this.myEnablePreviewJBCheckBox.setEnabled(selected);
                XmlEmmetConfigurable.this.myFiltersCheckBoxList.setEnabled(selected);
            }
        });
        this.myFiltersListPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)XmlBundle.message((String)"emmet.filters.enabled.by.default", (Object[])new Object[0]), (boolean)false));
        this.myFiltersCheckBoxList.setItems(ZenCodingFilter.getInstances(), (Function)new Function<ZenCodingFilter, String>(){

            public String fun(ZenCodingFilter filter) {
                return filter.getDisplayName();
            }
        });
    }

    public void dispose() {
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        return emmetOptions.isEmmetEnabled() != this.myEnableEmmetJBCheckBox.isSelected() || emmetOptions.isPreviewEnabled() != this.myEnablePreviewJBCheckBox.isSelected() || !((Object)emmetOptions.getFiltersEnabledByDefault()).equals(this.enabledFilters());
    }

    public void apply() throws ConfigurationException {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        emmetOptions.setEmmetEnabled(this.myEnableEmmetJBCheckBox.isSelected());
        emmetOptions.setPreviewEnabled(this.myEnablePreviewJBCheckBox.isSelected());
        emmetOptions.setFiltersEnabledByDefault(this.enabledFilters());
    }

    public void reset() {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        this.myEnableEmmetJBCheckBox.setSelected(emmetOptions.isEmmetEnabled());
        this.myEnablePreviewJBCheckBox.setEnabled(emmetOptions.isEmmetEnabled());
        this.myEnablePreviewJBCheckBox.setSelected(emmetOptions.isPreviewEnabled());
        Set<String> enabledByDefault = emmetOptions.getFiltersEnabledByDefault();
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            this.myFiltersCheckBoxList.setItemSelected((Object)filter, enabledByDefault.contains(filter.getSuffix()));
        }
    }

    public void disposeUIResources() {
    }

    @NotNull
    private Set<String> enabledFilters() {
        HashSet result = ContainerUtil.newHashSet();
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            if (!this.myFiltersCheckBoxList.isItemSelected((Object)filter)) continue;
            result.add(filter.getSuffix());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/XmlEmmetConfigurable", "enabledFilters"));
        }
        return hashSet;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CheckBoxList checkBoxList;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"XML", (int)0, (int)0, null, null));
        this.myEnableEmmetJBCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/XmlBundle").getString("emmet.enable.label"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myEnablePreviewJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/XmlBundle").getString("emmet.enable.preview"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myFiltersListPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFiltersCheckBoxList = checkBoxList = new CheckBoxList();
        jPanel.add((Component)checkBoxList, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

