/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OptionsPanelImpl
extends JPanel
implements OptionsPanel {
    private final JList myOptionsList;
    private final ColorAndFontDescriptionPanel myOptionsPanel;
    private final ColorAndFontOptions myOptions;
    private final SchemesPanel mySchemesProvider;
    private final String myCategoryName;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public OptionsPanelImpl(ColorAndFontDescriptionPanel optionsPanel, ColorAndFontOptions options, SchemesPanel schemesProvider, String categoryName) {
        super(new BorderLayout());
        this.myOptions = options;
        this.mySchemesProvider = schemesProvider;
        this.myCategoryName = categoryName;
        optionsPanel.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ColorAndFontSettingsListener)OptionsPanelImpl.this.myDispatcher.getMulticaster()).settingsChanged();
            }
        });
        this.myOptionsList = new JBList();
        this.myOptionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!OptionsPanelImpl.this.mySchemesProvider.areSchemesLoaded()) {
                    return;
                }
                OptionsPanelImpl.this.processListValueChanged();
            }
        });
        this.myOptionsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ColorAndFontDescription) {
                    this.setIcon(((ColorAndFontDescription)value).getIcon());
                    this.setToolTipText(((ColorAndFontDescription)value).getToolTip());
                }
                return component;
            }
        });
        this.myOptionsList.setModel(new DefaultListModel());
        this.myOptionsList.setSelectionMode(0);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myOptionsList);
        scrollPane.setPreferredSize(new Dimension(230, 60));
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)scrollPane, "Center");
        north.add((Component)optionsPanel, "East");
        this.myOptionsPanel = optionsPanel;
        this.add((Component)north, "North");
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    private void processListValueChanged() {
        Object selectedValue = this.myOptionsList.getSelectedValue();
        ColorAndFontDescription description = (ColorAndFontDescription)selectedValue;
        ColorAndFontDescriptionPanel optionsPanel = this.myOptionsPanel;
        if (description == null) {
            optionsPanel.resetDefault();
            return;
        }
        optionsPanel.reset(description);
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectedOptionChanged(description);
    }

    private void fillOptionsList() {
        EditorSchemeAttributeDescriptor[] descriptions;
        int selIndex = this.myOptionsList.getSelectedIndex();
        DefaultListModel listModel = (DefaultListModel)this.myOptionsList.getModel();
        listModel.removeAllElements();
        for (EditorSchemeAttributeDescriptor description : descriptions = this.myOptions.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            listModel.addElement(description);
        }
        if (selIndex >= 0) {
            this.myOptionsList.setSelectedIndex(selIndex);
        }
        ListScrollingUtil.ensureSelectionExists((JList)this.myOptionsList);
        Object selected = this.myOptionsList.getSelectedValue();
        if (selected instanceof EditorSchemeAttributeDescriptor) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectedOptionChanged(selected);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void updateOptionsList() {
        this.fillOptionsList();
        this.processListValueChanged();
    }

    @Override
    public Runnable showOption(String option) {
        String lowerCaseOption = option.toLowerCase();
        DefaultListModel model = (DefaultListModel)this.myOptionsList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            String type;
            Object o = model.get(i);
            if (!(o instanceof EditorSchemeAttributeDescriptor) || !(type = ((EditorSchemeAttributeDescriptor)o).getType()).toLowerCase().contains(lowerCaseOption) && !o.toString().toLowerCase().contains(lowerCaseOption)) continue;
            final int i1 = i;
            return new Runnable(){

                @Override
                public void run() {
                    ListScrollingUtil.selectItem((JList)OptionsPanelImpl.this.myOptionsList, (int)i1);
                }
            };
        }
        return null;
    }

    @Override
    public void applyChangesToScheme() {
        Object selectedValue = this.myOptionsList.getSelectedValue();
        if (selectedValue instanceof ColorAndFontDescription) {
            this.myOptionsPanel.apply((ColorAndFontDescription)selectedValue, this.myOptions.getSelectedScheme());
        }
    }

    @Override
    public void selectOption(String typeToSelect) {
        DefaultListModel model = (DefaultListModel)this.myOptionsList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            Object o = model.get(i);
            if (!(o instanceof EditorSchemeAttributeDescriptor) || !typeToSelect.equals(((EditorSchemeAttributeDescriptor)o).getType())) continue;
            ListScrollingUtil.selectItem((JList)this.myOptionsList, (int)i);
            return;
        }
    }

    @Override
    public Set<String> processListOptions() {
        EditorSchemeAttributeDescriptor[] descriptions;
        HashSet<String> result = new HashSet<String>();
        for (EditorSchemeAttributeDescriptor description : descriptions = this.myOptions.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            result.add(description.toString());
        }
        return result;
    }
}

