/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.util;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class ArrangementRuleIndexControl
extends JPanel {
    private boolean myIsError;
    private final int myDiameter;
    private final int myHeight;
    private int myIndex;
    private char[] myChars;
    private int myIndexWidth;
    private int myBaseLine;

    public ArrangementRuleIndexControl(int diameter, int height) {
        this.myDiameter = diameter;
        this.myHeight = height;
        this.setOpaque(true);
    }

    public void setIndex(int index) {
        if (index == this.myIndex) {
            return;
        }
        this.myIndex = index;
        String s = String.valueOf(index);
        this.myChars = s.toCharArray();
        this.myIndexWidth = this.getFontMetrics(this.getFont()).charsWidth(this.myChars, 0, this.myChars.length);
        this.setPreferredSize(new Dimension(this.myDiameter, this.myDiameter));
        this.invalidate();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.myDiameter + 2, this.myDiameter + 2);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myChars == null) {
            return;
        }
        g.setColor((Color)(this.myIsError ? JBColor.red : UIUtil.getBorderColor()));
        Rectangle bounds = this.getBounds();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int y = Math.max(0, this.myBaseLine - this.myHeight - (this.myDiameter - this.myHeight) / 2);
        g.drawOval(0, y, this.myDiameter, this.myDiameter);
        g.drawChars(this.myChars, 0, this.myChars.length, (bounds.width - this.myIndexWidth) / 2, this.myBaseLine);
    }

    public void setError(boolean isError) {
        this.myIsError = isError;
    }

    public void setBaseLine(int baseLine) {
        this.myBaseLine = baseLine;
    }
}

