/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.LanguageSelector;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewCodeStyleSettingsPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel");
    private final Configurable myTab;

    public NewCodeStyleSettingsPanel(@NotNull Configurable tab) {
        if (tab == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tab", "com/intellij/application/options/codeStyle/NewCodeStyleSettingsPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myTab = tab;
        JComponent component = this.myTab.createComponent();
        this.add((Component)component, "Center");
    }

    public boolean isModified() {
        return this.myTab.isModified();
    }

    public void updatePreview() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).getPanel().onSomethingChanged();
        }
    }

    public void apply() throws ConfigurationException {
        if (this.myTab.isModified()) {
            this.myTab.apply();
        }
    }

    @Nullable
    public String getHelpTopic() {
        return this.myTab.getHelpTopic();
    }

    public void dispose() {
        this.myTab.disposeUIResources();
    }

    public void reset() {
        this.myTab.reset();
        this.updatePreview();
    }

    public String getDisplayName() {
        return this.myTab.getDisplayName();
    }

    public void setModel(CodeStyleSchemesModel model) {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).setModel(model);
        }
    }

    public void setLanguageSelector(LanguageSelector langSelector) {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            CodeStyleAbstractConfigurable configurable = (CodeStyleAbstractConfigurable)this.myTab;
            configurable.getPanel().setLanguageSelector(langSelector);
        }
    }

    public void onSomethingChanged() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).onSomethingChanged();
        }
    }

    public void setLanguage(Language language) {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            CodeStyleAbstractConfigurable configurable = (CodeStyleAbstractConfigurable)this.myTab;
            configurable.getPanel().setPanelLanguage(language);
        }
    }

    public Set<String> processListOptions() {
        if (this.myTab instanceof OptionsContainingConfigurable) {
            return ((OptionsContainingConfigurable)this.myTab).processListOptions();
        }
        return Collections.emptySet();
    }

    @Nullable
    public CodeStyleAbstractPanel getSelectedPanel() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            return ((CodeStyleAbstractConfigurable)this.myTab).getPanel();
        }
        return null;
    }
}

