/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class CodeStyleBlankLinesPanel
extends MultilanguageCodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.codeStyle.CodeStyleBlankLinesPanel");
    private final List<IntOption> myOptions = new ArrayList<IntOption>();
    private final Set<String> myAllowedOptions = new HashSet<String>();
    private boolean myAllOptionsAllowed = false;
    private boolean myIsFirstUpdate = true;
    private final Map<String, String> myRenamedFields = new THashMap();
    private final MultiMap<String, Trinity<Class<? extends CustomCodeStyleSettings>, String, String>> myCustomOptions = new MultiMap();
    private final JPanel myPanel = new JPanel(new GridBagLayout());

    public CodeStyleBlankLinesPanel(CodeStyleSettings settings) {
        super(settings);
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        OptionGroup keepBlankLinesOptionsGroup = this.createKeepBlankLinesOptionsGroup();
        OptionGroup blankLinesOptionsGroup = this.createBlankLinesOptionsGroup();
        if (keepBlankLinesOptionsGroup != null) {
            keepBlankLinesOptionsGroup.setAnchor(keepBlankLinesOptionsGroup.findAnchor());
            optionsPanel.add((Component)keepBlankLinesOptionsGroup.createPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (blankLinesOptionsGroup != null) {
            blankLinesOptionsGroup.setAnchor(blankLinesOptionsGroup.findAnchor());
            optionsPanel.add((Component)blankLinesOptionsGroup.createPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{keepBlankLinesOptionsGroup, blankLinesOptionsGroup});
        optionsPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)optionsPanel);
        scroll.setBorder(null);
        scroll.setMinimumSize(new Dimension(optionsPanel.getPreferredSize().width + scroll.getVerticalScrollBar().getPreferredSize().width + 5, -1));
        scroll.setPreferredSize(scroll.getMinimumSize());
        this.myPanel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 1, new Insets(0, 0, 0, 5), 0, 0));
        JPanel previewPanel = CodeStyleBlankLinesPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.myIsFirstUpdate = false;
    }

    @Override
    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS;
    }

    @Nullable
    private OptionGroup createBlankLinesOptionsGroup() {
        OptionGroup optionGroup = new OptionGroup(BLANK_LINES);
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.before.package.statement", (Object[])new Object[0]), "BLANK_LINES_BEFORE_PACKAGE");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.after.package.statement", (Object[])new Object[0]), "BLANK_LINES_AFTER_PACKAGE");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.before.imports", (Object[])new Object[0]), "BLANK_LINES_BEFORE_IMPORTS");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.after.imports", (Object[])new Object[0]), "BLANK_LINES_AFTER_IMPORTS");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.around.class", (Object[])new Object[0]), "BLANK_LINES_AROUND_CLASS");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.after.class.header", (Object[])new Object[0]), "BLANK_LINES_AFTER_CLASS_HEADER");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.after.anonymous.class.header", (Object[])new Object[0]), "BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER");
        this.createOption(optionGroup, "Around field in interface:", "BLANK_LINES_AROUND_FIELD_IN_INTERFACE");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.around.field", (Object[])new Object[0]), "BLANK_LINES_AROUND_FIELD");
        this.createOption(optionGroup, "Around method in interface:", "BLANK_LINES_AROUND_METHOD_IN_INTERFACE");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.around.method", (Object[])new Object[0]), "BLANK_LINES_AROUND_METHOD");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.blanklines.before.method.body", (Object[])new Object[0]), "BLANK_LINES_BEFORE_METHOD_BODY");
        this.initCustomOptions(optionGroup, BLANK_LINES);
        if (optionGroup.getComponents().length == 0) {
            return null;
        }
        return optionGroup;
    }

    @Nullable
    private OptionGroup createKeepBlankLinesOptionsGroup() {
        OptionGroup optionGroup = new OptionGroup(BLANK_LINES_KEEP);
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.keep.blanklines.in.declarations", (Object[])new Object[0]), "KEEP_BLANK_LINES_IN_DECLARATIONS");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.keep.blanklines.in.code", (Object[])new Object[0]), "KEEP_BLANK_LINES_IN_CODE");
        this.createOption(optionGroup, ApplicationBundle.message((String)"editbox.keep.blanklines.before.rbrace", (Object[])new Object[0]), "KEEP_BLANK_LINES_BEFORE_RBRACE");
        this.initCustomOptions(optionGroup, BLANK_LINES_KEEP);
        if (optionGroup.getComponents().length == 0) {
            return null;
        }
        return optionGroup;
    }

    private void initCustomOptions(OptionGroup optionGroup, String groupName) {
        for (Trinity each : this.myCustomOptions.get((Object)groupName)) {
            this.doCreateOption(optionGroup, (String)each.third, new IntOption((Class)each.first, (String)each.second), (String)each.second);
        }
    }

    private void createOption(OptionGroup optionGroup, String title, String fieldName) {
        if (this.myAllOptionsAllowed || this.myAllowedOptions.contains(fieldName)) {
            this.doCreateOption(optionGroup, title, new IntOption(fieldName), fieldName);
        }
    }

    private void doCreateOption(OptionGroup optionGroup, String title, IntOption option, String fieldName) {
        String renamed = this.myRenamedFields.get(fieldName);
        if (renamed != null) {
            title = renamed;
        }
        JBLabel l = new JBLabel(title);
        optionGroup.add((JComponent)l, (JComponent)option.myTextField);
        this.myOptions.add(option);
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        for (IntOption option : this.myOptions) {
            option.setValue(option.getFieldValue(settings));
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        for (IntOption option : this.myOptions) {
            option.setFieldValue(settings, option.getValue());
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        for (IntOption option : this.myOptions) {
            if (option.getFieldValue(settings) == option.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    public void showAllStandardOptions() {
        this.myAllOptionsAllowed = true;
        for (IntOption option : this.myOptions) {
            option.myTextField.setEnabled(true);
        }
    }

    public void showStandardOptions(String ... optionNames) {
        if (this.myIsFirstUpdate) {
            Collections.addAll(this.myAllowedOptions, optionNames);
        }
        block0: for (IntOption option : this.myOptions) {
            option.myTextField.setEnabled(false);
            for (String optionName : optionNames) {
                if (!option.myTarget.getName().equals(optionName)) continue;
                option.myTextField.setEnabled(true);
                continue block0;
            }
        }
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, Object ... options) {
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName, Object ... options) {
        if (this.myIsFirstUpdate) {
            this.myCustomOptions.putValue((Object)groupName, (Object)Trinity.create(settingsClass, (Object)fieldName, (Object)title));
        }
        for (IntOption option : this.myOptions) {
            if (!option.myTarget.getName().equals(fieldName)) continue;
            option.myTextField.setEnabled(true);
        }
    }

    public void renameStandardOption(String fieldName, String newTitle) {
        if (this.myIsFirstUpdate) {
            this.myRenamedFields.put(fieldName, newTitle);
        }
        for (IntOption option : this.myOptions) {
            option.myTextField.invalidate();
        }
    }

    @Override
    protected void onLanguageChange(Language language) {
        this.resetImpl(this.getSettings());
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"title.blank.lines", (Object[])new Object[0]);
    }

    private class IntOption {
        private final JTextField myTextField;
        private final Field myTarget;
        private Class<? extends CustomCodeStyleSettings> myTargetClass;
        private int myCurrValue = Integer.MAX_VALUE;

        private IntOption(String fieldName) {
            this(CodeStyleSettings.class, fieldName, false);
        }

        private IntOption(Class<? extends CustomCodeStyleSettings> targetClass, String fieldName) {
            this(targetClass, fieldName, false);
            this.myTargetClass = targetClass;
        }

        private IntOption(Class<?> fieldClass, String fieldName, boolean dummy) {
            try {
                this.myTarget = fieldClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            this.myTextField = new JTextField(6);
            this.myTextField.setMinimumSize(new Dimension(30, this.myTextField.getMinimumSize().height));
        }

        private int getFieldValue(CodeStyleSettings settings) {
            try {
                if (this.myTargetClass != null) {
                    return this.myTarget.getInt(settings.getCustomSettings(this.myTargetClass));
                }
                CommonCodeStyleSettings commonSettings = settings.getCommonSettings(CodeStyleBlankLinesPanel.this.getSelectedLanguage());
                return this.myTarget.getInt(commonSettings);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public void setFieldValue(CodeStyleSettings settings, int value) {
            try {
                if (this.myTargetClass != null) {
                    this.myTarget.setInt(settings.getCustomSettings(this.myTargetClass), value);
                } else {
                    CommonCodeStyleSettings commonSettings = settings.getCommonSettings(CodeStyleBlankLinesPanel.this.getSelectedLanguage());
                    this.myTarget.setInt(commonSettings, value);
                }
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }

        private int getValue() {
            try {
                this.myCurrValue = Integer.parseInt(this.myTextField.getText());
                if (this.myCurrValue < 0) {
                    this.myCurrValue = 0;
                }
                if (this.myCurrValue > 10) {
                    this.myCurrValue = 10;
                }
            }
            catch (NumberFormatException e) {
                this.myCurrValue = 0;
            }
            return this.myCurrValue;
        }

        public void setValue(int fieldValue) {
            if (fieldValue != this.myCurrValue) {
                this.myCurrValue = fieldValue;
                this.myTextField.setText(String.valueOf(fieldValue));
            }
        }
    }
}

