/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.codeStyle.CodeStyleBlankLinesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSpacesPanel;
import com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.WrappingAndBracesPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabbedLanguageCodeStylePanel
extends CodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)("#" + TabbedLanguageCodeStylePanel.class.getName()));
    private CodeStyleAbstractPanel myActiveTab;
    private List<CodeStyleAbstractPanel> myTabs;
    private JPanel myPanel;
    private JTabbedPane myTabbedPane;
    private final PredefinedCodeStyle[] myPredefinedCodeStyles = this.getPredefinedStyles();
    private JPopupMenu myCopyFromMenu;

    protected TabbedLanguageCodeStylePanel(@Nullable Language language, CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super(language, currentSettings, settings);
    }

    protected void initTabs(CodeStyleSettings settings) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.getDefaultLanguage());
        this.addIndentOptionsTab(settings);
        if (provider != null && !provider.usesSharedPreview()) {
            this.addSpacesTab(settings);
            this.addWrappingAndBracesTab(settings);
            this.addBlankLinesTab(settings);
        }
    }

    protected void addIndentOptionsTab(CodeStyleSettings settings) {
        IndentOptionsEditor indentOptionsEditor;
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.getDefaultLanguage());
        if (provider != null && (indentOptionsEditor = provider.getIndentOptionsEditor()) != null) {
            MyIndentOptionsWrapper indentOptionsWrapper = new MyIndentOptionsWrapper(settings, provider, indentOptionsEditor);
            this.addTab(indentOptionsWrapper);
        }
    }

    protected void addSpacesTab(CodeStyleSettings settings) {
        this.addTab(new MySpacesPanel(settings));
    }

    protected void addBlankLinesTab(CodeStyleSettings settings) {
        this.addTab(new MyBlankLinesPanel(settings));
    }

    protected void addWrappingAndBracesTab(CodeStyleSettings settings) {
        this.addTab(new MyWrappingAndBracesPanel(settings));
    }

    private void ensureTabs() {
        if (this.myTabs == null) {
            this.myPanel = new JPanel();
            this.myPanel.setLayout(new BorderLayout());
            this.myTabbedPane = new JBTabbedPane();
            this.myTabs = new ArrayList<CodeStyleAbstractPanel>();
            this.myPanel.add(this.myTabbedPane);
            this.initTabs(this.getSettings());
        }
        assert (!this.myTabs.isEmpty());
    }

    public void showSetFrom(Object e) {
        Container component = (Container)e;
        Component[] components = component.getComponents();
        Component last = components[components.length - 1];
        this.initCopyFromMenu();
        this.myCopyFromMenu.show(last, 0, last.getHeight() + 3);
    }

    private void initCopyFromMenu() {
        if (this.myCopyFromMenu == null) {
            this.myCopyFromMenu = new JBPopupMenu();
            this.setupCopyFromMenu(this.myCopyFromMenu);
        }
    }

    protected final void addTab(CodeStyleAbstractPanel tab) {
        this.myTabs.add(tab);
        tab.setShouldUpdatePreview(true);
        this.addPanelToWatch(tab.getPanel());
        this.myTabbedPane.addTab(tab.getTabTitle(), tab.getPanel());
        if (this.myActiveTab == null) {
            this.myActiveTab = tab;
        }
    }

    private void addTab(Configurable configurable) {
        ConfigurableWrapper wrapper = new ConfigurableWrapper(configurable, this.getSettings());
        this.addTab(wrapper);
    }

    protected final void createTab(CodeStyleSettingsProvider provider) {
        if (provider.hasSettingsPage()) {
            return;
        }
        Configurable configurable = provider.createSettingsPage(this.getCurrentSettings(), this.getSettings());
        this.addTab(configurable);
    }

    @Override
    public final void setModel(CodeStyleSchemesModel model) {
        super.setModel(model);
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.setModel(model);
        }
    }

    @Override
    protected int getRightMargin() {
        this.ensureTabs();
        return this.myActiveTab.getRightMargin();
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        this.ensureTabs();
        return this.myActiveTab.createHighlighter(scheme);
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        this.ensureTabs();
        FileType fileType = this.myActiveTab.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/TabbedLanguageCodeStylePanel", "getFileType"));
        }
        return fileType;
    }

    @Override
    protected String getPreviewText() {
        this.ensureTabs();
        return this.myActiveTab.getPreviewText();
    }

    @Override
    protected void updatePreview(boolean useDefaultSample) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.updatePreview(useDefaultSample);
        }
    }

    @Override
    public void onSomethingChanged() {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.setShouldUpdatePreview(true);
            tab.onSomethingChanged();
        }
    }

    @Override
    protected void somethingChanged() {
        super.somethingChanged();
    }

    @Override
    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.apply(settings);
        }
    }

    @Override
    public void dispose() {
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            Disposer.dispose((Disposable)tab);
        }
        super.dispose();
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            if (!tab.isModified(settings)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.ensureTabs();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            tab.resetImpl(settings);
        }
    }

    @Override
    public void setupCopyFromMenu(JPopupMenu copyMenu) {
        super.setupCopyFromMenu(copyMenu);
        if (this.myPredefinedCodeStyles.length > 0) {
            JMenu langs = new JMenu("Language"){

                @Override
                public void paint(Graphics g) {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    super.paint(g);
                }
            };
            copyMenu.add(langs);
            this.fillLanguages(langs);
            JMenu predefined = new JMenu("Predefined Style"){

                @Override
                public void paint(Graphics g) {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    super.paint(g);
                }
            };
            copyMenu.add(predefined);
            this.fillPredefined(predefined);
        } else {
            this.fillLanguages(copyMenu);
        }
    }

    private void fillLanguages(JComponent parentMenu) {
        Language[] languages = LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
        ArrayList<JBMenuItem> langItems = new ArrayList<JBMenuItem>();
        for (final Language lang : languages) {
            if (lang.equals(this.getDefaultLanguage())) continue;
            String langName = LanguageCodeStyleSettingsProvider.getLanguageName((Language)lang);
            JBMenuItem langItem = new JBMenuItem(langName);
            langItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedLanguageCodeStylePanel.this.applyLanguageSettings(lang);
                }
            });
            langItems.add(langItem);
        }
        Collections.sort(langItems, new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem item1, JMenuItem item2) {
                return item1.getText().compareToIgnoreCase(item2.getText());
            }
        });
        for (JMenuItem jMenuItem : langItems) {
            parentMenu.add(jMenuItem);
        }
    }

    private void fillPredefined(JMenuItem parentMenu) {
        for (final PredefinedCodeStyle predefinedCodeStyle : this.myPredefinedCodeStyles) {
            JBMenuItem predefinedItem = new JBMenuItem(predefinedCodeStyle.getName());
            parentMenu.add((Component)predefinedItem);
            predefinedItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedLanguageCodeStylePanel.this.applyPredefinedStyle(predefinedCodeStyle.getName());
                }
            });
        }
    }

    private PredefinedCodeStyle[] getPredefinedStyles() {
        Language language = this.getDefaultLanguage();
        ArrayList<PredefinedCodeStyle> result = new ArrayList<PredefinedCodeStyle>();
        for (PredefinedCodeStyle codeStyle : (PredefinedCodeStyle[])PredefinedCodeStyle.EP_NAME.getExtensions()) {
            if (!codeStyle.getLanguage().equals(language)) continue;
            result.add(codeStyle);
        }
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.getDefaultLanguage());
        if (provider != null) {
            result.addAll(Arrays.asList(provider.getPredefinedCodeStyles()));
        }
        return result.toArray(new PredefinedCodeStyle[result.size()]);
    }

    private void applyLanguageSettings(Language lang) {
        Project currProject = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        CodeStyleSettings rootSettings = CodeStyleSettingsManager.getSettings((Project)currProject);
        CommonCodeStyleSettings sourceSettings = rootSettings.getCommonSettings(lang);
        CommonCodeStyleSettings targetSettings = this.getSettings().getCommonSettings(this.getDefaultLanguage());
        if (sourceSettings == null || targetSettings == null) {
            return;
        }
        if (!(targetSettings instanceof CodeStyleSettings)) {
            CommonCodeStyleSettingsManager.copy((CommonCodeStyleSettings)sourceSettings, (CommonCodeStyleSettings)targetSettings);
        } else {
            Language targetLang = this.getDefaultLanguage();
            LOG.error((targetLang != null ? targetLang.getDisplayName() : "Unknown") + " language plug-in either uses an outdated API or does not initialize" + " its own code style settings in LanguageCodeStyleSettingsProvider.getDefaultSettings()." + " The operation can not be applied in this case.");
        }
        this.reset(this.getSettings());
        this.onSomethingChanged();
    }

    private void applyPredefinedStyle(String styleName) {
        for (PredefinedCodeStyle style : this.myPredefinedCodeStyles) {
            if (!style.getName().equals(styleName)) continue;
            this.applyPredefinedSettings(style);
        }
    }

    private void customizePanel(MultilanguageCodeStyleAbstractPanel panel) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.getDefaultLanguage());
        if (provider != null) {
            provider.customizeSettings((CodeStyleSettingsCustomizable)panel, panel.getSettingsType());
        }
    }

    @Override
    public boolean isCopyFromMenuAvailable() {
        return true;
    }

    @Override
    public Set<String> processListOptions() {
        HashSet result = new HashSet();
        for (CodeStyleAbstractPanel tab : this.myTabs) {
            result.addAll(tab.processListOptions());
        }
        return result;
    }

    protected class MyIndentOptionsWrapper
    extends CodeStyleAbstractPanel {
        private final IndentOptionsEditor myEditor;
        private final LanguageCodeStyleSettingsProvider myProvider;
        private final JPanel myTopPanel;
        private final JPanel myLeftPanel;
        private final JPanel myRightPanel;

        protected MyIndentOptionsWrapper(CodeStyleSettings settings, LanguageCodeStyleSettingsProvider provider, IndentOptionsEditor editor) {
            super(settings);
            this.myProvider = provider;
            this.myTopPanel = new JPanel();
            this.myTopPanel.setLayout(new BorderLayout(8, 0));
            this.myLeftPanel = new JPanel(new BorderLayout());
            this.myTopPanel.add((Component)this.myLeftPanel, "West");
            this.myRightPanel = new JPanel();
            this.installPreviewPanel(this.myRightPanel);
            this.myEditor = editor;
            if (this.myEditor != null) {
                JPanel panel = this.myEditor.createPanel();
                JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)panel, (boolean)true);
                scroll.setPreferredSize(new Dimension(panel.getPreferredSize().width + scroll.getVerticalScrollBar().getPreferredSize().width + 5, -1));
                this.myLeftPanel.add((Component)scroll, "Center");
            }
            this.myTopPanel.add((Component)this.myRightPanel, "Center");
        }

        @Override
        protected int getRightMargin() {
            return this.myProvider.getRightMargin(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS);
        }

        @Override
        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme, null);
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            Language language = TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
            LanguageFileType languageFileType = language != null ? language.getAssociatedFileType() : FileTypes.PLAIN_TEXT;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/TabbedLanguageCodeStylePanel$MyIndentOptionsWrapper", "getFileType"));
            }
            return languageFileType;
        }

        @Override
        protected String getPreviewText() {
            return this.myProvider != null ? this.myProvider.getCodeSample(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) : "Loading...";
        }

        @Override
        protected String getFileExt() {
            String ext;
            if (this.myProvider != null && (ext = this.myProvider.getFileExt()) != null) {
                return ext;
            }
            return super.getFileExt();
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null) {
                return;
            }
            this.myEditor.apply(settings, indentOptions);
        }

        @Override
        public boolean isModified(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null) {
                return false;
            }
            return this.myEditor.isModified(settings, indentOptions);
        }

        @Override
        public JComponent getPanel() {
            return this.myTopPanel;
        }

        @Override
        protected void resetImpl(CodeStyleSettings settings) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions(settings);
            if (indentOptions == null) {
                this.myEditor.setEnabled(false);
                indentOptions = settings.getIndentOptions((FileType)this.myProvider.getLanguage().getAssociatedFileType());
            }
            this.myEditor.reset(settings, indentOptions);
        }

        @Nullable
        private CommonCodeStyleSettings.IndentOptions getIndentOptions(CodeStyleSettings settings) {
            return settings.getCommonSettings(this.getDefaultLanguage()).getIndentOptions();
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }

        @Override
        protected String getTabTitle() {
            return ApplicationBundle.message((String)"title.tabs.and.indents", (Object[])new Object[0]);
        }

        @Override
        public void onSomethingChanged() {
            super.onSomethingChanged();
            this.myEditor.setEnabled(true);
        }
    }

    private class ConfigurableWrapper
    extends CodeStyleAbstractPanel {
        private final Configurable myConfigurable;
        private JComponent myComponent;

        public ConfigurableWrapper(Configurable configurable, CodeStyleSettings settings) {
            if (configurable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/application/options/TabbedLanguageCodeStylePanel$ConfigurableWrapper", "<init>"));
            }
            super(settings);
            this.myConfigurable = configurable;
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    ConfigurableWrapper.this.myConfigurable.disposeUIResources();
                }
            });
        }

        @Override
        protected int getRightMargin() {
            return 0;
        }

        @Override
        @Nullable
        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return null;
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            Language language = this.getDefaultLanguage();
            LanguageFileType languageFileType = language != null ? language.getAssociatedFileType() : FileTypes.PLAIN_TEXT;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/TabbedLanguageCodeStylePanel$ConfigurableWrapper", "getFileType"));
            }
            return languageFileType;
        }

        @Override
        public Language getDefaultLanguage() {
            return TabbedLanguageCodeStylePanel.this.getDefaultLanguage();
        }

        @Override
        protected String getTabTitle() {
            return this.myConfigurable.getDisplayName();
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        @Override
        public void apply(CodeStyleSettings settings) throws ConfigurationException {
            this.myConfigurable.apply();
        }

        @Override
        public boolean isModified(CodeStyleSettings settings) {
            return this.myConfigurable.isModified();
        }

        @Override
        @Nullable
        public JComponent getPanel() {
            if (this.myComponent == null) {
                this.myComponent = this.myConfigurable.createComponent();
            }
            return this.myComponent;
        }

        @Override
        protected void resetImpl(CodeStyleSettings settings) {
            if (this.myConfigurable instanceof CodeStyleAbstractConfigurable) {
                ((CodeStyleAbstractConfigurable)this.myConfigurable).reset(settings);
            } else {
                this.myConfigurable.reset();
            }
        }
    }

    protected class MyWrappingAndBracesPanel
    extends WrappingAndBracesPanel {
        public MyWrappingAndBracesPanel(CodeStyleSettings settings) {
            super(settings);
            this.setPanelLanguage(TabbedLanguageCodeStylePanel.this.getDefaultLanguage());
        }

        @Override
        protected void customizeSettings() {
            TabbedLanguageCodeStylePanel.this.customizePanel(this);
        }

        @Override
        protected void installPreviewPanel(JPanel previewPanel) {
            previewPanel.setLayout(new BorderLayout());
            previewPanel.add((Component)this.getEditor().getComponent(), "Center");
        }
    }

    protected class MyBlankLinesPanel
    extends CodeStyleBlankLinesPanel {
        public MyBlankLinesPanel(CodeStyleSettings settings) {
            super(settings);
            this.setPanelLanguage(TabbedLanguageCodeStylePanel.this.getDefaultLanguage());
        }

        @Override
        protected void customizeSettings() {
            TabbedLanguageCodeStylePanel.this.customizePanel(this);
        }

        @Override
        protected void installPreviewPanel(JPanel previewPanel) {
            previewPanel.setLayout(new BorderLayout());
            previewPanel.add((Component)this.getEditor().getComponent(), "Center");
        }
    }

    protected class MySpacesPanel
    extends CodeStyleSpacesPanel {
        public MySpacesPanel(CodeStyleSettings settings) {
            super(settings);
            this.setPanelLanguage(TabbedLanguageCodeStylePanel.this.getDefaultLanguage());
        }

        @Override
        protected void installPreviewPanel(JPanel previewPanel) {
            previewPanel.setLayout(new BorderLayout());
            previewPanel.add((Component)this.getEditor().getComponent(), "Center");
        }

        @Override
        protected void customizeSettings() {
            TabbedLanguageCodeStylePanel.this.customizePanel(this);
        }

        @Override
        protected boolean shouldHideOptions() {
            return true;
        }
    }
}

