/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.util.Collection;

public abstract class ImportSchemeAction<T extends Scheme, E extends ExternalizableScheme>
extends AnAction {
    protected final SchemesManager<T, E> mySchemesManager;

    public ImportSchemeAction(SchemesManager manager) {
        super("Import", "Import", PlatformIcons.IMPORT_ICON);
        this.mySchemesManager = manager;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(true);
    }

    public void actionPerformed(AnActionEvent e) {
        SchemesToImportPopup popup = new SchemesToImportPopup<T, E>(this.getPanel()){

            @Override
            protected void onSchemeSelected(E scheme) {
                if (scheme != null) {
                    ImportSchemeAction.this.importScheme(scheme);
                }
            }
        };
        popup.show(this.mySchemesManager, this.collectCurrentSchemes());
    }

    protected abstract Collection<T> collectCurrentSchemes();

    protected abstract Component getPanel();

    protected abstract void importScheme(E var1);
}

