/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui.settings;

import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.ui.UIUtil;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.Font;
import javax.swing.KeyStroke;

public class DefaultSettingsProvider
implements SettingsProvider {
    public KeyStroke[] getNewSessionKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(84, 256) : KeyStroke.getKeyStroke(84, 192)};
    }

    public KeyStroke[] getCloseSessionKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(87, 256) : KeyStroke.getKeyStroke(87, 192)};
    }

    public KeyStroke[] getCopyKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 192)};
    }

    public KeyStroke[] getPasteKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 192)};
    }

    public KeyStroke[] getClearBufferKeyStrokes() {
        return new KeyStroke[]{UIUtil.isMac ? KeyStroke.getKeyStroke(75, 256) : KeyStroke.getKeyStroke(75, 128)};
    }

    public ColorPalette getTerminalColorPalette() {
        return UIUtil.isWindows ? ColorPalette.WINDOWS_PALETTE : ColorPalette.XTERM_PALETTE;
    }

    public Font getTerminalFont() {
        String fontName = UIUtil.isWindows ? "Consolas" : (UIUtil.isMac ? "Menlo" : "Monospaced");
        return Font.decode(fontName).deriveFont(this.getTerminalFontSize());
    }

    public float getTerminalFontSize() {
        return 14.0f;
    }

    public float getLineSpace() {
        return 0.0f;
    }

    public TextStyle getDefaultStyle() {
        return new TextStyle(TerminalColor.BLACK, TerminalColor.WHITE);
    }

    public TextStyle getSelectionColor() {
        return new TextStyle(TerminalColor.WHITE, TerminalColor.rgb(82, 109, 165));
    }

    public boolean useInverseSelectionColor() {
        return true;
    }

    public boolean copyOnSelect() {
        return this.emulateX11CopyPaste();
    }

    public boolean pasteOnMiddleMouseClick() {
        return this.emulateX11CopyPaste();
    }

    public boolean emulateX11CopyPaste() {
        return true;
    }

    public boolean useAntialiasing() {
        return true;
    }

    public int maxRefreshRate() {
        return 50;
    }

    public boolean audibleBell() {
        return true;
    }

    public boolean enableMouseReporting() {
        return true;
    }

    public int caretBlinkingMs() {
        return 505;
    }

    public boolean scrollToBottomOnTyping() {
        return true;
    }

    public boolean DECCompatibilityMode() {
        return true;
    }

    public boolean forceActionOnMouseReporting() {
        return false;
    }
}

