/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.google.common.collect.Lists;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.debug.DebugBufferType;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.PreConnectHandler;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.TerminalPanelListener;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.terminal.ui.TerminalWidget;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JediTermWidget
extends JPanel
implements TerminalSession,
TerminalWidget,
TerminalActionProvider {
    private static final Logger LOG = Logger.getLogger(JediTermWidget.class);
    protected final TerminalPanel myTerminalPanel;
    protected final JediTerminal myTerminal;
    protected final AtomicBoolean mySessionRunning = new AtomicBoolean();
    protected PreConnectHandler myPreConnectHandler;
    private TtyConnector myTtyConnector;
    private TerminalStarter myTerminalStarter;
    private Thread myEmuThread;
    private final SettingsProvider mySettingsProvider;
    private TerminalActionProvider myNextActionProvider;

    public JediTermWidget(@NotNull SettingsProvider settingsProvider) {
        this(80, 24, settingsProvider);
    }

    public JediTermWidget(Dimension dimension, SettingsProvider settingsProvider) {
        this(dimension.width, dimension.height, settingsProvider);
    }

    public JediTermWidget(int columns, int lines, SettingsProvider settingsProvider) {
        super(new BorderLayout());
        this.mySettingsProvider = settingsProvider;
        StyleState styleState = this.createDefaultStyle();
        TerminalTextBuffer terminalTextBuffer = new TerminalTextBuffer(columns, lines, styleState);
        this.myTerminalPanel = this.createTerminalPanel(this.mySettingsProvider, styleState, terminalTextBuffer);
        this.myTerminal = new JediTerminal(this.myTerminalPanel, terminalTextBuffer, styleState);
        this.myTerminalPanel.addTerminalMouseListener(this.myTerminal);
        this.myTerminalPanel.setNextProvider(this);
        this.myTerminalPanel.setCoordAccessor(this.myTerminal);
        this.myPreConnectHandler = this.createPreConnectHandler(this.myTerminal);
        this.myTerminalPanel.setKeyListener(this.myPreConnectHandler);
        JScrollBar scrollBar = this.createScrollBar();
        this.add((Component)this.myTerminalPanel, "Center");
        this.add((Component)scrollBar, "East");
        scrollBar.setModel(this.myTerminalPanel.getBoundedRangeModel());
        this.mySessionRunning.set(false);
        this.myTerminalPanel.init();
        this.myTerminalPanel.setVisible(true);
    }

    protected JScrollBar createScrollBar() {
        return new JScrollBar();
    }

    protected StyleState createDefaultStyle() {
        StyleState styleState = new StyleState();
        styleState.setDefaultStyle(this.mySettingsProvider.getDefaultStyle());
        return styleState;
    }

    protected TerminalPanel createTerminalPanel(SettingsProvider settingsProvider, StyleState styleState, TerminalTextBuffer terminalTextBuffer) {
        return new TerminalPanel(settingsProvider, terminalTextBuffer, styleState);
    }

    protected PreConnectHandler createPreConnectHandler(JediTerminal terminal) {
        return new PreConnectHandler(terminal);
    }

    @Override
    public TerminalDisplay getTerminalDisplay() {
        return this.getTerminalPanel();
    }

    public TerminalPanel getTerminalPanel() {
        return this.myTerminalPanel;
    }

    public void setTtyConnector(@NotNull TtyConnector ttyConnector) {
        this.myTtyConnector = ttyConnector;
        this.myTerminalStarter = this.createTerminalStarter(this.myTerminal, this.myTtyConnector);
        this.myTerminalPanel.setTerminalStarter(this.myTerminalStarter);
    }

    protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
        return new TerminalStarter(terminal, connector);
    }

    @Override
    public TtyConnector getTtyConnector() {
        return this.myTtyConnector;
    }

    @Override
    public Terminal getTerminal() {
        return this.myTerminal;
    }

    @Override
    public String getSessionName() {
        if (this.myTtyConnector != null) {
            return this.myTtyConnector.getName();
        }
        return "Session";
    }

    @Override
    public void start() {
        if (!this.mySessionRunning.get()) {
            this.myEmuThread = new Thread(new EmulatorTask());
            this.myEmuThread.start();
        } else {
            LOG.error((Object)"Should not try to start session again at this point... ");
        }
    }

    public void stop() {
        if (this.mySessionRunning.get() && this.myEmuThread != null) {
            this.myEmuThread.interrupt();
        }
    }

    public boolean isSessionRunning() {
        return this.mySessionRunning.get();
    }

    @Override
    public String getBufferText(DebugBufferType type) {
        return type.getValue(this);
    }

    @Override
    public TerminalTextBuffer getTerminalTextBuffer() {
        return this.myTerminalPanel.getTerminalTextBuffer();
    }

    @Override
    public boolean requestFocusInWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JediTermWidget.this.myTerminalPanel.requestFocusInWindow();
            }
        });
        return super.requestFocusInWindow();
    }

    @Override
    public boolean canOpenSession() {
        return !this.isSessionRunning();
    }

    @Override
    public void setTerminalPanelListener(TerminalPanelListener terminalPanelListener) {
        this.myTerminalPanel.setTerminalPanelListener(terminalPanelListener);
    }

    @Override
    public TerminalSession getCurrentSession() {
        return this;
    }

    @Override
    public TerminalSession createTerminalSession(TtyConnector ttyConnector) {
        this.setTtyConnector(ttyConnector);
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void close() {
        this.myTerminalStarter.close();
    }

    @Override
    public List<TerminalAction> getActions() {
        return Lists.newArrayList();
    }

    @Override
    public TerminalActionProvider getNextProvider() {
        return this.myNextActionProvider;
    }

    @Override
    public void setNextProvider(TerminalActionProvider actionProvider) {
        this.myNextActionProvider = actionProvider;
    }

    public TerminalStarter getTerminalStarter() {
        return this.myTerminalStarter;
    }

    class EmulatorTask
    implements Runnable {
        EmulatorTask() {
        }

        public void run() {
            try {
                JediTermWidget.this.mySessionRunning.set(true);
                Thread.currentThread().setName("Connector-" + JediTermWidget.this.myTtyConnector.getName());
                if (JediTermWidget.this.myTtyConnector.init(JediTermWidget.this.myPreConnectHandler)) {
                    JediTermWidget.this.myTerminalPanel.initKeyHandler();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JediTermWidget.this.myTerminalPanel.requestFocusInWindow();
                        }
                    });
                    JediTermWidget.this.myTerminalStarter.start();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception running terminal", (Throwable)e);
            }
            finally {
                try {
                    JediTermWidget.this.myTtyConnector.close();
                }
                catch (Exception exception) {}
                JediTermWidget.this.mySessionRunning.set(false);
                JediTermWidget.this.myTerminalPanel.setKeyListener(JediTermWidget.this.myPreConnectHandler);
            }
        }
    }
}

