/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.CharacterUtils;
import java.util.HashMap;
import java.util.Map;

public class TerminalKeyEncoder {
    public static final int ESC = 27;
    public static final int DEL = 127;
    private final Map<Integer, byte[]> myKeyCodes = new HashMap<Integer, byte[]>();

    public TerminalKeyEncoder() {
        this.setAutoNewLine(false);
        this.arrowKeysApplicationSequences();
        this.keypadApplicationSequences();
        this.putCode(8, 127);
        this.putCode(112, 27, 79, 80);
        this.putCode(113, 27, 79, 81);
        this.putCode(114, 27, 79, 82);
        this.putCode(115, 27, 79, 83);
        this.putCode(116, 27, 91, 49, 53, 126);
        this.putCode(117, 27, 91, 49, 55, 126);
        this.putCode(118, 27, 91, 49, 56, 126);
        this.putCode(119, 27, 91, 49, 57, 126);
        this.putCode(120, 27, 91, 50, 48, 126);
        this.putCode(121, 27, 91, 50, 49, 126);
        this.putCode(122, 27, 91, 50, 51, 126, 27);
        this.putCode(123, 27, 91, 50, 52, 126, 8);
        this.putCode(155, 27, 91, 50, 126);
        this.putCode(127, 27, 91, 51, 126);
        this.putCode(33, 27, 91, 53, 126);
        this.putCode(34, 27, 91, 54, 126);
        this.putCode(36, 27, 91, 72);
        this.putCode(35, 27, 91, 70);
    }

    public void arrowKeysApplicationSequences() {
        this.putCode(38, 27, 79, 65);
        this.putCode(40, 27, 79, 66);
        this.putCode(39, 27, 79, 67);
        this.putCode(37, 27, 79, 68);
    }

    public void arrowKeysAnsiCursorSequences() {
        this.putCode(38, 27, 91, 65);
        this.putCode(40, 27, 91, 66);
        this.putCode(39, 27, 91, 67);
        this.putCode(37, 27, 91, 68);
    }

    void putCode(int code, int ... bytesAsInt) {
        this.myKeyCodes.put(code, CharacterUtils.makeCode(bytesAsInt));
    }

    public byte[] getCode(int key) {
        return this.myKeyCodes.get(key);
    }

    public void keypadApplicationSequences() {
        this.putCode(225, 27, 91, 66);
        this.putCode(226, 27, 91, 68);
        this.putCode(227, 27, 91, 67);
        this.putCode(224, 27, 91, 65);
    }

    public void normalKeypad() {
        this.putCode(225, 2);
        this.putCode(226, 4);
        this.putCode(227, 6);
        this.putCode(224, 8);
    }

    public void setAutoNewLine(boolean enabled) {
        if (enabled) {
            this.putCode(10, 13, 10);
        } else {
            this.putCode(10, 13);
        }
    }
}

