/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.gson.GsonUtil;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepositoryType;
import com.intellij.tasks.jira.rest.JiraRestApi;
import com.intellij.tasks.jira.soap.JiraLegacyApi;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.xmlrpc.CommonsXmlRpcTransport;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcTransport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="JIRA")
public class JiraRepository
extends BaseRepositoryImpl {
    public static final Gson GSON = GsonUtil.createDefaultBuilder().create();
    private static final Logger LOG = Logger.getInstance(JiraRepository.class);
    public static final String REST_API_PATH = "/rest/api/latest";
    private static final boolean LEGACY_API_ONLY = Boolean.getBoolean("tasks.jira.legacy.api.only");
    private static final boolean BASIC_AUTH_ONLY = Boolean.getBoolean("tasks.jira.basic.auth.only");
    private static final boolean REDISCOVER_API = Boolean.getBoolean("tasks.jira.rediscover.api");
    public static final Pattern JIRA_ID_PATTERN = Pattern.compile("\\p{javaUpperCase}+-\\d+");
    public static final String AUTH_COOKIE_NAME = "JSESSIONID";
    private String mySearchQuery = TaskBundle.message((String)"jira.default.query", (Object[])new Object[0]);
    private JiraRemoteApi myApiVersion;
    private String myJiraVersion;

    public JiraRepository() {
        this.setUseHttpAuthentication(true);
    }

    public JiraRepository(JiraRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUseHttpAuthentication(true);
    }

    private JiraRepository(JiraRepository other) {
        super((BaseRepositoryImpl)other);
        this.mySearchQuery = other.mySearchQuery;
        this.myJiraVersion = other.myJiraVersion;
        if (other.myApiVersion != null) {
            this.myApiVersion = other.myApiVersion.getType().createApi(this);
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof JiraRepository)) {
            return false;
        }
        JiraRepository repository = (JiraRepository)((Object)o);
        if (!Comparing.equal((String)this.mySearchQuery, (String)repository.getSearchQuery())) {
            return false;
        }
        return Comparing.equal((String)this.myJiraVersion, (String)repository.getJiraVersion());
    }

    @NotNull
    public JiraRepository clone() {
        JiraRepository jiraRepository = new JiraRepository(this);
        if (jiraRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "clone"));
        }
        return jiraRepository;
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        Task task;
        this.ensureApiVersionDiscovered();
        String resultQuery = StringUtil.notNullize((String)query);
        if (this.isJqlSupported()) {
            resultQuery = StringUtil.isNotEmpty((String)this.mySearchQuery) && StringUtil.isNotEmpty((String)query) ? String.format("summary ~ '%s' and ", query) + this.mySearchQuery : (StringUtil.isNotEmpty((String)query) ? String.format("summary ~ '%s'", query) : this.mySearchQuery);
        }
        List tasksFound = this.myApiVersion.findTasks(resultQuery, max);
        if (query != null && JIRA_ID_PATTERN.matcher(query.trim()).matches() && (task = this.findTask(query)) != null) {
            tasksFound = ContainerUtil.concat((boolean)true, tasksFound, (Object[])new Task[]{task});
        }
        return (Task[])ArrayUtil.toObjectArray(tasksFound, Task.class);
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/jira/JiraRepository", "findTask"));
        }
        this.ensureApiVersionDiscovered();
        return this.myApiVersion.findTask(id);
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/jira/JiraRepository", "updateTimeSpent"));
        }
        if (timeSpent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeSpent", "com/intellij/tasks/jira/JiraRepository", "updateTimeSpent"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/tasks/jira/JiraRepository", "updateTimeSpent"));
        }
        this.myApiVersion.updateTimeSpend(task, timeSpent, comment);
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        this.clearCookies();
        return new TaskRepository.CancellableConnection(){

            protected void doTest() throws Exception {
                JiraRepository.this.ensureApiVersionDiscovered();
                JiraRepository.this.myApiVersion.findTasks(JiraRepository.this.mySearchQuery, 1);
            }

            public void cancel() {
            }
        };
    }

    @NotNull
    public JiraRemoteApi discoverApiVersion() throws Exception {
        JiraRestApi restApi;
        String responseBody;
        if (LEGACY_API_ONLY) {
            LOG.info("Intentionally using only legacy JIRA API");
            JiraLegacyApi jiraLegacyApi = this.createLegacyApi();
            if (jiraLegacyApi == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "discoverApiVersion"));
            }
            return jiraLegacyApi;
        }
        GetMethod method = new GetMethod(this.getRestUrl("serverInfo"));
        try {
            responseBody = this.executeMethod((HttpMethod)method);
        }
        catch (Exception e) {
            StatusLine status = method.getStatusLine();
            if (status != null && status.getStatusCode() == 404) {
                JiraLegacyApi jiraLegacyApi = this.createLegacyApi();
                if (jiraLegacyApi == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "discoverApiVersion"));
                }
                return jiraLegacyApi;
            }
            throw e;
        }
        JsonObject serverInfo = (JsonObject)GSON.fromJson(responseBody, JsonObject.class);
        this.myJiraVersion = serverInfo.get("version").getAsString();
        LOG.info("JIRA version (from serverInfo): " + this.myJiraVersion);
        if (this.isOnDemand()) {
            LOG.info("Connecting to JIRA on-Demand. Cookie authentication is enabled unless 'tasks.jira.basic.auth.only' VM flag is used.");
        }
        if ((restApi = JiraRestApi.fromJiraVersion(this.myJiraVersion, this)) == null) {
            throw new Exception(TaskBundle.message((String)"jira.failure.no.REST", (Object[])new Object[0]));
        }
        JiraRestApi jiraRestApi = restApi;
        if (jiraRestApi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "discoverApiVersion"));
        }
        return jiraRestApi;
    }

    private JiraLegacyApi createLegacyApi() {
        try {
            XmlRpcClient client = new XmlRpcClient(this.getUrl());
            Vector<String> parameters = new Vector<String>(Collections.singletonList(""));
            XmlRpcRequest request = new XmlRpcRequest("jira1.getServerInfo", parameters);
            Hashtable response = (Hashtable)client.execute((XmlRpcClientRequest)request, (XmlRpcTransport)new CommonsXmlRpcTransport(new URL(this.getUrl()), this.getHttpClient()));
            if (response != null) {
                this.myJiraVersion = (String)response.get("version");
            }
        }
        catch (Exception e) {
            LOG.error("Cannot find out JIRA version via XML-RPC", (Throwable)e);
        }
        return new JiraLegacyApi(this);
    }

    private void ensureApiVersionDiscovered() throws Exception {
        if (this.myApiVersion == null || LEGACY_API_ONLY || REDISCOVER_API) {
            this.myApiVersion = this.discoverApiVersion();
        }
    }

    @NotNull
    public String executeMethod(@NotNull HttpMethod method) throws Exception {
        JsonObject object;
        Header header;
        String entityContent;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tasks/jira/JiraRepository", "executeMethod"));
        }
        LOG.debug("URI: " + method.getURI());
        HttpClient client = this.getHttpClient();
        if (BASIC_AUTH_ONLY || !this.isOnDemand()) {
            this.setUseHttpAuthentication(true);
        } else {
            boolean enableBasicAuthentication;
            boolean bl = enableBasicAuthentication = !this.isRestApiSupported() || !JiraRepository.containsCookie(client, AUTH_COOKIE_NAME);
            if (enableBasicAuthentication != this.isUseHttpAuthentication()) {
                LOG.info("Basic authentication for subsequent requests was " + (enableBasicAuthentication ? "enabled" : "disabled"));
            }
            this.setUseHttpAuthentication(enableBasicAuthentication);
        }
        int statusCode = client.executeMethod(method);
        LOG.debug("Status code: " + statusCode);
        InputStream stream = method.getResponseBodyAsStream();
        String string = entityContent = stream == null ? "" : StreamUtil.readText((InputStream)stream, (String)"UTF-8");
        if (statusCode >= 200 && statusCode < 300) {
            String string2 = entityContent;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "executeMethod"));
            }
            return string2;
        }
        this.clearCookies();
        if (method.getResponseHeader("Content-Type") != null && (header = method.getResponseHeader("Content-Type")).getValue().startsWith("application/json") && (object = (JsonObject)GSON.fromJson(entityContent, JsonObject.class)).has("errorMessages")) {
            String reason = StringUtil.join((Iterable)object.getAsJsonArray("errorMessages"), (String)" ");
            LOG.warn(reason);
            throw new Exception(TaskBundle.message((String)"failure.server.message", (Object[])new Object[]{reason}));
        }
        if (method.getResponseHeader("X-Authentication-Denied-Reason") != null && (header = method.getResponseHeader("X-Authentication-Denied-Reason")).getValue().startsWith("CAPTCHA_CHALLENGE")) {
            throw new Exception(TaskBundle.message((String)"jira.failure.captcha", (Object[])new Object[0]));
        }
        if (statusCode == 401) {
            throw new Exception(TaskBundle.message((String)"failure.login", (Object[])new Object[0]));
        }
        String statusText = HttpStatus.getStatusText((int)method.getStatusCode());
        throw new Exception(TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{statusCode, statusText}));
    }

    public boolean isOnDemand() {
        return StringUtil.notNullize((String)this.myJiraVersion).contains("OD");
    }

    private static boolean containsCookie(@NotNull HttpClient client, @NotNull String cookieName) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/intellij/tasks/jira/JiraRepository", "containsCookie"));
        }
        if (cookieName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cookieName", "com/intellij/tasks/jira/JiraRepository", "containsCookie"));
        }
        for (Cookie cookie : client.getState().getCookies()) {
            if (!cookie.getName().equals(cookieName) || cookie.isExpired()) continue;
            return true;
        }
        return false;
    }

    private void clearCookies() {
        this.getHttpClient().getState().clearCookies();
    }

    public HttpClient getHttpClient() {
        return super.getHttpClient();
    }

    protected void configureHttpClient(HttpClient client) {
        super.configureHttpClient(client);
        client.getParams().setCookiePolicy("compatibility");
    }

    protected int getFeatures() {
        int features = super.getFeatures();
        if (this.isRestApiSupported()) {
            return features | 4 | 8;
        }
        return features & 0xFFFFFFEF & 0xFFFFFFF7 & 0xFFFFFFFB;
    }

    private boolean isRestApiSupported() {
        return this.myApiVersion != null && this.myApiVersion.getType() != JiraRemoteApi.ApiType.LEGACY;
    }

    public boolean isJqlSupported() {
        return this.isRestApiSupported();
    }

    public String getSearchQuery() {
        return this.mySearchQuery;
    }

    public void setTaskState(@NotNull Task task, @NotNull TaskState state) throws Exception {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/jira/JiraRepository", "setTaskState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/tasks/jira/JiraRepository", "setTaskState"));
        }
        this.myApiVersion.setTaskState(task, state);
    }

    public void setSearchQuery(String searchQuery) {
        this.mySearchQuery = searchQuery;
    }

    public void setUrl(String url) {
        if (!this.getUrl().equals(url)) {
            this.myApiVersion = null;
            super.setUrl(url);
        }
    }

    @Nullable
    public JiraRemoteApi.ApiType getApiType() {
        return this.myApiVersion == null ? null : this.myApiVersion.getType();
    }

    public void setApiType(@Nullable JiraRemoteApi.ApiType type) {
        if (type != null) {
            this.myApiVersion = type.createApi(this);
        }
    }

    @Nullable
    public String getJiraVersion() {
        return this.myJiraVersion;
    }

    public void setJiraVersion(@Nullable String jiraVersion) {
        this.myJiraVersion = jiraVersion;
    }

    public String getRestUrl(String ... parts) {
        return this.getUrl() + REST_API_PATH + "/" + StringUtil.join((String[])parts, (String)"/");
    }
}

