/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.operatordict;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorAttribute;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorForm;
import net.sourceforge.jeuclid.elements.support.operatordict.StretchOverride;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperatorDictionary
implements OperatorDictionary,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> dict = new EnumMap<OperatorAttribute, Map<String, Map<OperatorForm, String>>>(OperatorAttribute.class);

    protected AbstractOperatorDictionary() {
        this.initializeFromXML(this.dict);
        this.overrideStretchy();
    }

    private void overrideStretchy() {
        Map<String, Map<OperatorForm, String>> map = this.dict.get((Object)OperatorAttribute.STRETCHY);
        for (Map.Entry<String, Map<OperatorForm, String>> entry : map.entrySet()) {
            String string = StretchOverride.getStretchOverride(entry.getKey());
            if (string == null) continue;
            for (Map.Entry<OperatorForm, String> entry2 : entry.getValue().entrySet()) {
                if (!Boolean.parseBoolean(entry2.getValue())) continue;
                entry2.setValue(string);
            }
        }
    }

    protected static OperatorDictionary deserialize(String string) {
        AbstractOperatorDictionary abstractOperatorDictionary = null;
        try {
            InputStream inputStream = AbstractOperatorDictionary.class.getResourceAsStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            abstractOperatorDictionary = (AbstractOperatorDictionary)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            abstractOperatorDictionary = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            abstractOperatorDictionary = null;
        }
        catch (IOException iOException) {
            abstractOperatorDictionary = null;
        }
        catch (NullPointerException nullPointerException) {
            abstractOperatorDictionary = null;
        }
        return abstractOperatorDictionary;
    }

    protected abstract void initializeFromXML(Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> var1);

    @Override
    public String getDefaultAttributeValue(String string, String string2, String string3) throws UnknownAttributeException {
        OperatorForm operatorForm = OperatorForm.parseOperatorForm(string2);
        return this.getDefaultAttributeValue(string, operatorForm, OperatorAttribute.parseOperatorAttribute(string3));
    }

    private String getDefaultAttributeValue(String string, OperatorForm operatorForm, OperatorAttribute operatorAttribute) {
        String string2;
        Map<String, Map<OperatorForm, String>> map = this.dict.get((Object)operatorAttribute);
        if (map == null) {
            return operatorAttribute.getDefaultValue();
        }
        Map<OperatorForm, String> map2 = map.get(string);
        if (map2 == null) {
            string2 = operatorAttribute.getDefaultValue();
        } else {
            string2 = map2.get((Object)operatorForm);
            if (string2 == null) {
                string2 = map2.get((Object)OperatorForm.INFIX);
            }
            if (string2 == null) {
                string2 = map2.get((Object)OperatorForm.POSTFIX);
            }
            if (string2 == null) {
                string2 = map2.get((Object)OperatorForm.PREFIX);
            }
            if (string2 == null) {
                string2 = operatorAttribute.getDefaultValue();
            }
        }
        return string2;
    }
}

