/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.SocksProtocolVersion;
import io.netty.handler.codec.socksx.v4.Socks4CmdRequest;
import io.netty.handler.codec.socksx.v4.Socks4CmdType;
import io.netty.handler.codec.socksx.v4.Socks4CommonUtils;
import io.netty.handler.codec.socksx.v4.Socks4Request;
import io.netty.handler.codec.socksx.v4.UnknownSocks4Request;
import io.netty.util.CharsetUtil;
import java.util.List;

public class Socks4CmdRequestDecoder
extends ReplayingDecoder<State> {
    private SocksProtocolVersion version;
    private Socks4CmdType cmdType;
    private byte reserved;
    private String host;
    private int port;
    private String userId;
    private Socks4Request msg = UnknownSocks4Request.INSTANCE;

    public Socks4CmdRequestDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksProtocolVersion.valueOf(byteBuf.readByte());
                if (this.version != SocksProtocolVersion.SOCKS4a) break;
                this.checkpoint(State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdType = Socks4CmdType.valueOf(byteBuf.readByte());
                this.port = byteBuf.readUnsignedShort();
                this.host = Socks4CommonUtils.intToIp(byteBuf.readInt());
                this.checkpoint(State.READ_CMD_USERID);
            }
            case READ_CMD_USERID: {
                this.userId = Socks4CmdRequestDecoder.readNullTerminatedString(byteBuf);
                this.checkpoint(State.READ_CMD_DOMAIN);
            }
            case READ_CMD_DOMAIN: {
                if (!"0.0.0.0".equals(this.host) && this.host.startsWith("0.0.0.")) {
                    this.host = Socks4CmdRequestDecoder.readNullTerminatedString(byteBuf);
                }
                this.msg = new Socks4CmdRequest(this.userId, this.cmdType, this.host, this.port);
            }
        }
        ctx.pipeline().remove(this);
        out.add(this.msg);
    }

    private static String readNullTerminatedString(ByteBuf byteBuf) throws Exception {
        byte NULL_BYTE = 0;
        String string = byteBuf.readBytes(byteBuf.bytesBefore(NULL_BYTE)).toString(CharsetUtil.US_ASCII);
        byteBuf.readByte();
        return string;
    }

    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_CMD_HEADER,
        READ_CMD_USERID,
        READ_CMD_DOMAIN;

    }
}

