/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import java.util.List;

public class LzfDecoder
extends ByteToMessageDecoder {
    private static final short SIGNATURE_OF_CHUNK = 23126;
    private static final int TYPE_OFFSET = 2;
    private static final int CHUNK_LENGTH_OFFSET = 3;
    private static final int ORIGINAL_LENGTH_OFFSET = 5;
    private final ChunkDecoder decoder;
    private final BufferRecycler recycler;
    private boolean corrupted;

    public LzfDecoder() {
        this(false);
    }

    public LzfDecoder(boolean safeInstance) {
        this.decoder = safeInstance ? ChunkDecoderFactory.safeInstance() : ChunkDecoderFactory.optimalInstance();
        this.recycler = BufferRecycler.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        block9: while (true) {
            if (this.corrupted) {
                in.skipBytes(in.readableBytes());
                return;
            }
            if (in.readableBytes() < 5) {
                return;
            }
            int idx = in.readerIndex();
            byte type = in.getByte(idx + 2);
            int chunkLength = in.getUnsignedShort(idx + 3);
            int totalLength = (type == 0 ? 5 : 7) + chunkLength;
            if (in.readableBytes() < totalLength) {
                return;
            }
            try {
                if (in.getUnsignedShort(idx) != 23126) {
                    throw new DecompressionException("Unexpected signature of chunk");
                }
                switch (type) {
                    case 0: {
                        in.skipBytes(5);
                        out.add(in.readBytes(chunkLength));
                        break;
                    }
                    case 1: {
                        int inPos;
                        byte[] inputArray;
                        int originalLength = in.getUnsignedShort(idx + 5);
                        if (in.hasArray()) {
                            inputArray = in.array();
                            inPos = in.arrayOffset() + idx + 7;
                        } else {
                            inputArray = this.recycler.allocInputBuffer(chunkLength);
                            in.getBytes(idx + 7, inputArray, 0, chunkLength);
                            inPos = 0;
                        }
                        ByteBuf uncompressed = ctx.alloc().heapBuffer(originalLength, originalLength);
                        byte[] outputArray = uncompressed.array();
                        int outPos = uncompressed.arrayOffset() + uncompressed.writerIndex();
                        boolean success = false;
                        try {
                            this.decoder.decodeChunk(inputArray, inPos, outputArray, outPos, outPos + originalLength);
                            uncompressed.writerIndex(uncompressed.writerIndex() + originalLength);
                            out.add(uncompressed);
                            in.skipBytes(totalLength);
                            success = true;
                        }
                        finally {
                            if (!success) {
                                uncompressed.release();
                            }
                        }
                        if (in.hasArray()) continue block9;
                        this.recycler.releaseInputBuffer(inputArray);
                        break;
                    }
                    default: {
                        throw new DecompressionException("Unknown type of chunk: " + type + " (expected: 0 or 1)");
                    }
                }
            }
            catch (Exception e) {
                this.corrupted = true;
                throw e;
            }
        }
    }
}

