/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.xpm;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BasicCParser;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.palette.PaletteFactory;
import org.apache.sanselan.palette.SimplePalette;
import org.apache.sanselan.util.Debug;

public class XpmImageParser
extends ImageParser {
    private static Map colorNames = null;
    private static final String DEFAULT_EXTENSION = ".xpm";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".xpm"};
    private static final char[] writePalette = new char[]{' ', '.', 'X', 'o', 'O', '+', '@', '#', '$', '%', '&', '*', '=', '-', ';', ':', '>', ',', '<', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm', 'M', 'N', 'B', 'V', 'C', 'Z', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'P', 'I', 'U', 'Y', 'T', 'R', 'E', 'W', 'Q', '!', '~', '^', '/', '(', ')', '_', '`', '\'', ']', '[', '{', '}', '|'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean loadColorNames() {
        boolean bl;
        if (colorNames != null) {
            return true;
        }
        BufferedReader reader = null;
        try {
            String line;
            InputStream rgbTxtStream = XpmImageParser.class.getResourceAsStream("/rgb.txt");
            if (rgbTxtStream == null) {
                boolean bl2 = false;
                return bl2;
            }
            reader = new BufferedReader(new InputStreamReader(rgbTxtStream, "US-ASCII"));
            HashMap<String, Integer> colors = new HashMap<String, Integer>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("!")) continue;
                try {
                    int red = Integer.parseInt(line.substring(0, 3));
                    int green = Integer.parseInt(line.substring(4, 7));
                    int blue = Integer.parseInt(line.substring(8, 11));
                    String colorName = line.substring(11).trim();
                    colors.put(colorName, new Integer(0xFF000000 | red << 16 | green << 8 | blue));
                }
                catch (NumberFormatException nfe) {}
            }
            colorNames = colors;
            bl = true;
        }
        catch (IOException ioException) {
            Debug.debug(ioException);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    @Override
    public String getName() {
        return "Xpm-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_XPM};
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        XpmHeader xpmHeader = this.readXpmHeader(byteSource);
        boolean isTransparent = false;
        int colorType = 0;
        for (Map.Entry entry : xpmHeader.palette.entrySet()) {
            PaletteEntry paletteEntry = (PaletteEntry)entry.getValue();
            if ((paletteEntry.getBestARGB() & 0xFF000000) != -16777216) {
                isTransparent = true;
            }
            if (paletteEntry.haveColor) {
                colorType = 2;
                continue;
            }
            if (colorType == 2 || !paletteEntry.haveGray && !paletteEntry.haveGray4Level) continue;
            colorType = 1;
        }
        return new ImageInfo("XPM version 3", xpmHeader.numCharsPerPixel * 8, new ArrayList(), ImageFormat.IMAGE_FORMAT_XPM, "X PixMap", xpmHeader.height, "image/x-xpixmap", 1, 0, 0.0f, 0, 0.0f, xpmHeader.width, false, isTransparent, true, colorType, "None");
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        XpmHeader xpmHeader = this.readXpmHeader(byteSource);
        return new Dimension(xpmHeader.width, xpmHeader.height);
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private XpmHeader readXpmHeader(ByteSource byteSource) throws ImageReadException, IOException {
        XpmParseResult result = this.parseXpmHeader(byteSource);
        return result.xpmHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XpmParseResult parseXpmHeader(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            StringBuilder firstComment = new StringBuilder();
            ByteArrayOutputStream preprocessedFile = BasicCParser.preprocess(is, firstComment, null);
            if (!firstComment.toString().trim().equals("XPM")) {
                throw new ImageReadException("Parsing XPM file failed, signature isn't '/* XPM */'");
            }
            XpmParseResult xpmParseResult = new XpmParseResult();
            xpmParseResult.cParser = new BasicCParser(new ByteArrayInputStream(preprocessedFile.toByteArray()));
            xpmParseResult.xpmHeader = this.parseXpmHeader(xpmParseResult.cParser);
            XpmParseResult xpmParseResult2 = xpmParseResult;
            return xpmParseResult2;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    private boolean parseNextString(BasicCParser cParser, StringBuilder stringBuilder) throws IOException, ImageReadException {
        stringBuilder.setLength(0);
        String token = cParser.nextToken();
        if (token.charAt(0) != '\"') {
            throw new ImageReadException("Parsing XPM file failed, no string found where expected");
        }
        BasicCParser.unescapeString(stringBuilder, token);
        token = cParser.nextToken();
        while (token.charAt(0) == '\"') {
            BasicCParser.unescapeString(stringBuilder, token);
            token = cParser.nextToken();
        }
        if (token.equals(",")) {
            return true;
        }
        if (token.equals("}")) {
            return false;
        }
        throw new ImageReadException("Parsing XPM file failed, no ',' or '}' found where expected");
    }

    private XpmHeader parseXpmValuesSection(String row) throws ImageReadException {
        String[] tokens = BasicCParser.tokenizeRow(row);
        if (tokens.length < 4 && tokens.length > 7) {
            throw new ImageReadException("Parsing XPM file failed, <Values> section has incorrect tokens");
        }
        try {
            int width = Integer.parseInt(tokens[0]);
            int height = Integer.parseInt(tokens[1]);
            int numColors = Integer.parseInt(tokens[2]);
            int numCharsPerPixel = Integer.parseInt(tokens[3]);
            int xHotSpot = -1;
            int yHotSpot = -1;
            boolean xpmExt = false;
            if (tokens.length >= 6) {
                xHotSpot = Integer.parseInt(tokens[4]);
                yHotSpot = Integer.parseInt(tokens[5]);
            }
            if (tokens.length == 5 || tokens.length == 7) {
                if (tokens[tokens.length - 1].equals("XPMEXT")) {
                    xpmExt = true;
                } else {
                    throw new ImageReadException("Parsing XPM file failed, can't parse <Values> section XPMEXT");
                }
            }
            return new XpmHeader(width, height, numColors, numCharsPerPixel, xHotSpot, yHotSpot, xpmExt);
        }
        catch (NumberFormatException nfe) {
            throw new ImageReadException("Parsing XPM file failed, error parsing <Values> section", nfe);
        }
    }

    private int parseColor(String color) throws ImageReadException {
        if (color.charAt(0) == '#') {
            if ((color = color.substring(1)).length() == 3) {
                int red = Integer.parseInt(color.substring(0, 1), 16);
                int green = Integer.parseInt(color.substring(1, 2), 16);
                int blue = Integer.parseInt(color.substring(2, 3), 16);
                return 0xFF000000 | red << 20 | green << 12 | blue << 4;
            }
            if (color.length() == 6) {
                return 0xFF000000 | Integer.parseInt(color, 16);
            }
            if (color.length() == 9) {
                int red = Integer.parseInt(color.substring(0, 1), 16);
                int green = Integer.parseInt(color.substring(3, 4), 16);
                int blue = Integer.parseInt(color.substring(6, 7), 16);
                return 0xFF000000 | red << 16 | green << 8 | blue;
            }
            if (color.length() == 12) {
                int red = Integer.parseInt(color.substring(0, 1), 16);
                int green = Integer.parseInt(color.substring(4, 5), 16);
                int blue = Integer.parseInt(color.substring(8, 9), 16);
                return 0xFF000000 | red << 16 | green << 8 | blue;
            }
            return 0;
        }
        if (color.charAt(0) == '%') {
            throw new ImageReadException("HSV colors are not implemented even in the XPM specification!");
        }
        if (color.equals("None")) {
            return 0;
        }
        if (!XpmImageParser.loadColorNames()) {
            return 0;
        }
        if (colorNames.containsKey(color)) {
            return (Integer)colorNames.get(color);
        }
        return 0;
    }

    private void parsePaletteEntries(XpmHeader xpmHeader, BasicCParser cParser) throws IOException, ImageReadException {
        StringBuilder row = new StringBuilder();
        for (int i = 0; i < xpmHeader.numColors; ++i) {
            row.setLength(0);
            boolean hasMore = this.parseNextString(cParser, row);
            if (!hasMore) {
                throw new ImageReadException("Parsing XPM file failed, file ended while reading palette");
            }
            String name = row.substring(0, xpmHeader.numCharsPerPixel);
            String[] tokens = BasicCParser.tokenizeRow(row.substring(xpmHeader.numCharsPerPixel));
            PaletteEntry paletteEntry = new PaletteEntry();
            paletteEntry.index = i;
            int previousKeyIndex = Integer.MIN_VALUE;
            StringBuilder colorBuffer = new StringBuilder();
            for (int j = 0; j < tokens.length; ++j) {
                String token = tokens[j];
                boolean isKey = false;
                if (previousKeyIndex < j - 1 && (token.equals("m") || token.equals("g4") || token.equals("g") || token.equals("c") || token.equals("s"))) {
                    isKey = true;
                }
                if (isKey) {
                    if (previousKeyIndex >= 0) {
                        String key = tokens[previousKeyIndex];
                        String color = colorBuffer.toString();
                        colorBuffer.setLength(0);
                        if (key.equals("m")) {
                            paletteEntry.monoArgb = this.parseColor(color);
                            paletteEntry.haveMono = true;
                        } else if (key.equals("g4")) {
                            paletteEntry.gray4LevelArgb = this.parseColor(color);
                            paletteEntry.haveGray4Level = true;
                        } else if (key.equals("g")) {
                            paletteEntry.grayArgb = this.parseColor(color);
                            paletteEntry.haveGray = true;
                        } else if (key.equals("s")) {
                            paletteEntry.symbolicName = color;
                        } else if (key.equals("c")) {
                            paletteEntry.colorArgb = this.parseColor(color);
                            paletteEntry.haveColor = true;
                        }
                    }
                    previousKeyIndex = j;
                    continue;
                }
                if (previousKeyIndex < 0) break;
                if (colorBuffer.length() > 0) {
                    colorBuffer.append(' ');
                }
                colorBuffer.append(token);
            }
            if (previousKeyIndex >= 0 && colorBuffer.length() > 0) {
                String key = tokens[previousKeyIndex];
                String color = colorBuffer.toString();
                colorBuffer.setLength(0);
                if (key.equals("m")) {
                    paletteEntry.monoArgb = this.parseColor(color);
                    paletteEntry.haveMono = true;
                } else if (key.equals("g4")) {
                    paletteEntry.gray4LevelArgb = this.parseColor(color);
                    paletteEntry.haveGray4Level = true;
                } else if (key.equals("g")) {
                    paletteEntry.grayArgb = this.parseColor(color);
                    paletteEntry.haveGray = true;
                } else if (key.equals("s")) {
                    paletteEntry.symbolicName = color;
                } else if (key.equals("c")) {
                    paletteEntry.colorArgb = this.parseColor(color);
                    paletteEntry.haveColor = true;
                }
            }
            xpmHeader.palette.put(name, paletteEntry);
        }
    }

    private XpmHeader parseXpmHeader(BasicCParser cParser) throws ImageReadException, IOException {
        String token = cParser.nextToken();
        if (token == null || !token.equals("static")) {
            throw new ImageReadException("Parsing XPM file failed, no 'static' token");
        }
        token = cParser.nextToken();
        if (token == null || !token.equals("char")) {
            throw new ImageReadException("Parsing XPM file failed, no 'char' token");
        }
        token = cParser.nextToken();
        if (token == null || !token.equals("*")) {
            throw new ImageReadException("Parsing XPM file failed, no '*' token");
        }
        String name = cParser.nextToken();
        if (name == null) {
            throw new ImageReadException("Parsing XPM file failed, no variable name");
        }
        if (name.charAt(0) != '_' && !Character.isLetter(name.charAt(0))) {
            throw new ImageReadException("Parsing XPM file failed, variable name doesn't start with letter or underscore");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw new ImageReadException("Parsing XPM file failed, variable name contains non-letter non-digit non-underscore");
        }
        token = cParser.nextToken();
        if (token == null || !token.equals("[")) {
            throw new ImageReadException("Parsing XPM file failed, no '[' token");
        }
        token = cParser.nextToken();
        if (token == null || !token.equals("]")) {
            throw new ImageReadException("Parsing XPM file failed, no ']' token");
        }
        token = cParser.nextToken();
        if (token == null || !token.equals("=")) {
            throw new ImageReadException("Parsing XPM file failed, no '=' token");
        }
        token = cParser.nextToken();
        if (token == null || !token.equals("{")) {
            throw new ImageReadException("Parsing XPM file failed, no '{' token");
        }
        StringBuilder row = new StringBuilder();
        boolean hasMore = this.parseNextString(cParser, row);
        if (!hasMore) {
            throw new ImageReadException("Parsing XPM file failed, file too short");
        }
        XpmHeader xpmHeader = this.parseXpmValuesSection(row.toString());
        this.parsePaletteEntries(xpmHeader, cParser);
        return xpmHeader;
    }

    private BufferedImage readXpmImage(XpmHeader xpmHeader, BasicCParser cParser) throws ImageReadException, IOException {
        int bpp;
        WritableRaster raster;
        ColorModel colorModel;
        PaletteEntry paletteEntry;
        int[] palette;
        if (xpmHeader.palette.size() <= 256) {
            palette = new int[xpmHeader.palette.size()];
            for (Map.Entry entry : xpmHeader.palette.entrySet()) {
                paletteEntry = (PaletteEntry)entry.getValue();
                palette[paletteEntry.index] = paletteEntry.getBestARGB();
            }
            colorModel = new IndexColorModel(8, xpmHeader.palette.size(), palette, 0, true, -1, 0);
            raster = WritableRaster.createInterleavedRaster(0, xpmHeader.width, xpmHeader.height, 1, null);
            bpp = 8;
        } else if (xpmHeader.palette.size() <= 65536) {
            palette = new int[xpmHeader.palette.size()];
            for (Map.Entry entry : xpmHeader.palette.entrySet()) {
                paletteEntry = (PaletteEntry)entry.getValue();
                palette[paletteEntry.index] = paletteEntry.getBestARGB();
            }
            colorModel = new IndexColorModel(16, xpmHeader.palette.size(), palette, 0, true, -1, 1);
            raster = WritableRaster.createInterleavedRaster(1, xpmHeader.width, xpmHeader.height, 1, null);
            bpp = 16;
        } else {
            colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            raster = WritableRaster.createPackedRaster(3, xpmHeader.width, xpmHeader.height, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            bpp = 32;
        }
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), new Properties());
        DataBuffer dataBuffer = raster.getDataBuffer();
        StringBuilder row = new StringBuilder();
        boolean hasMore = true;
        for (int y = 0; y < xpmHeader.height; ++y) {
            row.setLength(0);
            hasMore = this.parseNextString(cParser, row);
            if (y < xpmHeader.height - 1 && !hasMore) {
                throw new ImageReadException("Parsing XPM file failed, insufficient image rows in file");
            }
            int rowOffset = y * xpmHeader.width;
            for (int x = 0; x < xpmHeader.width; ++x) {
                String index = row.substring(x * xpmHeader.numCharsPerPixel, (x + 1) * xpmHeader.numCharsPerPixel);
                PaletteEntry paletteEntry2 = (PaletteEntry)xpmHeader.palette.get(index);
                if (paletteEntry2 == null) {
                    throw new ImageReadException("No palette entry was defined for " + index);
                }
                if (bpp <= 16) {
                    dataBuffer.setElem(rowOffset + x, paletteEntry2.index);
                    continue;
                }
                dataBuffer.setElem(rowOffset + x, paletteEntry2.getBestARGB());
            }
        }
        while (hasMore) {
            row.setLength(0);
            hasMore = this.parseNextString(cParser, row);
        }
        String token = cParser.nextToken();
        if (!token.equals(";")) {
            throw new ImageReadException("Last token wasn't ';'");
        }
        return image;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        this.readXpmHeader(byteSource).dump(pw);
        return true;
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        XpmParseResult result = this.parseXpmHeader(byteSource);
        return this.readXpmImage(result.xpmHeader, result.cParser);
    }

    private String randomName() {
        int i;
        UUID uuid = UUID.randomUUID();
        StringBuilder stringBuilder = new StringBuilder("a");
        long bits = uuid.getMostSignificantBits();
        for (i = 56; i >= 0; i -= 8) {
            stringBuilder.append(Integer.toHexString((int)(bits >> i & 0xFFL)));
        }
        bits = uuid.getLeastSignificantBits();
        for (i = 56; i >= 0; i -= 8) {
            stringBuilder.append(Integer.toHexString((int)(bits >> i & 0xFFL)));
        }
        return stringBuilder.toString();
    }

    private String pixelsForIndex(int index, int charsPerPixel) {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        int highestPower = 1;
        for (i = 1; i < charsPerPixel; ++i) {
            highestPower *= writePalette.length;
        }
        for (i = 0; i < charsPerPixel; ++i) {
            int multiple = index / highestPower;
            index -= multiple * highestPower;
            highestPower /= writePalette.length;
            stringBuilder.append(writePalette[multiple]);
        }
        return stringBuilder.toString();
    }

    private String toColor(int color) {
        String hex = Integer.toHexString(color);
        if (hex.length() < 6) {
            char[] zeroes = new char[6 - hex.length()];
            Arrays.fill(zeroes, '0');
            return "#" + new String(zeroes) + hex;
        }
        return "#" + hex;
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        HashMap hashMap = params = params == null ? new HashMap() : new HashMap(params);
        if (params.containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        PaletteFactory paletteFactory = new PaletteFactory();
        boolean hasTransparency = false;
        if (paletteFactory.hasTransparency(src, 1)) {
            hasTransparency = true;
        }
        SimplePalette palette = null;
        int maxColors = writePalette.length;
        int charsPerPixel = 1;
        while (palette == null) {
            palette = paletteFactory.makePaletteSimple(src, hasTransparency ? maxColors - 1 : maxColors);
            if (palette != null) continue;
            maxColors *= writePalette.length;
            ++charsPerPixel;
        }
        int colors = palette.length();
        if (hasTransparency) {
            ++colors;
        }
        String line = "/* XPM */\n";
        os.write(line.getBytes("US-ASCII"));
        line = "static char *" + this.randomName() + "[] = {\n";
        os.write(line.getBytes("US-ASCII"));
        line = "\"" + src.getWidth() + " " + src.getHeight() + " " + colors + " " + charsPerPixel + "\",\n";
        os.write(line.getBytes("US-ASCII"));
        for (int i = 0; i < colors; ++i) {
            String color = i < palette.length() ? this.toColor(palette.getEntry(i)) : "None";
            line = "\"" + this.pixelsForIndex(i, charsPerPixel) + " c " + color + "\",\n";
            os.write(line.getBytes("US-ASCII"));
        }
        String separator = "";
        for (int y = 0; y < src.getHeight(); ++y) {
            os.write(separator.getBytes("US-ASCII"));
            separator = ",\n";
            line = "\"";
            os.write(line.getBytes("US-ASCII"));
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                line = (argb & 0xFF000000) == 0 ? this.pixelsForIndex(palette.length(), charsPerPixel) : this.pixelsForIndex(palette.getPaletteIndex(0xFFFFFF & argb), charsPerPixel);
                os.write(line.getBytes("US-ASCII"));
            }
            line = "\"";
            os.write(line.getBytes("US-ASCII"));
        }
        line = "\n};\n";
        os.write(line.getBytes("US-ASCII"));
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private static class XpmParseResult {
        XpmHeader xpmHeader;
        BasicCParser cParser;

        private XpmParseResult() {
        }
    }

    private static class PaletteEntry {
        int index;
        boolean haveColor = false;
        int colorArgb;
        boolean haveGray = false;
        int grayArgb;
        boolean haveGray4Level = false;
        int gray4LevelArgb;
        boolean haveMono = false;
        int monoArgb;
        String symbolicName = null;

        private PaletteEntry() {
        }

        int getBestARGB() {
            if (this.haveColor) {
                return this.colorArgb;
            }
            if (this.haveGray) {
                return this.grayArgb;
            }
            if (this.haveGray4Level) {
                return this.gray4LevelArgb;
            }
            if (this.haveMono) {
                return this.monoArgb;
            }
            return 0;
        }
    }

    private static class XpmHeader {
        int width;
        int height;
        int numColors;
        int numCharsPerPixel;
        int xHotSpot = -1;
        int yHotSpot = -1;
        boolean xpmExt;
        Map palette = new HashMap();

        public XpmHeader(int width, int height, int numColors, int numCharsPerPixel, int xHotSpot, int yHotSpot, boolean xpmExt) {
            this.width = width;
            this.height = height;
            this.numColors = numColors;
            this.numCharsPerPixel = numCharsPerPixel;
            this.xHotSpot = xHotSpot;
            this.yHotSpot = yHotSpot;
            this.xpmExt = xpmExt;
        }

        public void dump(PrintWriter pw) {
            pw.println("XpmHeader");
            pw.println("Width: " + this.width);
            pw.println("Height: " + this.height);
            pw.println("NumColors: " + this.numColors);
            pw.println("NumCharsPerPixel: " + this.numCharsPerPixel);
            if (this.xHotSpot != -1 && this.yHotSpot != -1) {
                pw.println("X hotspot: " + this.xHotSpot);
                pw.println("Y hotspot: " + this.yHotSpot);
            }
            pw.println("XpmExt: " + this.xpmExt);
        }
    }
}

