/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.bmp;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.bmp.BmpHeaderInfo;
import org.apache.sanselan.formats.bmp.ImageContents;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParser;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParserBitFields;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParserRgb;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParserRle;
import org.apache.sanselan.formats.bmp.writers.BMPWriter;
import org.apache.sanselan.formats.bmp.writers.BMPWriterPalette;
import org.apache.sanselan.formats.bmp.writers.BMPWriterRGB;
import org.apache.sanselan.palette.PaletteFactory;
import org.apache.sanselan.palette.SimplePalette;
import org.apache.sanselan.util.Debug;
import org.apache.sanselan.util.ParamMap;

public class BmpImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".bmp";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".bmp"};
    private static final byte[] BMP_HEADER_SIGNATURE = new byte[]{66, 77};
    private static final int BI_RGB = 0;
    private static final int BI_RLE4 = 2;
    private static final int BI_RLE8 = 1;
    private static final int BI_BITFIELDS = 3;
    private static final int BITMAP_FILE_HEADER_SIZE = 14;
    private static final int BITMAP_INFO_HEADER_SIZE = 40;

    public BmpImageParser() {
        super.setByteOrder(73);
    }

    @Override
    public String getName() {
        return "Bmp-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_BMP};
    }

    private BmpHeaderInfo readBmpHeaderInfo(InputStream is, FormatCompliance formatCompliance, boolean verbose) throws ImageReadException, IOException {
        byte identifier1 = this.readByte("Identifier1", is, "Not a Valid BMP File");
        byte identifier2 = this.readByte("Identifier2", is, "Not a Valid BMP File");
        if (formatCompliance != null) {
            formatCompliance.compare_bytes("Signature", BMP_HEADER_SIGNATURE, new byte[]{identifier1, identifier2});
        }
        int fileSize = this.read4Bytes("File Size", is, "Not a Valid BMP File");
        int reserved = this.read4Bytes("Reserved", is, "Not a Valid BMP File");
        int bitmapDataOffset = this.read4Bytes("Bitmap Data Offset", is, "Not a Valid BMP File");
        int bitmapHeaderSize = this.read4Bytes("Bitmap Header Size", is, "Not a Valid BMP File");
        int width = 0;
        int height = 0;
        int planes = 0;
        int bitsPerPixel = 0;
        int compression = 0;
        int bitmapDataSize = 0;
        int hResolution = 0;
        int vResolution = 0;
        int colorsUsed = 0;
        int colorsImportant = 0;
        int redMask = 0;
        int greenMask = 0;
        int blueMask = 0;
        int alphaMask = 0;
        int colorSpaceType = 0;
        BmpHeaderInfo.ColorSpace colorSpace = new BmpHeaderInfo.ColorSpace();
        colorSpace.red = new BmpHeaderInfo.ColorSpaceCoordinate();
        colorSpace.green = new BmpHeaderInfo.ColorSpaceCoordinate();
        colorSpace.blue = new BmpHeaderInfo.ColorSpaceCoordinate();
        int gammaRed = 0;
        int gammaGreen = 0;
        int gammaBlue = 0;
        int intent = 0;
        int profileData = 0;
        int profileSize = 0;
        int reservedV5 = 0;
        if (bitmapHeaderSize >= 40) {
            width = this.read4Bytes("Width", is, "Not a Valid BMP File");
            height = this.read4Bytes("Height", is, "Not a Valid BMP File");
            planes = this.read2Bytes("Planes", is, "Not a Valid BMP File");
            bitsPerPixel = this.read2Bytes("Bits Per Pixel", is, "Not a Valid BMP File");
            compression = this.read4Bytes("Compression", is, "Not a Valid BMP File");
            bitmapDataSize = this.read4Bytes("Bitmap Data Size", is, "Not a Valid BMP File");
            hResolution = this.read4Bytes("HResolution", is, "Not a Valid BMP File");
            vResolution = this.read4Bytes("VResolution", is, "Not a Valid BMP File");
            colorsUsed = this.read4Bytes("ColorsUsed", is, "Not a Valid BMP File");
            colorsImportant = this.read4Bytes("ColorsImportant", is, "Not a Valid BMP File");
            if (bitmapHeaderSize >= 52 || compression == 3) {
                redMask = this.read4Bytes("RedMask", is, "Not a Valid BMP File");
                greenMask = this.read4Bytes("GreenMask", is, "Not a Valid BMP File");
                blueMask = this.read4Bytes("BlueMask", is, "Not a Valid BMP File");
            }
            if (bitmapHeaderSize >= 56) {
                alphaMask = this.read4Bytes("AlphaMask", is, "Not a Valid BMP File");
            }
            if (bitmapHeaderSize >= 108) {
                colorSpaceType = this.read4Bytes("ColorSpaceType", is, "Not a Valid BMP File");
                colorSpace.red.x = this.read4Bytes("ColorSpaceRedX", is, "Not a Valid BMP File");
                colorSpace.red.y = this.read4Bytes("ColorSpaceRedY", is, "Not a Valid BMP File");
                colorSpace.red.z = this.read4Bytes("ColorSpaceRedZ", is, "Not a Valid BMP File");
                colorSpace.green.x = this.read4Bytes("ColorSpaceGreenX", is, "Not a Valid BMP File");
                colorSpace.green.y = this.read4Bytes("ColorSpaceGreenY", is, "Not a Valid BMP File");
                colorSpace.green.z = this.read4Bytes("ColorSpaceGreenZ", is, "Not a Valid BMP File");
                colorSpace.blue.x = this.read4Bytes("ColorSpaceBlueX", is, "Not a Valid BMP File");
                colorSpace.blue.y = this.read4Bytes("ColorSpaceBlueY", is, "Not a Valid BMP File");
                colorSpace.blue.z = this.read4Bytes("ColorSpaceBlueZ", is, "Not a Valid BMP File");
                gammaRed = this.read4Bytes("GammaRed", is, "Not a Valid BMP File");
                gammaGreen = this.read4Bytes("GammaGreen", is, "Not a Valid BMP File");
                gammaBlue = this.read4Bytes("GammaBlue", is, "Not a Valid BMP File");
            }
            if (bitmapHeaderSize >= 124) {
                intent = this.read4Bytes("Intent", is, "Not a Valid BMP File");
                profileData = this.read4Bytes("ProfileData", is, "Not a Valid BMP File");
                profileSize = this.read4Bytes("ProfileSize", is, "Not a Valid BMP File");
                reservedV5 = this.read4Bytes("Reserved", is, "Not a Valid BMP File");
            }
        } else {
            throw new ImageReadException("Invalid/unsupported BMP file");
        }
        if (verbose) {
            this.debugNumber("identifier1", identifier1, 1);
            this.debugNumber("identifier2", identifier2, 1);
            this.debugNumber("fileSize", fileSize, 4);
            this.debugNumber("reserved", reserved, 4);
            this.debugNumber("bitmapDataOffset", bitmapDataOffset, 4);
            this.debugNumber("bitmapHeaderSize", bitmapHeaderSize, 4);
            this.debugNumber("width", width, 4);
            this.debugNumber("height", height, 4);
            this.debugNumber("planes", planes, 2);
            this.debugNumber("bitsPerPixel", bitsPerPixel, 2);
            this.debugNumber("compression", compression, 4);
            this.debugNumber("bitmapDataSize", bitmapDataSize, 4);
            this.debugNumber("hResolution", hResolution, 4);
            this.debugNumber("vResolution", vResolution, 4);
            this.debugNumber("colorsUsed", colorsUsed, 4);
            this.debugNumber("colorsImportant", colorsImportant, 4);
            if (bitmapHeaderSize >= 52 || compression == 3) {
                this.debugNumber("redMask", redMask, 4);
                this.debugNumber("greenMask", greenMask, 4);
                this.debugNumber("blueMask", blueMask, 4);
            }
            if (bitmapHeaderSize >= 56) {
                this.debugNumber("alphaMask", alphaMask, 4);
            }
            if (bitmapHeaderSize >= 108) {
                this.debugNumber("colorSpaceType", colorSpaceType, 4);
                this.debugNumber("gammaRed", gammaRed, 4);
                this.debugNumber("gammaGreen", gammaGreen, 4);
                this.debugNumber("gammaBlue", gammaBlue, 4);
            }
            if (bitmapHeaderSize >= 124) {
                this.debugNumber("intent", intent, 4);
                this.debugNumber("profileData", profileData, 4);
                this.debugNumber("profileSize", profileSize, 4);
                this.debugNumber("reservedV5", reservedV5, 4);
            }
        }
        BmpHeaderInfo result = new BmpHeaderInfo(identifier1, identifier2, fileSize, reserved, bitmapDataOffset, bitmapHeaderSize, width, height, planes, bitsPerPixel, compression, bitmapDataSize, hResolution, vResolution, colorsUsed, colorsImportant, redMask, greenMask, blueMask, alphaMask, colorSpaceType, colorSpace, gammaRed, gammaGreen, gammaBlue, intent, profileData, profileSize, reservedV5);
        return result;
    }

    private byte[] getRLEBytes(InputStream is, int RLESamplesPerByte) throws ImageReadException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean done = false;
        block5: while (!done) {
            int a = 0xFF & this.readByte("RLE a", is, "BMP: Bad RLE");
            baos.write(a);
            int b = 0xFF & this.readByte("RLE b", is, "BMP: Bad RLE");
            baos.write(b);
            if (a != 0) continue;
            switch (b) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    done = true;
                    continue block5;
                }
                case 2: {
                    int c = 0xFF & this.readByte("RLE c", is, "BMP: Bad RLE");
                    baos.write(c);
                    int d = 0xFF & this.readByte("RLE d", is, "BMP: Bad RLE");
                    baos.write(d);
                    continue block5;
                }
            }
            int size = b / RLESamplesPerByte;
            if (b % RLESamplesPerByte > 0) {
                ++size;
            }
            if (size % 2 != 0) {
                ++size;
            }
            byte[] bytes = this.readByteArray("bytes", size, is, "RLE: Absolute Mode");
            baos.write(bytes);
        }
        return baos.toByteArray();
    }

    private ImageContents readImageContents(InputStream is, FormatCompliance formatCompliance, boolean verbose) throws ImageReadException, IOException {
        PixelParser pixelParser;
        int extraBytes;
        int paletteLength;
        BmpHeaderInfo bhi = this.readBmpHeaderInfo(is, formatCompliance, verbose);
        int colorTableSize = bhi.colorsUsed;
        if (colorTableSize == 0) {
            colorTableSize = 1 << bhi.bitsPerPixel;
        }
        if (verbose) {
            this.debugNumber("ColorsUsed", bhi.colorsUsed, 4);
            this.debugNumber("BitsPerPixel", bhi.bitsPerPixel, 4);
            this.debugNumber("ColorTableSize", colorTableSize, 4);
            this.debugNumber("bhi.colorsUsed", bhi.colorsUsed, 4);
            this.debugNumber("Compression", bhi.compression, 4);
        }
        int rleSamplesPerByte = 0;
        boolean rle = false;
        switch (bhi.compression) {
            case 0: {
                if (verbose) {
                    System.out.println("Compression: BI_RGB");
                }
                if (bhi.bitsPerPixel <= 8) {
                    paletteLength = 4 * colorTableSize;
                    break;
                }
                paletteLength = 0;
                break;
            }
            case 2: {
                if (verbose) {
                    System.out.println("Compression: BI_RLE4");
                }
                paletteLength = 4 * colorTableSize;
                rleSamplesPerByte = 2;
                rle = true;
                break;
            }
            case 1: {
                if (verbose) {
                    System.out.println("Compression: BI_RLE8");
                }
                paletteLength = 4 * colorTableSize;
                rleSamplesPerByte = 1;
                rle = true;
                break;
            }
            case 3: {
                if (verbose) {
                    System.out.println("Compression: BI_BITFIELDS");
                }
                if (bhi.bitsPerPixel <= 8) {
                    paletteLength = 4 * colorTableSize;
                    break;
                }
                paletteLength = 0;
                break;
            }
            default: {
                throw new ImageReadException("BMP: Unknown Compression: " + bhi.compression);
            }
        }
        byte[] colorTable = null;
        if (paletteLength > 0) {
            colorTable = this.readByteArray("ColorTable", paletteLength, is, "Not a Valid BMP File");
        }
        if (verbose) {
            this.debugNumber("paletteLength", paletteLength, 4);
            System.out.println("ColorTable: " + (colorTable == null ? "null" : "" + colorTable.length));
        }
        int pixelCount = bhi.width * bhi.height;
        int imageLineLength = (bhi.bitsPerPixel * bhi.width + 7) / 8;
        if (verbose) {
            this.debugNumber("bhi.Width", bhi.width, 4);
            this.debugNumber("bhi.Height", bhi.height, 4);
            this.debugNumber("ImageLineLength", imageLineLength, 4);
            this.debugNumber("PixelCount", pixelCount, 4);
        }
        while (imageLineLength % 4 != 0) {
            ++imageLineLength;
        }
        int headerSize = 14 + bhi.bitmapHeaderSize + (bhi.bitmapHeaderSize == 40 && bhi.compression == 3 ? 12 : 0);
        int expectedDataOffset = headerSize + paletteLength;
        if (verbose) {
            this.debugNumber("bhi.BitmapDataOffset", bhi.bitmapDataOffset, 4);
            this.debugNumber("expectedDataOffset", expectedDataOffset, 4);
        }
        if ((extraBytes = bhi.bitmapDataOffset - expectedDataOffset) < 0) {
            throw new ImageReadException("BMP has invalid image data offset: " + bhi.bitmapDataOffset + " (expected: " + expectedDataOffset + ", paletteLength: " + paletteLength + ", headerSize: " + headerSize + ")");
        }
        if (extraBytes > 0) {
            this.readByteArray("BitmapDataOffset", extraBytes, is, "Not a Valid BMP File");
        }
        int imageDataSize = bhi.height * imageLineLength;
        if (verbose) {
            this.debugNumber("imageDataSize", imageDataSize, 4);
        }
        byte[] imageData = rle ? this.getRLEBytes(is, rleSamplesPerByte) : this.readByteArray("ImageData", imageDataSize, is, "Not a Valid BMP File");
        if (verbose) {
            this.debugNumber("ImageData.length", imageData.length, 4);
        }
        switch (bhi.compression) {
            case 1: 
            case 2: {
                pixelParser = new PixelParserRle(bhi, colorTable, imageData);
                break;
            }
            case 0: {
                pixelParser = new PixelParserRgb(bhi, colorTable, imageData);
                break;
            }
            case 3: {
                pixelParser = new PixelParserBitFields(bhi, colorTable, imageData);
                break;
            }
            default: {
                throw new ImageReadException("BMP: Unknown Compression: " + bhi.compression);
            }
        }
        return new ImageContents(bhi, colorTable, imageData, pixelParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BmpHeaderInfo readBmpHeaderInfo(ByteSource byteSource, boolean verbose) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            BmpHeaderInfo bmpHeaderInfo = this.readBmpHeaderInfo(is, null, verbose);
            return bmpHeaderInfo;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        params = params == null ? new HashMap() : new HashMap(params);
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageReadException("Unknown parameter: " + firstKey);
        }
        BmpHeaderInfo bhi = this.readBmpHeaderInfo(byteSource, verbose);
        if (bhi == null) {
            throw new ImageReadException("BMP: couldn't read header");
        }
        return new Dimension(bhi.width, bhi.height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private String getBmpTypeDescription(int Identifier1, int Identifier2) {
        if (Identifier1 == 66 && Identifier2 == 77) {
            return "Windows 3.1x, 95, NT,";
        }
        if (Identifier1 == 66 && Identifier2 == 65) {
            return "OS/2 Bitmap Array";
        }
        if (Identifier1 == 67 && Identifier2 == 73) {
            return "OS/2 Color Icon";
        }
        if (Identifier1 == 67 && Identifier2 == 80) {
            return "OS/2 Color Pointer";
        }
        if (Identifier1 == 73 && Identifier2 == 67) {
            return "OS/2 Icon";
        }
        if (Identifier1 == 80 && Identifier2 == 84) {
            return "OS/2 Pointer";
        }
        return "Unknown";
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        params = params == null ? new HashMap() : new HashMap(params);
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageReadException("Unknown parameter: " + firstKey);
        }
        ImageContents ic = this.readImageContents(byteSource.getInputStream(), FormatCompliance.getDefault(), verbose);
        if (ic == null) {
            throw new ImageReadException("Couldn't read BMP Data");
        }
        BmpHeaderInfo bhi = ic.bhi;
        byte[] colorTable = ic.colorTable;
        if (bhi == null) {
            throw new ImageReadException("BMP: couldn't read header");
        }
        int height = bhi.height;
        int width = bhi.width;
        ArrayList comments = new ArrayList();
        int bitsPerPixel = bhi.bitsPerPixel;
        ImageFormat format = ImageFormat.IMAGE_FORMAT_BMP;
        String name = "BMP Windows Bitmap";
        String mimeType = "image/x-ms-bmp";
        int numberOfImages = -1;
        boolean isProgressive = false;
        int physicalWidthDpi = (int)((double)bhi.hResolution * 1000.0 / 2.54);
        float physicalWidthInch = (float)((double)width / (double)physicalWidthDpi);
        int physicalHeightDpi = (int)((double)bhi.vResolution * 1000.0 / 2.54);
        float physicalHeightInch = (float)((double)height / (double)physicalHeightDpi);
        String formatDetails = "Bmp (" + (char)bhi.identifier1 + (char)bhi.identifier2 + ": " + this.getBmpTypeDescription(bhi.identifier1, bhi.identifier2) + ")";
        boolean isTransparent = false;
        boolean usesPalette = colorTable != null;
        int colorType = 2;
        String compressionAlgorithm = "RLE: Run-Length Encoding";
        ImageInfo result = new ImageInfo(formatDetails, bitsPerPixel, comments, format, name, height, mimeType, numberOfImages, physicalHeightDpi, physicalHeightInch, physicalWidthDpi, physicalWidthInch, width, isProgressive, isTransparent, usesPalette, colorType, compressionAlgorithm);
        return result;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("bmp.dumpImageFile");
        ImageInfo imageData = this.getImageInfo(byteSource, null);
        if (imageData == null) {
            return false;
        }
        imageData.toString(pw, "");
        pw.println("");
        return true;
    }

    @Override
    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImageReadException, IOException {
        boolean verbose = false;
        FormatCompliance result = new FormatCompliance(byteSource.getDescription());
        this.readImageContents(byteSource.getInputStream(), result, verbose);
        return result;
    }

    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return this.getBufferedImage(byteSource.getInputStream(), params);
    }

    public BufferedImage getBufferedImage(InputStream inputStream, Map params) throws ImageReadException, IOException {
        params = params == null ? new HashMap() : new HashMap(params);
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        if (params.containsKey("BUFFERED_IMAGE_FACTORY")) {
            params.remove("BUFFERED_IMAGE_FACTORY");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageReadException("Unknown parameter: " + firstKey);
        }
        ImageContents ic = this.readImageContents(inputStream, FormatCompliance.getDefault(), verbose);
        if (ic == null) {
            throw new ImageReadException("Couldn't read BMP Data");
        }
        BmpHeaderInfo bhi = ic.bhi;
        int width = bhi.width;
        int height = bhi.height;
        BufferedImage result = this.getBufferedImageFactory(params).getColorBufferedImage(width, height, true);
        if (verbose) {
            System.out.println("width: " + width);
            System.out.println("height: " + height);
            System.out.println("width*height: " + width * height);
            System.out.println("width*height*4: " + width * height * 4);
        }
        PixelParser pixelParser = ic.pixelParser;
        pixelParser.processImage(result);
        return result;
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        HashMap hashMap = params = params == null ? new HashMap() : new HashMap(params);
        if (params.containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        SimplePalette palette = new PaletteFactory().makePaletteSimple(src, 256);
        BMPWriter writer = null;
        writer = palette == null ? new BMPWriterRGB() : new BMPWriterPalette(palette);
        byte[] imagedata = writer.getImageData(src);
        BinaryOutputStream bos = new BinaryOutputStream(os, 73);
        os.write(66);
        os.write(77);
        int filesize = 54 + 4 * writer.getPaletteSize() + imagedata.length;
        bos.write4Bytes(filesize);
        bos.write4Bytes(0);
        bos.write4Bytes(54 + 4 * writer.getPaletteSize());
        int width = src.getWidth();
        int height = src.getHeight();
        bos.write4Bytes(40);
        bos.write4Bytes(width);
        bos.write4Bytes(height);
        bos.write2Bytes(1);
        bos.write2Bytes(writer.getBitsPerPixel());
        bos.write4Bytes(0);
        bos.write4Bytes(imagedata.length);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        if (palette == null) {
            bos.write4Bytes(0);
        } else {
            bos.write4Bytes(palette.length());
        }
        bos.write4Bytes(0);
        writer.writePalette(bos);
        bos.writeByteArray(imagedata);
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }
}

