/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello.model;

import com.google.gson.annotations.SerializedName;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import com.intellij.tasks.trello.model.TrelloLabel;
import com.intellij.tasks.trello.model.TrelloModel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloCard
extends TrelloModel {
    public static final String REQUIRED_FIELDS = "closed,desc,idMembers,idBoard,idList,labels,name,url,dateLastActivity";
    private String idBoard;
    private String idList;
    private List<String> idMembers;
    private String name;
    @SerializedName(value="desc")
    private String description;
    private String url;
    private boolean closed;
    private Date dateLastActivity;
    private List<TrelloLabel> labels;
    @SerializedName(value="actions")
    private List<TrelloCommentAction> comments = ContainerUtil.emptyList();
    private boolean isVisible = true;

    public String toString() {
        return String.format("TrelloCard(id='%s', name='%s')", this.getId(), this.name);
    }

    @NotNull
    public String getIdBoard() {
        String string = this.idBoard;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getIdBoard"));
        }
        return string;
    }

    @NotNull
    public String getIdList() {
        String string = this.idList;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getIdList"));
        }
        return string;
    }

    @NotNull
    public List<String> getIdMembers() {
        List<String> list = this.idMembers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getIdMembers"));
        }
        return list;
    }

    @Override
    @Attribute(value="name")
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getName"));
        }
        return string;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tasks/trello/model/TrelloCard", "setName"));
        }
        this.name = name;
    }

    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = this.url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getUrl"));
        }
        return string;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @NotNull
    public List<TrelloLabel> getLabels() {
        List<TrelloLabel> list = this.labels;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getLabels"));
        }
        return list;
    }

    @NotNull
    public List<TrelloCommentAction> getComments() {
        List<TrelloCommentAction> list = this.comments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getComments"));
        }
        return list;
    }

    @NotNull
    public Set<TrelloLabel.LabelColor> getColors() {
        if (this.labels == null || this.labels.isEmpty()) {
            EnumSet<TrelloLabel.LabelColor> enumSet = EnumSet.noneOf(TrelloLabel.LabelColor.class);
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getColors"));
            }
            return enumSet;
        }
        EnumSet<TrelloLabel.LabelColor> enumSet = EnumSet.copyOf(ContainerUtil.mapNotNull(this.labels, (Function)new Function<TrelloLabel, TrelloLabel.LabelColor>(){

            public TrelloLabel.LabelColor fun(TrelloLabel label) {
                TrelloLabel.LabelColor color = label.getColor();
                return color == TrelloLabel.LabelColor.NO_COLOR ? null : color;
            }
        }));
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/model/TrelloCard", "getColors"));
        }
        return enumSet;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Nullable
    public Date getDateLastActivity() {
        return this.dateLastActivity;
    }
}

