/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.Complex2Vector;
import JSci.maths.vectors.Integer2Vector;
import JSci.maths.vectors.VectorDimensionException;

public final class Double2Vector
extends AbstractDoubleVector {
    protected double x;
    protected double y;

    public Double2Vector() {
        super(2);
    }

    public Double2Vector(double d, double d2) {
        this();
        this.x = d;
        this.y = d2;
    }

    public Double2Vector(double[] dArray) {
        this();
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof Double2Vector) {
            Double2Vector double2Vector = (Double2Vector)object;
            double d2 = this.x - double2Vector.x;
            double d3 = this.y - double2Vector.y;
            return d2 * d2 + d3 * d3 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(this.x).append(',').append(this.y);
        return stringBuffer.toString();
    }

    public AbstractIntegerVector toIntegerVector() {
        return new Integer2Vector(Math.round((float)this.x), Math.round((float)this.y));
    }

    public AbstractComplexVector toComplexVector() {
        return new Complex2Vector(this.x, 0.0, this.y, 0.0);
    }

    public double getComponent(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, double d) {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.x), n) + Math.pow(Math.abs(this.y), n);
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double infNorm() {
        double d = 0.0;
        double d2 = Math.abs(this.x);
        if (d2 > d) {
            d = d2;
        }
        if ((d2 = Math.abs(this.y)) > d) {
            d = d2;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        return new Double2Vector(-this.x, -this.y);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector add(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 2) {
            return new Double2Vector(this.x + abstractDoubleVector.getComponent(0), this.y + abstractDoubleVector.getComponent(1));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 2) {
            return new Double2Vector(this.x - abstractDoubleVector.getComponent(0), this.y - abstractDoubleVector.getComponent(1));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarMultiply(double d) {
        return new Double2Vector(d * this.x, d * this.y);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarDivide(double d) {
        return new Double2Vector(this.x / d, this.y / d);
    }

    public double scalarProduct(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 2) {
            return this.x * abstractDoubleVector.getComponent(0) + this.y * abstractDoubleVector.getComponent(1);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractDoubleVector mapComponents(Mapping mapping) {
        return new Double2Vector(mapping.map(this.x), mapping.map(this.y));
    }
}

