/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.symbolic;

import JSci.maths.Member;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.symbolic.Constant;
import JSci.maths.symbolic.Expression;

public class Variable
extends Expression {
    private final String name;
    private final Object valueSet;
    private Member value = null;

    public Variable(String string, Object object) {
        this.name = string;
        this.valueSet = object;
    }

    public void setValue(Member member) {
        if (member == null) {
            this.value = null;
            return;
        }
        if (!this.valueSet.getClass().isInstance(member.getSet())) {
            throw new ClassCastException("Variable " + this + " set to " + member.getSet() + " value (" + this.valueSet + " required.");
        }
        this.value = member;
    }

    public Member getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Variable)) {
            return false;
        }
        return this == object;
    }

    public String toString() {
        return this.name;
    }

    public Expression differentiate(Variable variable) {
        if (this.equals(variable)) {
            return new Constant(((Ring)this.valueSet).one());
        }
        return new Constant(((AbelianGroup)this.valueSet).zero());
    }

    public Expression evaluate() {
        if (this.value == null) {
            return this;
        }
        if (this.value instanceof Expression) {
            return ((Expression)this.value).evaluate();
        }
        return new Constant(this.value);
    }

    protected int getPriority() {
        return 20;
    }

    public Object getSet() {
        return (AbelianGroup)this.valueSet;
    }
}

