/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.NormalDistribution;
import JSci.maths.statistics.ProbabilityDistribution;

public final class LognormalDistribution
extends ProbabilityDistribution {
    private NormalDistribution normal;

    public LognormalDistribution() {
        this(0.0, 1.0);
    }

    public LognormalDistribution(double d, double d2) {
        this.normal = new NormalDistribution(d, d2 * d2);
    }

    public double getMuParameter() {
        return this.normal.getMean();
    }

    public double getSigmaParameter() {
        return Math.sqrt(this.normal.getVariance());
    }

    public double probability(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return this.normal.probability(Math.log(d)) / d;
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return this.normal.cumulative(Math.log(d));
    }

    public double inverse(double d) {
        return Math.exp(this.normal.inverse(d));
    }
}

