/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.maths.ExtraMath;
import JSci.maths.Mapping;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.ComplexDiagonalMatrix;
import JSci.maths.matrices.DiagonalMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.DoubleTridiagonalMatrix;
import JSci.maths.matrices.IntegerDiagonalMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.matrices.TridiagonalMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;

public class DoubleDiagonalMatrix
extends AbstractDoubleSquareMatrix
implements DiagonalMatrix {
    protected final double[] diag;

    public DoubleDiagonalMatrix(int n) {
        this(new double[n]);
    }

    public DoubleDiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length != dArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diag[i] = dArray[i][i];
        }
    }

    public DoubleDiagonalMatrix(double[] dArray) {
        super(dArray.length);
        this.diag = dArray;
    }

    public static DoubleDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 1.0;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix, double d) {
        if (abstractDoubleMatrix instanceof DiagonalMatrix) {
            if (this.numRows != abstractDoubleMatrix.rows() || this.numCols != abstractDoubleMatrix.columns()) {
                return false;
            }
            double d2 = 0.0;
            double d3 = this.diag[0] - abstractDoubleMatrix.getElement(0, 0);
            d2 += d3 * d3;
            for (int i = 1; i < this.numRows; ++i) {
                d3 = this.diag[i] - abstractDoubleMatrix.getElement(i, i);
                d2 += d3 * d3;
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[] nArray = new int[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            nArray[i] = Math.round((float)this.diag[i]);
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        double[] dArray = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i] = this.diag[i];
        }
        return new ComplexDiagonalMatrix(dArray, new double[this.numRows]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diag[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n != n2) {
                throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diag[n] = d;
    }

    public boolean isSymmetric() {
        return true;
    }

    public double det() {
        double d = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            d *= this.diag[i];
        }
        return d;
    }

    public double trace() {
        double d = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            d += this.diag[i];
        }
        return d;
    }

    public double infNorm() {
        double d = Math.abs(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            double d2 = Math.abs(this.diag[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            d = ExtraMath.hypot(d, this.diag[i]);
        }
        return d;
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return this.infNorm();
    }

    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.add((DoubleDiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DiagonalMatrix) {
            return this.addDiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.add((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                dArray[n][0] = abstractDoubleSquareMatrix.getElement(n, 0);
                for (int i = 1; i < this.numCols; ++i) {
                    dArray[n][i] = abstractDoubleSquareMatrix.getElement(n, i);
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + this.diag[n];
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                System.arraycopy(doubleSquareMatrix.matrix[n], 0, dArray[n], 0, this.numRows);
            }
            for (n = 0; n < this.numRows; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + this.diag[n];
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (this.numRows == doubleTridiagonalMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(this.numRows);
            System.arraycopy(doubleTridiagonalMatrix.ldiag, 0, doubleTridiagonalMatrix2.ldiag, 0, doubleTridiagonalMatrix.ldiag.length);
            System.arraycopy(doubleTridiagonalMatrix.udiag, 0, doubleTridiagonalMatrix2.udiag, 0, doubleTridiagonalMatrix.udiag.length);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] + doubleTridiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                doubleTridiagonalMatrix2.diag[i] = this.diag[i] + doubleTridiagonalMatrix.diag[i];
            }
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix addTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (n == abstractDoubleSquareMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] + abstractDoubleSquareMatrix.getElement(0, 0);
            doubleTridiagonalMatrix.udiag[0] = abstractDoubleSquareMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix.ldiag[i] = abstractDoubleSquareMatrix.getElement(i, i - 1);
                doubleTridiagonalMatrix.diag[i] = this.diag[i] + abstractDoubleSquareMatrix.getElement(i, i);
                doubleTridiagonalMatrix.udiag[i] = abstractDoubleSquareMatrix.getElement(i, i + 1);
            }
            doubleTridiagonalMatrix.ldiag[n] = abstractDoubleSquareMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix.diag[n] = this.diag[n] + abstractDoubleSquareMatrix.getElement(n, n);
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix add(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.numRows == doubleDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] + doubleDiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diag[i] + doubleDiagonalMatrix.diag[i];
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleDiagonalMatrix addDiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numRows == abstractDoubleSquareMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] + abstractDoubleSquareMatrix.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diag[i] + abstractDoubleSquareMatrix.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.subtract((DoubleDiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DiagonalMatrix) {
            return this.subtractDiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.subtract((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                dArray[n][0] = -abstractDoubleSquareMatrix.getElement(n, 0);
                for (int i = 1; i < this.numCols; ++i) {
                    dArray[n][i] = -abstractDoubleSquareMatrix.getElement(n, i);
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + this.diag[n];
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                dArray[n][0] = -doubleSquareMatrix.matrix[n][0];
                for (int i = 1; i < this.numCols; ++i) {
                    dArray[n][i] = -doubleSquareMatrix.matrix[n][i];
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + this.diag[n];
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] - doubleTridiagonalMatrix.diag[0];
            doubleTridiagonalMatrix2.udiag[0] = -doubleTridiagonalMatrix.udiag[0];
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix2.ldiag[i] = -doubleTridiagonalMatrix.ldiag[i];
                doubleTridiagonalMatrix2.diag[i] = this.diag[i] - doubleTridiagonalMatrix.diag[i];
                doubleTridiagonalMatrix2.udiag[i] = -doubleTridiagonalMatrix.udiag[i];
            }
            doubleTridiagonalMatrix2.ldiag[n] = -doubleTridiagonalMatrix.ldiag[n];
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] - doubleTridiagonalMatrix.diag[n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix subtractTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (n == abstractDoubleSquareMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] - abstractDoubleSquareMatrix.getElement(0, 0);
            doubleTridiagonalMatrix.udiag[0] = -abstractDoubleSquareMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix.ldiag[i] = -abstractDoubleSquareMatrix.getElement(i, i - 1);
                doubleTridiagonalMatrix.diag[i] = this.diag[i] - abstractDoubleSquareMatrix.getElement(i, i);
                doubleTridiagonalMatrix.udiag[i] = -abstractDoubleSquareMatrix.getElement(i, i + 1);
            }
            doubleTridiagonalMatrix.ldiag[n] = -abstractDoubleSquareMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix.diag[n] = this.diag[n] - abstractDoubleSquareMatrix.getElement(n, n);
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix subtract(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.numRows == doubleDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] - doubleDiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diag[i] - doubleDiagonalMatrix.diag[i];
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleDiagonalMatrix subtractDiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numRows == abstractDoubleSquareMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] - abstractDoubleSquareMatrix.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diag[i] - abstractDoubleSquareMatrix.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.numRows];
        dArray[0] = d * this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = d * this.diag[i];
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        double[] dArray = new double[this.numRows];
        dArray[0] = this.diag[0] / d;
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = this.diag[i] / d;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public double scalarProduct(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.scalarProduct((DoubleDiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.scalarProduct((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.scalarProduct((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double d = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                d += this.diag[i] * abstractDoubleSquareMatrix.getElement(i, i);
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double d = this.diag[0] * doubleSquareMatrix.matrix[0][0];
            for (int i = 1; i < this.numRows; ++i) {
                d += this.diag[i] * doubleSquareMatrix.matrix[i][i];
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (this.numRows == doubleTridiagonalMatrix.numRows) {
            double d = this.diag[0] * doubleTridiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                d += this.diag[i] * doubleTridiagonalMatrix.diag[i];
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.numRows == doubleDiagonalMatrix.numRows) {
            double d = this.diag[0] * doubleDiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                d += this.diag[i] * doubleDiagonalMatrix.diag[i];
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] * abstractDoubleVector.getComponent(0);
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diag[i] * abstractDoubleVector.getComponent(i);
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.multiply((DoubleDiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DiagonalMatrix) {
            return this.multiplyDiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.multiply((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            int n = abstractDoubleSquareMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < n; ++j) {
                    dArray[i][j] = this.diag[i] * abstractDoubleSquareMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleSquareMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.diag[0] * doubleSquareMatrix.matrix[i][0];
                for (int j = 1; j < doubleSquareMatrix.numCols; ++j) {
                    dArray[i][j] = this.diag[i] * doubleSquareMatrix.matrix[i][j];
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleTridiagonalMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == doubleTridiagonalMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] * doubleTridiagonalMatrix.diag[0];
            doubleTridiagonalMatrix2.udiag[0] = this.diag[0] * doubleTridiagonalMatrix.udiag[0];
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix2.ldiag[i] = this.diag[i] * doubleTridiagonalMatrix.ldiag[i];
                doubleTridiagonalMatrix2.diag[i] = this.diag[i] * doubleTridiagonalMatrix.diag[i];
                doubleTridiagonalMatrix2.udiag[i] = this.diag[i] * doubleTridiagonalMatrix.udiag[i];
            }
            doubleTridiagonalMatrix2.ldiag[n] = this.diag[n] * doubleTridiagonalMatrix.ldiag[n];
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] * doubleTridiagonalMatrix.diag[n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleTridiagonalMatrix multiplyTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 0);
            doubleTridiagonalMatrix.udiag[0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix.ldiag[i] = this.diag[i] * abstractDoubleSquareMatrix.getElement(i, i - 1);
                doubleTridiagonalMatrix.diag[i] = this.diag[i] * abstractDoubleSquareMatrix.getElement(i, i);
                doubleTridiagonalMatrix.udiag[i] = this.diag[i] * abstractDoubleSquareMatrix.getElement(i, i + 1);
            }
            doubleTridiagonalMatrix.ldiag[n] = this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix.diag[n] = this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n);
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleDiagonalMatrix multiply(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.numCols == doubleDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] * doubleDiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diag[i] * doubleDiagonalMatrix.diag[i];
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleDiagonalMatrix multiplyDiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            double[] dArray = new double[this.numRows];
            dArray[0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diag[i] * abstractDoubleSquareMatrix.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        return this;
    }

    public AbstractDoubleSquareMatrix inverse() {
        double[] dArray = new double[this.numRows];
        dArray[0] = 1.0 / this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = 1.0 / this.diag[i];
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        for (int i = 0; i < this.numRows; ++i) {
            nArray[i] = i;
        }
        nArray[this.numRows] = 1;
        this.LU = new AbstractDoubleSquareMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.numRows);
        this.LU[1] = this;
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractDoubleSquareMatrix[] luDecompose() {
        return this.luDecompose(null);
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[2];
        double[] dArray = new double[this.numRows];
        dArray[0] = Math.sqrt(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = Math.sqrt(this.diag[i]);
        }
        abstractDoubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        abstractDoubleSquareMatrixArray[1] = abstractDoubleSquareMatrixArray[0];
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] qrDecompose() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{DoubleDiagonalMatrix.identity(this.numRows), this};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int n = this.numRows;
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = -1.0;
            dArray2[i] = Math.abs(this.diag[i]);
            dArray3[i] = this.diag[i] < 0.0 ? 1.0 : -1.0;
        }
        dArray[n2] = 1.0;
        dArray2[n2] = Math.abs(this.diag[n2]);
        dArray3[n2] = this.diag[n2] < 0.0 ? -1.0 : 1.0;
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleDiagonalMatrix(dArray), new DoubleDiagonalMatrix(dArray2), new DoubleDiagonalMatrix(dArray3)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        double d = mapping.map(0.0);
        if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
            return this.diagonalMap(mapping);
        }
        return this.generalMap(mapping, d);
    }

    private AbstractDoubleMatrix diagonalMap(Mapping mapping) {
        double[] dArray = new double[this.numRows];
        dArray[0] = mapping.map(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = mapping.map(this.diag[i]);
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    private AbstractDoubleMatrix generalMap(Mapping mapping, double d) {
        int n;
        double[][] dArray = new double[this.numRows][this.numRows];
        for (n = 0; n < this.numRows; ++n) {
            for (int i = 0; i < this.numRows; ++i) {
                dArray[n][i] = d;
            }
        }
        dArray[0][0] = mapping.map(this.diag[0]);
        for (n = 1; n < this.numRows; ++n) {
            dArray[n][n] = mapping.map(this.diag[n]);
        }
        return new DoubleSquareMatrix(dArray);
    }
}

