/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.Complex;
import JSci.maths.chaos.MandelbrotMap;

public final class MandelbrotSet {
    private final MandelbrotMap mbrot = new MandelbrotMap(Complex.ZERO);

    public int isMember(Complex complex, int n) {
        this.mbrot.setConstant(complex);
        Complex complex2 = Complex.ZERO;
        for (int i = 0; i < n; ++i) {
            if (!((complex2 = this.mbrot.map(complex2)).mod() > 2.0)) continue;
            return i + 1;
        }
        return 0;
    }

    public int isMember(double d, double d2, int n) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = 2.0 * d3 * d4 + d2;
            if (!((d3 = d3 * d3 - d4 * d4 + d) * d3 + (d4 = d5) * d4 > 4.0)) continue;
            return i + 1;
        }
        return 0;
    }
}

