/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.analysis.RealFunction;

public class Power
extends RealFunction {
    private final double A;
    private final double n;
    private final double k;

    public Power() {
        this(1.0, 0.0, 1.0);
    }

    public Power(double d, double d2) {
        this(d, 0.0, d2);
    }

    public Power(double d, double d2, double d3) {
        this.A = d;
        this.k = d2;
        this.n = d3;
    }

    public double map(double d) {
        d += this.k;
        if (this.n != 1.0) {
            d = this.n == 2.0 ? (d *= d) : Math.pow(d, this.n);
        }
        return this.A * d;
    }

    public RealFunction differentiate() {
        return new Power(this.A * this.n, this.k, this.n - 1.0);
    }
}

