/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.splines;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.splines.Spline;

public class SumOfDiracs
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = -1;
    private double[] vecteur;

    public int getFilterType() {
        return -1;
    }

    public String toString() {
        return ArrayMath.toString((double[])this.vecteur);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SumOfDiracs && this.vecteur.length == ((SumOfDiracs)object).dimension()) {
            SumOfDiracs sumOfDiracs = (SumOfDiracs)object;
            for (int i = 0; i < this.vecteur.length; ++i) {
                if (this.vecteur[i] == sumOfDiracs.getValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        SumOfDiracs sumOfDiracs = (SumOfDiracs)super.clone();
        if (this.vecteur != null) {
            sumOfDiracs.vecteur = ArrayMath.copy((double[])this.vecteur);
        }
        return sumOfDiracs;
    }

    public int previousDimension(int n) {
        int n2 = (int)Math.round((double)(n + 1) / 2.0);
        if (2 * n2 - 1 == n) {
            return n2;
        }
        throw new IllegalArgumentException("Even number of values into an odd Filter! Change the number of data values/of iterations.");
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 2) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 2");
        }
        double[] dArray2 = Cascades.oversample(dArray);
        int n = dArray2.length - 1;
        double[] dArray3 = new double[2 * dArray.length - 1];
        double[] dArray4 = new double[]{0.0, 1.0, 0.0};
        double[] dArray5 = new double[]{1.0, 0.0};
        for (int i = 1; i <= n - 1; ++i) {
            dArray3[i] = ArrayMath.scalarProduct((double[])ArrayMath.extract((int)(i - 1), (int)(i + 1), (double[])dArray2), (double[])dArray4);
        }
        dArray3[0] = ArrayMath.scalarProduct((double[])ArrayMath.extract((int)0, (int)1, (double[])dArray2), (double[])dArray5);
        dArray3[n] = ArrayMath.scalarProduct((double[])ArrayMath.extract((int)n, (int)(n - 1), (double[])dArray2), (double[])dArray5);
        return dArray3;
    }

    public double[] highpass(double[] dArray) {
        return this.lowpass(dArray);
    }

    public SumOfDiracs(double[] dArray) {
        this.vecteur = dArray;
    }

    public SumOfDiracs() {
    }

    public double getValue(int n) {
        if (n < 0 || n > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + this.vecteur.length);
        }
        return this.vecteur[n];
    }

    public void setValues(double[] dArray) {
        this.vecteur = dArray;
    }

    public double mass(double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < this.vecteur.length; ++i) {
            d3 += this.vecteur[i];
        }
        d3 = d3 * Math.abs(d2 - d) / (double)this.vecteur.length;
        return d3;
    }

    public void setValue(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive : " + n);
        }
        this.vecteur[n] = d;
    }

    public int dimension() {
        return this.vecteur.length;
    }

    public int dimension(int n) {
        return Cascades.dimension(this.vecteur.length, n);
    }

    public double[] interpolate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + n);
        }
        return Cascades.evaluation(this, n, this.vecteur);
    }

    public double[] evaluate(int n) {
        return this.interpolate(n);
    }
}

