/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleSparseVector;
import JSci.maths.vectors.DoubleVector;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Cosine;
import JSci.maths.wavelet.DiscreteFunction;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.Sine;
import JSci.maths.wavelet.SparseDiscreteFunction;
import JSci.maths.wavelet.splines.LinearSpline;
import JSci.maths.wavelet.splines.PiecewiseConstant;
import JSci.maths.wavelet.splines.SumOfDiracs;

public final class DiscreteHilbertSpace {
    public static int maxiter = 20;

    private DiscreteHilbertSpace() {
    }

    public static double[] add(MultiscaleFunction multiscaleFunction, double d, MultiscaleFunction multiscaleFunction2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(multiscaleFunction, multiscaleFunction2, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double[] dArray = ArrayMath.scalarMultiply((double)Cascades.PowerOf2(n2 + n), (double[])multiscaleFunction.evaluate(n3 + n));
        double[] dArray2 = ArrayMath.scalarMultiply((double)Cascades.PowerOf2(n3 + n), (double[])multiscaleFunction2.evaluate(n2 + n));
        double[] dArray3 = ArrayMath.scalarMultiply((double)d, (double[])dArray2);
        return ArrayMath.add((double[])dArray, (double[])dArray3);
    }

    public static AbstractDoubleVector add(SparseDiscreteFunction sparseDiscreteFunction, double d, MultiscaleFunction multiscaleFunction, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(sparseDiscreteFunction, multiscaleFunction, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        AbstractDoubleVector abstractDoubleVector = sparseDiscreteFunction.data.scalarMultiply((double)Cascades.PowerOf2(n2 + n));
        double[] dArray = ArrayMath.scalarMultiply((double)Cascades.PowerOf2(n3 + n), (double[])multiscaleFunction.evaluate(n2 + n));
        double[] dArray2 = ArrayMath.scalarMultiply((double)d, (double[])dArray);
        return abstractDoubleVector.add((AbstractDoubleVector)new DoubleSparseVector(dArray2));
    }

    public static AbstractDoubleVector add(MultiscaleFunction multiscaleFunction, double d, SparseDiscreteFunction sparseDiscreteFunction, int n) {
        return DiscreteHilbertSpace.add(sparseDiscreteFunction, d, multiscaleFunction, n);
    }

    public static double[] add(DiscreteFunction discreteFunction, double d, DiscreteFunction discreteFunction2) {
        if (discreteFunction2 instanceof SparseDiscreteFunction && discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate((SparseDiscreteFunction)discreteFunction, (SparseDiscreteFunction)discreteFunction2);
        }
        if (discreteFunction2 instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate(discreteFunction, (SparseDiscreteFunction)discreteFunction2);
        }
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate((SparseDiscreteFunction)discreteFunction, discreteFunction2);
        }
        double[] dArray = discreteFunction.evaluate();
        double[] dArray2 = discreteFunction2.evaluate(0);
        double[] dArray3 = ArrayMath.scalarMultiply((double)d, (double[])dArray2);
        return ArrayMath.add((double[])dArray, (double[])dArray3);
    }

    public static AbstractDoubleVector add(SparseDiscreteFunction sparseDiscreteFunction, double d, SparseDiscreteFunction sparseDiscreteFunction2) {
        AbstractDoubleVector abstractDoubleVector = sparseDiscreteFunction2.data.scalarMultiply(d);
        return abstractDoubleVector.add(sparseDiscreteFunction.data);
    }

    public static AbstractDoubleVector add(DiscreteFunction discreteFunction, double d, SparseDiscreteFunction sparseDiscreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate((SparseDiscreteFunction)discreteFunction, sparseDiscreteFunction);
        }
        AbstractDoubleVector abstractDoubleVector = sparseDiscreteFunction.data.scalarMultiply(d);
        return abstractDoubleVector.add(discreteFunction.data);
    }

    public static AbstractDoubleVector add(SparseDiscreteFunction sparseDiscreteFunction, double d, DiscreteFunction discreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate(sparseDiscreteFunction, sparseDiscreteFunction);
        }
        return DiscreteHilbertSpace.add(discreteFunction, d, sparseDiscreteFunction);
    }

    public static double integrate(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2, int n, double d, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(multiscaleFunction, multiscaleFunction2, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double d3 = DiscreteHilbertSpace.integrate(multiscaleFunction, multiscaleFunction2, n, n2, n3);
        double d4 = d3 * Math.abs(d2 - d);
        return d4;
    }

    public static double integrate(DiscreteFunction discreteFunction, DiscreteFunction discreteFunction2) {
        if (discreteFunction instanceof SparseDiscreteFunction && discreteFunction2 instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate((SparseDiscreteFunction)discreteFunction, (SparseDiscreteFunction)discreteFunction2);
        }
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate((SparseDiscreteFunction)discreteFunction, discreteFunction2);
        }
        if (discreteFunction2 instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate(discreteFunction, (SparseDiscreteFunction)discreteFunction2);
        }
        return discreteFunction.data.scalarProduct(discreteFunction2.data);
    }

    public static double integrate(SparseDiscreteFunction sparseDiscreteFunction, DiscreteFunction discreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate(sparseDiscreteFunction, (SparseDiscreteFunction)discreteFunction);
        }
        return sparseDiscreteFunction.data.scalarProduct(discreteFunction.data);
    }

    public static double integrate(DiscreteFunction discreteFunction, SparseDiscreteFunction sparseDiscreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate((SparseDiscreteFunction)discreteFunction, sparseDiscreteFunction);
        }
        return sparseDiscreteFunction.data.scalarProduct(discreteFunction.data);
    }

    public static double integrate(SparseDiscreteFunction sparseDiscreteFunction, SparseDiscreteFunction sparseDiscreteFunction2) {
        return sparseDiscreteFunction2.data.scalarProduct(sparseDiscreteFunction.data);
    }

    public static double integrate(Cosine cosine, DiscreteFunction discreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate(cosine, (SparseDiscreteFunction)discreteFunction);
        }
        return ArrayMath.scalarProduct((double[])cosine.evaluate(), (double[])discreteFunction.evaluate());
    }

    public static double integrate(Sine sine, DiscreteFunction discreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate(sine, (SparseDiscreteFunction)discreteFunction);
        }
        return ArrayMath.scalarProduct((double[])sine.evaluate(), (double[])discreteFunction.evaluate());
    }

    public static double integrate(DiscreteFunction discreteFunction, Sine sine) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate((SparseDiscreteFunction)discreteFunction, sine);
        }
        return ArrayMath.scalarProduct((double[])discreteFunction.evaluate(), (double[])sine.evaluate());
    }

    public static double integrate(DiscreteFunction discreteFunction, Cosine cosine) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            DiscreteHilbertSpace.integrate((SparseDiscreteFunction)discreteFunction, cosine);
        }
        return ArrayMath.scalarProduct((double[])discreteFunction.evaluate(), (double[])cosine.evaluate());
    }

    public static double integrate(Cosine cosine, SparseDiscreteFunction sparseDiscreteFunction) {
        return sparseDiscreteFunction.data.scalarProduct((AbstractDoubleVector)new DoubleVector(cosine.evaluate()));
    }

    public static double integrate(Sine sine, SparseDiscreteFunction sparseDiscreteFunction) {
        return sparseDiscreteFunction.data.scalarProduct((AbstractDoubleVector)new DoubleVector(sine.evaluate()));
    }

    public static double integrate(SparseDiscreteFunction sparseDiscreteFunction, Sine sine) {
        return sparseDiscreteFunction.data.scalarProduct((AbstractDoubleVector)new DoubleVector(sine.evaluate()));
    }

    public static double integrate(SparseDiscreteFunction sparseDiscreteFunction, Cosine cosine) {
        return sparseDiscreteFunction.data.scalarProduct((AbstractDoubleVector)new DoubleVector(cosine.evaluate()));
    }

    public static double integrate(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(multiscaleFunction, multiscaleFunction2, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        return DiscreteHilbertSpace.integrate(multiscaleFunction, multiscaleFunction2, n, n2, n3);
    }

    private static double integrate(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2, int n, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        double d = ArrayMath.scalarProduct((double[])multiscaleFunction.evaluate(n3 + n), (double[])multiscaleFunction2.evaluate(n2 + n));
        int n4 = Cascades.PowerOf2(Math.min(n3, n2) + n);
        return d / (double)n4;
    }

    public static double integrate(PiecewiseConstant piecewiseConstant, MultiscaleFunction multiscaleFunction, int n, double d, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        LinearSpline linearSpline = new LinearSpline(new double[piecewiseConstant.dimension(0) + 1]);
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(linearSpline, multiscaleFunction, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double[] dArray = piecewiseConstant.evaluate(n2);
        double[] dArray2 = multiscaleFunction.evaluate(n3 + n);
        int n4 = (int)Math.round((double)(dArray2.length - 1) / (double)dArray.length);
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d4 = 0.0;
            for (int j = n4 * i; j <= n4 * (i + 1); ++j) {
                d4 += dArray2[j] / (double)(n4 + 1);
            }
            d3 += d4 * dArray[i];
        }
        double d5 = d3 * Math.abs(d2 - d);
        return d5;
    }

    public static double integrate(PiecewiseConstant piecewiseConstant, MultiscaleFunction multiscaleFunction, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        return DiscreteHilbertSpace.integrate(piecewiseConstant, multiscaleFunction, n, 0.0, 1.0);
    }

    public static double integrate(SumOfDiracs sumOfDiracs, MultiscaleFunction multiscaleFunction, int n, double d, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        return DiscreteHilbertSpace.integrate(sumOfDiracs, multiscaleFunction, n);
    }

    public static double integrate(SumOfDiracs sumOfDiracs, MultiscaleFunction multiscaleFunction, int n) {
        double[] dArray;
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(sumOfDiracs, multiscaleFunction, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double[] dArray2 = sumOfDiracs.evaluate(n3 + n);
        if (dArray2.length == (dArray = multiscaleFunction.evaluate(n2 + n)).length) {
            return ArrayMath.scalarProduct((double[])dArray2, (double[])dArray);
        }
        throw new IllegalArgumentException("This type of integration is not handled by this class. Please use 0 as the precision parameter: " + n + " != 0");
    }

    public static double integrate(SumOfDiracs sumOfDiracs, double[] dArray) {
        if (sumOfDiracs.dimension() != dArray.length) {
            throw new IllegalArgumentException("Can only integrate if the number of knots is the same: " + sumOfDiracs.dimension() + ", " + dArray.length);
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += sumOfDiracs.getValue(i) * dArray[i];
        }
        return d;
    }

    public static int[] getScalingCoefficients(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2, int n) {
        int[] nArray = new int[2];
        nArray[0] = 0;
        while (multiscaleFunction.dimension(n) > multiscaleFunction2.dimension(nArray[0] + n)) {
            if (multiscaleFunction.dimension(n) < multiscaleFunction2.dimension(nArray[0] + n) || nArray[0] > maxiter) {
                throw new IllegalArgumentException("The objects are incompatible and cannot be integrated according to this class (1) : " + multiscaleFunction.dimension(n) + ", " + multiscaleFunction2.dimension(n) + " : " + nArray[0] + "\nYou might have to write you own method.");
            }
            nArray[0] = nArray[0] + 1;
        }
        nArray[1] = 0;
        while (multiscaleFunction.dimension(nArray[1] + n) < multiscaleFunction2.dimension(n + nArray[0])) {
            if (multiscaleFunction.dimension(n + nArray[1]) > multiscaleFunction2.dimension(nArray[0] + n) || nArray[1] > maxiter) {
                throw new IllegalArgumentException("The objects are incompatible and cannot be integrated according to this class (2)  : " + multiscaleFunction.dimension(n) + ", " + multiscaleFunction2.dimension(n) + " : " + nArray[1] + "\nYou might have to write you own method.");
            }
            nArray[1] = nArray[1] + 1;
        }
        if (multiscaleFunction.dimension(nArray[1] + n) != multiscaleFunction2.dimension(nArray[0] + n)) {
            throw new IllegalArgumentException("The objects are incompatible and cannot be integrated according to this class (?) :" + multiscaleFunction.dimension(n) + ", " + multiscaleFunction2.dimension(n) + " : " + nArray[0] + " " + nArray[1] + "\nYou might have to write you own method.");
        }
        return nArray;
    }
}

