/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools.parser;

class PNode {
    public static final int NULL = -1;
    public static final int OP = 0;
    public static final int VALUE = 1;
    public static final int FUNCTION = 2;
    public static final int VAR = 3;
    public static final int PARAMETER = 4;
    PNode left;
    PNode right;
    double value;
    int op;
    int type;
    String svalue;

    public PNode() {
        this.type = -1;
        this.left = null;
        this.right = null;
        this.op = -1;
        this.value = 0.0;
        this.svalue = "";
    }

    public PNode(PNode pNode) {
        this.replace(pNode);
    }

    public void replace(PNode pNode) {
        if (pNode == null) {
            return;
        }
        this.op = pNode.op;
        this.type = pNode.type;
        this.left = pNode.left;
        this.right = pNode.right;
        this.value = pNode.value;
        this.svalue = new String(pNode.svalue);
    }

    public void indent(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print(" ");
            ++n2;
        }
    }

    public void print(int n) {
        char[] cArray = new char[1];
        this.indent(n);
        System.out.println("NODE type=" + this.type);
        this.indent(n);
        switch (this.type) {
            case 1: {
                System.out.println("     value=" + this.value);
                break;
            }
            case 2: {
                System.out.println("     svalue=" + this.svalue);
                break;
            }
            case 3: {
                System.out.println("     variable=" + this.svalue);
                break;
            }
            default: {
                System.out.println("     op=" + (char)this.op);
                if (this.left != null) {
                    this.left.print(n + 5);
                }
                if (this.right == null) break;
                this.right.print(n + 5);
            }
        }
    }
}

