/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Image;
import JSci.instruments.Overlay;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class PTTwoDBarycentreCross {
    public static double ALPHA = 0.3;
    public static int WEIGHT_LIGHT_PART = 50;
    public static double REGION_SPEED = 0.2;
    public static int ODD_EVEN = 1;
    private Rectangle region;
    private double x;
    private double y;
    private double x2;
    private double y2;
    private double ox;
    private double oy;
    private double cx;
    private double cy;
    private boolean firstTime = true;
    private static int currNum = 0;
    private int num;

    public PTTwoDBarycentreCross(Rectangle rectangle) {
        this.region = (Rectangle)rectangle.clone();
        this.cx = this.region.x;
        this.cy = this.region.y;
        this.num = currNum++;
    }

    private int fromImg(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    private void contiguous(Hashtable hashtable, Point point) {
        HashSet<Point> hashSet = new HashSet<Point>();
        HashSet<Point> hashSet2 = new HashSet<Point>();
        hashSet.add(point);
        while (!hashSet.isEmpty()) {
            point = (Point)hashSet.iterator().next();
            hashSet.remove(point);
            if (!hashtable.containsKey(point) || hashSet2.contains(point)) continue;
            hashSet2.add(point);
            hashSet.add(new Point(point.x + 1, point.y));
            hashSet.add(new Point(point.x - 1, point.y));
            hashSet.add(new Point(point.x, point.y + 1));
            hashSet.add(new Point(point.x, point.y - 1));
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            point = (Point)enumeration.nextElement();
            if (hashSet2.contains(point)) continue;
            hashtable.remove(point);
        }
    }

    private void PTTwoDBarycentreFindNative(byte[] byArray, int n, int n2, int n3, int n4, double d, int n5, double[] dArray) {
        double d2;
        double d3;
        double d4;
        double d5;
        int n6;
        Point point;
        Enumeration enumeration;
        long l;
        long l2;
        int n7;
        int n8;
        Hashtable<Point, Integer> hashtable = new Hashtable<Point, Integer>();
        Hashtable<Point, Integer> hashtable2 = new Hashtable<Point, Integer>();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = n8 = this.fromImg(byArray[n]);
        long l3 = 0L;
        int n14 = n4 - n2;
        int n15 = 0;
        int n16 = n;
        while (n15 < n3) {
            n7 = 0;
            while (n7 < n2) {
                if (this.fromImg(byArray[n16]) > n13) {
                    n13 = this.fromImg(byArray[n16]);
                    n12 = n7;
                    n10 = n15;
                }
                if (this.fromImg(byArray[n16]) < n8) {
                    n8 = this.fromImg(byArray[n16]);
                    n11 = n7;
                    n9 = n15;
                }
                l3 += (long)this.fromImg(byArray[n16]);
                ++n7;
                ++n16;
            }
            ++n15;
            n16 += n14;
        }
        int n17 = (int)((1.0 - d) * (double)(l3 /= (long)(n2 * n3)) + d * (double)n13);
        int n18 = (int)((1.0 - d) * (double)l3 + d * (double)n8);
        n15 = 0;
        n16 = n;
        while (n15 < n3) {
            n7 = 0;
            while (n7 < n2) {
                if (this.fromImg(byArray[n16]) > n17) {
                    hashtable2.put(new Point(n7, n15), new Integer(this.fromImg(byArray[n16])));
                }
                if (this.fromImg(byArray[n16]) < n18) {
                    hashtable.put(new Point(n7, n15), new Integer(this.fromImg(byArray[n16])));
                }
                ++n7;
                ++n16;
            }
            ++n15;
            n16 += n14;
        }
        this.contiguous(hashtable2, new Point(n12, n10));
        this.contiguous(hashtable, new Point(n11, n9));
        if (n5 != 0) {
            l3 = 0L;
            l2 = 0L;
            l = 0L;
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                point = (Point)enumeration.nextElement();
                n6 = (Integer)hashtable2.get(point);
                l += (long)((n6 - n17) * point.x);
                l2 += (long)((n6 - n17) * point.y);
                l3 += (long)(n6 - n17);
            }
            d5 = (double)l / (double)l3;
            d4 = (double)l2 / (double)l3;
        } else {
            d4 = 0.0;
            d5 = 0.0;
        }
        if (n5 != 100) {
            l3 = 0L;
            l2 = 0L;
            l = 0L;
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                point = (Point)enumeration.nextElement();
                n6 = (Integer)hashtable.get(point);
                l += (long)((n18 - n6) * point.x);
                l2 += (long)((n18 - n6) * point.y);
                l3 += (long)(n18 - n6);
            }
            d3 = (double)l / (double)l3;
            d2 = (double)l2 / (double)l3;
        } else {
            d2 = 0.0;
            d3 = 0.0;
        }
        dArray[0] = (d5 * (double)n5 + d3 * (double)(100 - n5)) / 100.0;
        dArray[1] = (d4 * (double)n5 + d2 * (double)(100 - n5)) / 100.0;
    }

    public void find(Image image) {
        double[] dArray = new double[2];
        this.PTTwoDBarycentreFindNative(image.getData(), this.region.x + this.region.y * image.getScansize() + image.getOffset(), this.region.width, this.region.height, image.getScansize(), ALPHA, WEIGHT_LIGHT_PART, dArray);
        double d = dArray[0];
        double d2 = dArray[1];
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return;
        }
        this.x = (double)this.region.x + d;
        this.y = (double)this.region.y + d2;
        if (this.firstTime) {
            this.ox = d;
            this.oy = d2;
            this.cx = this.region.x;
            this.cy = this.region.y;
            this.firstTime = false;
        }
        this.cx += (d - this.ox) * REGION_SPEED;
        this.cy += (d2 - this.oy) * REGION_SPEED;
        if (this.cx < 0.0) {
            this.cx = 0.0;
        }
        if (this.cx + (double)this.region.width >= (double)image.getWidth()) {
            this.cx = image.getWidth() - 1;
        }
        if (this.cy < 0.0) {
            this.cy = 0.0;
        }
        if (this.cy + (double)this.region.height >= (double)image.getHeight()) {
            this.cy = image.getHeight() - 1;
        }
        this.region.setLocation((int)this.cx, (int)this.cy);
        image.addOverlay(new Overlay(){

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.RED);
                graphics2D.draw(new Line2D.Double(PTTwoDBarycentreCross.this.x, PTTwoDBarycentreCross.this.y - 3.0, PTTwoDBarycentreCross.this.x, PTTwoDBarycentreCross.this.y + 3.0));
                graphics2D.draw(new Line2D.Double(PTTwoDBarycentreCross.this.x - 3.0, PTTwoDBarycentreCross.this.y, PTTwoDBarycentreCross.this.x + 3.0, PTTwoDBarycentreCross.this.y));
                graphics2D.setColor(Color.MAGENTA);
                graphics2D.draw(PTTwoDBarycentreCross.this.region);
                graphics2D.drawString(PTTwoDBarycentreCross.this.toString(), ((PTTwoDBarycentreCross)PTTwoDBarycentreCross.this).region.x, ((PTTwoDBarycentreCross)PTTwoDBarycentreCross.this).region.y + ((PTTwoDBarycentreCross)PTTwoDBarycentreCross.this).region.height + 12);
            }
        });
    }

    public void findInterlaced(Image image) {
        double[] dArray = new double[2];
        this.PTTwoDBarycentreFindNative(image.getData(), this.region.x + this.region.y * image.getScansize() + image.getOffset(), this.region.width, this.region.height / 2, image.getScansize() * 2, ALPHA, WEIGHT_LIGHT_PART, dArray);
        double d = dArray[0];
        double d2 = dArray[1] * 2.0;
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return;
        }
        this.x = (double)this.region.x + d;
        this.y = (double)this.region.y + d2;
        this.PTTwoDBarycentreFindNative(image.getData(), this.region.x + (this.region.y + 1) * image.getScansize() + image.getOffset(), this.region.width, this.region.height / 2, image.getScansize() * 2, ALPHA, WEIGHT_LIGHT_PART, dArray);
        double d3 = dArray[0];
        double d4 = dArray[1] * 2.0 + (double)ODD_EVEN;
        if (Double.isNaN(d3) || Double.isNaN(d4)) {
            return;
        }
        this.x2 = (double)this.region.x + d3;
        this.y2 = (double)this.region.y + d4;
        d = (d + d3) / 2.0;
        d2 = (d2 + d4) / 2.0;
        if (this.firstTime) {
            this.ox = d;
            this.oy = d2;
            this.cx = this.region.x;
            this.cy = this.region.y;
            this.firstTime = false;
        }
        this.cx += (d - this.ox) * REGION_SPEED;
        this.cy += (d2 - this.oy) * REGION_SPEED;
        if (this.cx < 0.0) {
            this.cx = 0.0;
        }
        if (this.cx + (double)this.region.width >= (double)image.getWidth()) {
            this.cx = image.getWidth() - 1;
        }
        if (this.cy < 0.0) {
            this.cy = 0.0;
        }
        if (this.cy + (double)this.region.height >= (double)image.getHeight()) {
            this.cy = image.getHeight() - 1;
        }
        this.region.setLocation((int)this.cx, (int)this.cy);
        image.addOverlay(new Overlay(){

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.RED);
                graphics2D.draw(new Line2D.Double(PTTwoDBarycentreCross.this.x, PTTwoDBarycentreCross.this.y - 3.0, PTTwoDBarycentreCross.this.x, PTTwoDBarycentreCross.this.y + 3.0));
                graphics2D.draw(new Line2D.Double(PTTwoDBarycentreCross.this.x - 3.0, PTTwoDBarycentreCross.this.y, PTTwoDBarycentreCross.this.x + 3.0, PTTwoDBarycentreCross.this.y));
                graphics2D.setColor(Color.MAGENTA);
                graphics2D.draw(PTTwoDBarycentreCross.this.region);
                graphics2D.drawString(PTTwoDBarycentreCross.this.toString(), ((PTTwoDBarycentreCross)PTTwoDBarycentreCross.this).region.x, ((PTTwoDBarycentreCross)PTTwoDBarycentreCross.this).region.y + ((PTTwoDBarycentreCross)PTTwoDBarycentreCross.this).region.height + 12);
            }
        });
    }

    public String toString() {
        return "" + this.num;
    }

    public int getN() {
        return this.num;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }
}

