/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpperTriangPackMatrix;

public class UnitUpperTriangPackMatrix
extends UpperTriangPackMatrix {
    public UnitUpperTriangPackMatrix(int n) {
        super(n, Diag.Unit);
    }

    public UnitUpperTriangPackMatrix(Matrix A) {
        this(A, true);
    }

    public UnitUpperTriangPackMatrix(Matrix A, boolean deep) {
        super(A, deep, Diag.Unit);
    }

    public void add(int row, int column, double value) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.add(row, column, value);
    }

    public double get(int row, int column) {
        if (row == column) {
            return 1.0;
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.set(row, column, value);
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() >= e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    public UnitUpperTriangPackMatrix copy() {
        return new UnitUpperTriangPackMatrix(this);
    }
}

