/*
 * Decompiled with CFR 0.152.
 */
package JSci.biology;

import JSci.biology.AminoAcid;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class AminoAcids {
    private static final Map table = new HashMap();
    private static Map symbols;
    static /* synthetic */ Class class$JSci$biology$AminoAcids;

    private AminoAcids() {
    }

    public static String getName(String string) {
        if (symbols == null) {
            symbols = AminoAcids.loadIndex();
        }
        return (String)symbols.get(string);
    }

    public static AminoAcid getAminoAcid(String string) {
        AminoAcid aminoAcid = (AminoAcid)((Object)table.get(string = string.toLowerCase()));
        if (aminoAcid == null && (aminoAcid = AminoAcids.loadAminoAcid("aminoacids/" + string.replace(' ', '-') + ".xml")) != null) {
            table.put(string, aminoAcid);
        }
        return aminoAcid;
    }

    private static Map loadIndex() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse((class$JSci$biology$AminoAcids == null ? (class$JSci$biology$AminoAcids = AminoAcids.class$("JSci.biology.AminoAcids")) : class$JSci$biology$AminoAcids).getResource("aminoacids/index.xml").toString());
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("amino-acid")) continue;
                NamedNodeMap namedNodeMap = node.getAttributes();
                hashMap.put(namedNodeMap.getNamedItem("symbol").getNodeValue(), namedNodeMap.getNamedItem("name").getNodeValue());
            }
            return hashMap;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return Collections.EMPTY_MAP;
        }
        catch (IOException iOException) {
            return Collections.EMPTY_MAP;
        }
        catch (SAXException sAXException) {
            return Collections.EMPTY_MAP;
        }
    }

    private static AminoAcid loadAminoAcid(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse((class$JSci$biology$AminoAcids == null ? (class$JSci$biology$AminoAcids = AminoAcids.class$("JSci.biology.AminoAcids")) : class$JSci$biology$AminoAcids).getResource(string).toString());
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            String string2 = AminoAcids.findStringValue(nodeList, "name");
            String string3 = AminoAcids.findStringValue(nodeList, "abbreviation");
            String string4 = AminoAcids.findStringValue(nodeList, "symbol");
            String string5 = AminoAcids.findStringValue(nodeList, "molecular-formula");
            AminoAcid aminoAcid = new AminoAcid(string2, string3, string4, string5);
            aminoAcid.setMolecularWeight(AminoAcids.findDoubleValue(nodeList, "molecular-weight"));
            aminoAcid.setIsoelectricPoint(AminoAcids.findDoubleValue(nodeList, "isoelectric-point"));
            aminoAcid.setCASRegistryNumber(AminoAcids.findStringValue(nodeList, "CAS-registry-number"));
            return aminoAcid;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    private static String findStringValue(NodeList nodeList, String string) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(string)) continue;
            return node.getFirstChild().getNodeValue();
        }
        return "";
    }

    private static double findDoubleValue(NodeList nodeList, String string) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(string)) continue;
            return Double.parseDouble(node.getFirstChild().getNodeValue());
        }
        return Double.NaN;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

