/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.IOException;
import java.io.Writer;
import nu.xom.UnavailableCharacterException;
import nu.xom.UnicodeUtil;
import nu.xom.XMLException;

abstract class TextWriter {
    protected final Writer out;
    protected final String encoding;
    private String lineSeparator = "\r\n";
    boolean lineSeparatorSet = false;
    private boolean inDocType = false;
    private int maxLength = 0;
    private int indent = 0;
    private String indentString = "";
    protected int column = 0;
    private boolean preserveSpace = false;
    protected boolean normalize = false;
    protected boolean lastCharacterWasSpace = false;
    protected boolean skipFollowingLinefeed = false;
    private char highSurrogate;
    protected boolean justBroke = false;
    private int fakeIndents = 0;
    private static final String _128_SPACES = "                                                                                                                                ";
    private static final int _128 = 128;

    protected TextWriter(Writer out, String encoding) {
        this.out = out;
        this.encoding = encoding;
    }

    void reset() {
        this.column = 0;
        this.fakeIndents = 0;
        this.lastCharacterWasSpace = false;
        this.skipFollowingLinefeed = false;
    }

    private boolean isHighSurrogate(int c) {
        return c >= 55296 && c <= 56319;
    }

    private boolean isLowSurrogate(int c) {
        return c >= 56320 && c <= 57343;
    }

    final void writePCDATA(char c) throws IOException {
        switch (c) {
            case '\r': {
                if (!this.adjustingWhiteSpace() && !this.lineSeparatorSet) {
                    this.out.write("&#x0D;");
                    this.column += 6;
                    this.justBroke = false;
                } else {
                    this.breakLine();
                    this.lastCharacterWasSpace = true;
                }
                this.skipFollowingLinefeed = true;
                break;
            }
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                throw new XMLException("Bad character snuck into document");
            }
            case ' ': {
                this.write(c);
                break;
            }
            case '!': {
                this.write(c);
                break;
            }
            case '\"': {
                this.write(c);
                break;
            }
            case '#': {
                this.write(c);
                break;
            }
            case '$': {
                this.write(c);
                break;
            }
            case '%': {
                this.write(c);
                break;
            }
            case '&': {
                this.out.write("&amp;");
                this.column += 5;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
                break;
            }
            case '\'': {
                this.write(c);
                break;
            }
            case '(': {
                this.write(c);
                break;
            }
            case ')': {
                this.write(c);
                break;
            }
            case '*': {
                this.write(c);
                break;
            }
            case '+': {
                this.write(c);
                break;
            }
            case ',': {
                this.write(c);
                break;
            }
            case '-': {
                this.write(c);
                break;
            }
            case '.': {
                this.write(c);
                break;
            }
            case '/': {
                this.write(c);
                break;
            }
            case '0': {
                this.write(c);
                break;
            }
            case '1': {
                this.write(c);
                break;
            }
            case '2': {
                this.write(c);
                break;
            }
            case '3': {
                this.write(c);
                break;
            }
            case '4': {
                this.write(c);
                break;
            }
            case '5': {
                this.write(c);
                break;
            }
            case '6': {
                this.write(c);
                break;
            }
            case '7': {
                this.write(c);
                break;
            }
            case '8': {
                this.write(c);
                break;
            }
            case '9': {
                this.write(c);
                break;
            }
            case ':': {
                this.write(c);
                break;
            }
            case ';': {
                this.write(c);
                break;
            }
            case '<': {
                this.out.write("&lt;");
                this.column += 4;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
                break;
            }
            case '=': {
                this.write(c);
                break;
            }
            case '>': {
                this.out.write("&gt;");
                this.column += 4;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
                break;
            }
            default: {
                if (this.needsEscaping(c)) {
                    this.writeEscapedChar(c);
                    break;
                }
                this.write(c);
            }
        }
    }

    private void writeEscapedChar(char c) throws IOException {
        if (this.isHighSurrogate(c)) {
            this.highSurrogate = c;
        } else if (this.isLowSurrogate(c)) {
            int uchar = UnicodeUtil.combineSurrogatePair(this.highSurrogate, c);
            String s = "&#x" + Integer.toHexString(uchar).toUpperCase() + ';';
            this.out.write(s);
            this.column += s.length();
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else {
            String s = "&#x" + Integer.toHexString(c).toUpperCase() + ';';
            this.out.write(s);
            this.column += s.length();
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        }
    }

    private boolean adjustingWhiteSpace() {
        return this.maxLength > 0 || this.indent > 0;
    }

    final void writeAttributeValue(char c) throws IOException {
        switch (c) {
            case '\t': {
                if (!this.adjustingWhiteSpace()) {
                    this.out.write("&#x09;");
                    this.column += 6;
                    this.lastCharacterWasSpace = true;
                    this.skipFollowingLinefeed = false;
                    this.justBroke = false;
                    break;
                }
                this.write(' ');
                break;
            }
            case '\n': {
                if (this.skipFollowingLinefeed) {
                    this.skipFollowingLinefeed = false;
                    return;
                }
                if (this.adjustingWhiteSpace()) {
                    this.out.write(" ");
                    this.lastCharacterWasSpace = true;
                    this.justBroke = false;
                    break;
                }
                if (this.lineSeparatorSet) {
                    this.escapeBreakLine();
                } else {
                    this.out.write("&#x0A;");
                    this.column += 6;
                    this.justBroke = false;
                }
                this.lastCharacterWasSpace = true;
                break;
            }
            case '\u000b': 
            case '\f': {
                throw new XMLException("Bad character snuck into document");
            }
            case '\r': {
                if (this.adjustingWhiteSpace()) {
                    this.out.write(" ");
                    this.lastCharacterWasSpace = true;
                    this.skipFollowingLinefeed = true;
                    this.justBroke = false;
                    break;
                }
                if (this.lineSeparatorSet) {
                    this.escapeBreakLine();
                    this.skipFollowingLinefeed = true;
                    break;
                }
                this.out.write("&#x0D;");
                this.column += 6;
                this.justBroke = false;
                break;
            }
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                throw new XMLException("Bad character snuck into document");
            }
            case ' ': {
                this.write(c);
                break;
            }
            case '!': {
                this.write(c);
                break;
            }
            case '\"': {
                this.out.write("&quot;");
                this.column += 6;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
                break;
            }
            case '#': {
                this.write(c);
                break;
            }
            case '$': {
                this.write(c);
                break;
            }
            case '%': {
                this.write(c);
                break;
            }
            case '&': {
                this.out.write("&amp;");
                this.column += 5;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
                break;
            }
            case '\'': {
                this.write(c);
                break;
            }
            case '(': {
                this.write(c);
                break;
            }
            case ')': {
                this.write(c);
                break;
            }
            case '*': {
                this.write(c);
                break;
            }
            case '+': {
                this.write(c);
                break;
            }
            case ',': {
                this.write(c);
                break;
            }
            case '-': {
                this.write(c);
                break;
            }
            case '.': {
                this.write(c);
                break;
            }
            case '/': {
                this.write(c);
                break;
            }
            case '0': {
                this.write(c);
                break;
            }
            case '1': {
                this.write(c);
                break;
            }
            case '2': {
                this.write(c);
                break;
            }
            case '3': {
                this.write(c);
                break;
            }
            case '4': {
                this.write(c);
                break;
            }
            case '5': {
                this.write(c);
                break;
            }
            case '6': {
                this.write(c);
                break;
            }
            case '7': {
                this.write(c);
                break;
            }
            case '8': {
                this.write(c);
                break;
            }
            case '9': {
                this.write(c);
                break;
            }
            case ':': {
                this.write(c);
                break;
            }
            case ';': {
                this.write(c);
                break;
            }
            case '<': {
                this.out.write("&lt;");
                this.column += 4;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
                break;
            }
            case '=': {
                this.write(c);
                break;
            }
            case '>': {
                this.out.write("&gt;");
                this.column += 4;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
                break;
            }
            default: {
                if (this.needsEscaping(c)) {
                    this.writeEscapedChar(c);
                    break;
                }
                this.write(c);
            }
        }
    }

    void write(char c) throws IOException {
        if (c == ' ' || c == '\n' || c == '\t') {
            if (this.needsBreak()) {
                this.breakLine();
                this.skipFollowingLinefeed = false;
            } else if (this.preserveSpace || this.indent <= 0 && this.maxLength <= 0) {
                if (c == ' ' || c == '\t') {
                    this.out.write(c);
                    this.skipFollowingLinefeed = false;
                    ++this.column;
                    this.justBroke = false;
                } else {
                    if (!this.lineSeparatorSet || !this.skipFollowingLinefeed) {
                        this.writeLineSeparator(c);
                    }
                    this.skipFollowingLinefeed = false;
                    this.column = 0;
                }
            } else if (!this.lastCharacterWasSpace) {
                this.out.write(32);
                ++this.column;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
            this.lastCharacterWasSpace = true;
        } else {
            this.out.write(c);
            if (c < '\ud800' || c > '\udbff') {
                ++this.column;
            }
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        }
    }

    private void writeLineSeparator(char c) throws IOException {
        if (!(this.inDocType || this.lineSeparatorSet && !this.preserveSpace)) {
            this.out.write(c);
        } else if (this.lineSeparator.equals("\r\n")) {
            this.out.write("\r\n");
        } else if (this.lineSeparator.equals("\n")) {
            this.out.write(10);
        } else {
            this.out.write(13);
        }
    }

    private boolean needsBreak() {
        if (this.maxLength <= 0 || this.preserveSpace) {
            return false;
        }
        return this.column >= this.maxLength - 10;
    }

    boolean justBroke() {
        return this.justBroke;
    }

    final void breakLine() throws IOException {
        this.out.write(this.lineSeparator);
        this.out.write(this.indentString);
        this.column = this.indentString.length();
        this.lastCharacterWasSpace = true;
        this.justBroke = true;
    }

    private final void escapeBreakLine() throws IOException {
        if ("\n".equals(this.lineSeparator)) {
            this.out.write("&#x0A;");
            this.column += 6;
        } else if ("\r\n".equals(this.lineSeparator)) {
            this.out.write("&#x0D;&#x0A;");
            this.column += 12;
        } else {
            this.out.write("&#x0D;");
            this.column += 6;
        }
        this.lastCharacterWasSpace = true;
    }

    final void writeMarkup(char c) throws IOException {
        if (this.needsEscaping(c)) {
            throw new UnavailableCharacterException(c, this.encoding);
        }
        this.write(c);
    }

    void writePCDATA(String s) throws IOException {
        s = this.normalize(s);
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.writePCDATA(s.charAt(i));
        }
    }

    void writeAttributeValue(String s) throws IOException {
        s = this.normalize(s);
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.writeAttributeValue(s.charAt(i));
        }
    }

    void writeMarkup(String s) throws IOException {
        s = this.normalize(s);
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.writeMarkup(s.charAt(i));
        }
    }

    void writeUncheckedMarkup(String s) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.write(s.charAt(i));
        }
    }

    protected String normalize(String s) {
        if (this.normalize) {
            return UnicodeUtil.normalize(s);
        }
        return s;
    }

    boolean isIndenting() {
        return this.indentString.length() > 0;
    }

    void incrementIndent() {
        String newIndent;
        if (this.indent == 0) {
            return;
        }
        int length = this.indentString.length() + this.indent;
        if (this.indentString.length() + this.indent < 128) {
            newIndent = _128_SPACES.substring(0, length);
        } else {
            StringBuffer sb = new StringBuffer(length);
            sb.append(_128_SPACES);
            for (int i = 128; i < length; ++i) {
                sb.append(' ');
            }
            newIndent = sb.toString();
        }
        if (this.maxLength > 0 && newIndent.length() > this.maxLength / 2) {
            ++this.fakeIndents;
        } else {
            this.indentString = newIndent;
        }
    }

    void decrementIndent() {
        if (this.indent == 0) {
            return;
        }
        if (this.fakeIndents > 0) {
            --this.fakeIndents;
        } else {
            this.indentString = this.indentString.substring(0, this.indentString.length() - this.indent);
        }
    }

    String getEncoding() {
        return this.encoding;
    }

    String getLineSeparator() {
        return this.lineSeparator;
    }

    void setLineSeparator(String lineSeparator) {
        if (!(lineSeparator.equals("\n") || lineSeparator.equals("\r") || lineSeparator.equals("\r\n"))) {
            throw new IllegalArgumentException("Illegal Line Separator");
        }
        this.lineSeparator = lineSeparator;
        this.lineSeparatorSet = true;
    }

    void setInDocType(boolean inDocType) {
        this.inDocType = inDocType;
    }

    int getIndent() {
        return this.indent;
    }

    int getMaxLength() {
        return this.maxLength;
    }

    void setMaxLength(int maxLength) {
        if (maxLength < 0) {
            maxLength = 0;
        }
        this.maxLength = maxLength;
    }

    void setIndent(int indent) {
        this.indent = indent;
    }

    void flush() throws IOException {
        this.out.flush();
    }

    abstract boolean needsEscaping(char var1);

    boolean isPreserveSpace() {
        return this.preserveSpace;
    }

    void setPreserveSpace(boolean preserveSpace) {
        this.preserveSpace = preserveSpace;
    }

    int getColumnNumber() {
        return this.column;
    }

    void setNFC(boolean normalize) {
        this.normalize = normalize;
    }

    boolean getNFC() {
        return this.normalize;
    }

    void writeName(String name) throws IOException {
        this.writeMarkup(name);
    }
}

