/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PlotApplet
extends JApplet {
    private transient PlotBox _plot;

    @Override
    public String getAppletInfo() {
        return "PlotApplet 5.7: A data plotter.\nBy: Edward A. Lee and\n Christopher Hylands\n($Id: PlotApplet.java,v 1.76 2005/07/30 05:30:56 cxh Exp $)";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"background", "hexcolor value", "background color"}, {"foreground", "hexcolor value", "foreground color"}, {"dataurl", "url", "the URL of the data to plot"}, {"height", "integer", "100"}, {"width", "integer", "100"}};
        return pinfo;
    }

    @Override
    public void init() {
        super.init();
        Runnable doActions = new Runnable(){

            @Override
            public void run() {
                if (PlotApplet.this._plot == null) {
                    PlotApplet.this._plot = PlotApplet.this.newPlot();
                }
                PlotApplet.this.getContentPane().add((Component)PlotApplet.this.plot(), "North");
                String widthspec = PlotApplet.this.getParameter("width");
                int width = widthspec != null ? Integer.parseInt(widthspec) : 400;
                String heightspec = PlotApplet.this.getParameter("height");
                int height = heightspec != null ? Integer.parseInt(heightspec) : 400;
                PlotApplet.this._setPlotSize(width, height);
                PlotApplet.this.plot().setButtons(true);
                Color background = Color.white;
                String colorspec = PlotApplet.this.getParameter("background");
                if (colorspec != null) {
                    background = PlotBox.getColorByName(colorspec);
                }
                PlotApplet.this.setBackground(background);
                PlotApplet.this.plot().setBackground(background);
                PlotApplet.this.getContentPane().setBackground(background);
                Color foreground = Color.black;
                colorspec = PlotApplet.this.getParameter("foreground");
                if (colorspec != null) {
                    foreground = PlotBox.getColorByName(colorspec);
                }
                PlotApplet.this.setForeground(foreground);
                PlotApplet.this.plot().setForeground(foreground);
                PlotApplet.this.plot().setVisible(true);
                String dataurlspec = PlotApplet.this.getParameter("dataurl");
                if (dataurlspec != null) {
                    try {
                        PlotApplet.this.showStatus("Reading data");
                        URL dataurl = new URL(PlotApplet.this.getDocumentBase(), dataurlspec);
                        InputStream in = dataurl.openStream();
                        PlotApplet.this._read(in);
                        PlotApplet.this.showStatus("Done");
                    }
                    catch (MalformedURLException e) {
                        System.err.println(e.toString());
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("PlotApplet: file not found: " + e);
                    }
                    catch (IOException e) {
                        System.err.println("PlotApplet: error reading input file: " + e);
                    }
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PlotBox newPlot() {
        return new Plot();
    }

    public PlotBox plot() {
        return this._plot;
    }

    public void setPlot(PlotBox plot) {
        this._plot = plot;
    }

    protected void _read(InputStream in) throws IOException {
        this.plot().read(in);
    }

    protected void _setPlotSize(int appletWidth, int appletHeight) {
        this.plot().setSize(appletWidth, appletHeight);
    }
}

