/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import java.util.HashMap;
import java.util.Map;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;

public class PortClassChanges
implements MoMLFilter {
    private static HashMap _actorsWithPortClassChanges = new HashMap();
    private HashMap _classMap;
    private boolean _currentlyProcessingActorWithPortClassChanges = false;
    private boolean _foundPort = false;
    private String _lastNameSeen;
    private HashMap _portMap;
    private String _portName;

    @Override
    public String filterAttributeValue(NamedObj container, String element, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeName.equals("name")) {
            this._lastNameSeen = attributeValue;
            if (this._currentlyProcessingActorWithPortClassChanges && this._portMap != null && this._portMap.containsKey(attributeValue)) {
                this._classMap = (HashMap)this._portMap.get(attributeValue);
                this._portName = attributeValue;
                this._foundPort = true;
            }
        }
        if (attributeName.equals("class")) {
            if (_actorsWithPortClassChanges.containsKey(attributeValue)) {
                this._currentlyProcessingActorWithPortClassChanges = true;
                this._portMap = (HashMap)_actorsWithPortClassChanges.get(attributeValue);
            } else if (this._foundPort && this._lastNameSeen.equals(this._portName) && this._classMap.containsKey(attributeValue)) {
                String newClass = (String)this._classMap.get(attributeValue);
                this._currentlyProcessingActorWithPortClassChanges = false;
                this._foundPort = false;
                MoMLParser.setModified(true);
                return newClass;
            }
        }
        return attributeValue;
    }

    @Override
    public void filterEndElement(NamedObj container, String elementName) throws Exception {
        this._foundPort = false;
    }

    @Override
    public String toString() {
        StringBuffer results = new StringBuffer(this.getClass().getName() + ": Update any actor port classes that have been\n" + "changed.\n" + "Below are the actors that are affected, along\n" + "with the old port class and the new port class:\n");
        for (String actor : _actorsWithPortClassChanges.keySet()) {
            results.append("\t" + actor + ".");
            HashMap portMap = (HashMap)_actorsWithPortClassChanges.get(actor);
            for (Map.Entry ports : portMap.entrySet()) {
                String port = (String)ports.getKey();
                results.append(port + "\n");
                HashMap classMap = (HashMap)ports.getValue();
                for (Map.Entry classChanges : classMap.entrySet()) {
                    String oldClass = (String)classChanges.getKey();
                    String newClass = (String)classChanges.getValue();
                    results.append("\t\t" + oldClass + "\t -> " + newClass + "\n");
                }
            }
        }
        return results.toString();
    }

    static {
        HashMap<String, String> variableDelayPorts = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> variableDelayPortChanges = new HashMap<String, HashMap<String, String>>();
        variableDelayPorts.put("ptolemy.domains.de.kernel.DEIOPort", "ptolemy.actor.parameters.ParameterPort");
        variableDelayPortChanges.put("delay", variableDelayPorts);
        _actorsWithPortClassChanges.put("ptolemy.domains.de.lib.VariableDelay", variableDelayPortChanges);
        HashMap<String, String> serverPorts = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> serverPortChanges = new HashMap<String, HashMap<String, String>>();
        serverPorts.put("ptolemy.domains.de.kernel.DEIOPort", "ptolemy.actor.parameters.ParameterPort");
        serverPortChanges.put("serviceTime", serverPorts);
        _actorsWithPortClassChanges.put("ptolemy.domains.de.lib.Server", serverPortChanges);
        HashMap<String, String> sdfPortChanges = new HashMap<String, String>();
        sdfPortChanges.put("ptolemy.domains.sdf.kernel.SDFIOPort", "ptolemy.actor.TypedIOPort");
        HashMap<String, HashMap<String, String>> inputOutputTypedIOPortClassChanges = new HashMap<String, HashMap<String, String>>();
        inputOutputTypedIOPortClassChanges.put("input", sdfPortChanges);
        inputOutputTypedIOPortClassChanges.put("output", sdfPortChanges);
        _actorsWithPortClassChanges.put("ptolemy.domains.sdf.lib.vq.ImagePartition", inputOutputTypedIOPortClassChanges);
        _actorsWithPortClassChanges.put("ptolemy.domains.sdf.lib.vq.ImageUnpartition", inputOutputTypedIOPortClassChanges);
        _actorsWithPortClassChanges.put("ptolemy.domains.sdf.lib.vq.HTVQEncode", inputOutputTypedIOPortClassChanges);
        _actorsWithPortClassChanges.put("ptolemy.domains.sdf.lib.vq.VQDecode", inputOutputTypedIOPortClassChanges);
    }
}

