/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import java.util.HashMap;
import java.util.Map;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;

public class ParameterNameChanges
implements MoMLFilter {
    private static HashMap _classesWithParameterNameChanges = new HashMap();
    private String _currentActorFullName;
    private boolean _currentlyProcessingActorWithParameterNameChanges = false;
    private String _lastNameSeen;
    private String _newName;
    private static HashMap _propertyMap;

    @Override
    public String filterAttributeValue(NamedObj container, String element, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeName.equals("name")) {
            this._lastNameSeen = attributeValue;
            if (this._currentlyProcessingActorWithParameterNameChanges) {
                if (_propertyMap.containsKey(attributeValue)) {
                    this._newName = (String)_propertyMap.get(attributeValue);
                    if (!attributeValue.equals(this._newName)) {
                        MoMLParser.setModified(true);
                    }
                    return this._newName;
                }
                return attributeValue;
            }
        }
        if (attributeName.equals("class")) {
            if (_classesWithParameterNameChanges.containsKey(attributeValue)) {
                this._currentlyProcessingActorWithParameterNameChanges = true;
                this._currentActorFullName = container.getFullName() + "." + this._lastNameSeen;
                _propertyMap = (HashMap)_classesWithParameterNameChanges.get(attributeValue);
            } else if (this._currentlyProcessingActorWithParameterNameChanges && this._newName != null) {
                this._newName = null;
            } else if (this._currentlyProcessingActorWithParameterNameChanges && container != null && !container.getFullName().equals(this._currentActorFullName) && !container.getFullName().startsWith(this._currentActorFullName)) {
                this._currentlyProcessingActorWithParameterNameChanges = false;
            }
        }
        return attributeValue;
    }

    @Override
    public void filterEndElement(NamedObj container, String elementName) throws Exception {
    }

    @Override
    public String toString() {
        StringBuffer results = new StringBuffer(this.getClass().getName() + ": Update any Parameter names\n" + "that have been renamed.\n" + "Below are the actors that are affected, along " + "with the Parameter name \nand the new name:\n");
        for (String actor : _classesWithParameterNameChanges.keySet()) {
            results.append("\t" + actor + "\n");
            HashMap propertyMap = (HashMap)_classesWithParameterNameChanges.get(actor);
            for (Map.Entry properties : propertyMap.entrySet()) {
                String oldProperty = (String)properties.getKey();
                String newProperty = (String)properties.getValue();
                results.append("\t\t" + oldProperty + "\t -> " + newProperty + "\n");
            }
        }
        return results.toString();
    }

    static {
        HashMap<String, String> pnDirectorChanges = new HashMap<String, String>();
        pnDirectorChanges.put("Initial_queue_capacity", "initialQueueCapacity");
        _classesWithParameterNameChanges.put("ptolemy.domains.pn.kernel.PNDirector", pnDirectorChanges);
        HashMap<String, String> variableDelayChanges = new HashMap<String, String>();
        variableDelayChanges.put("defaultDelay", "delay");
        _classesWithParameterNameChanges.put("ptolemy.domains.de.lib.VariableDelay", variableDelayChanges);
        HashMap<String, String> serverChanges = new HashMap<String, String>();
        serverChanges.put("newServiceTime", "serviceTime");
        _classesWithParameterNameChanges.put("ptolemy.domains.de.lib.Server", serverChanges);
    }
}

