/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ConfigurableAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.SingletonAttribute;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.ParserAttribute;

public class LibraryAttribute
extends ConfigurableAttribute {
    private CompositeEntity _library;
    private boolean _librarySet = false;

    public LibraryAttribute() {
    }

    public LibraryAttribute(Workspace workspace) {
        super(workspace);
    }

    public LibraryAttribute(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
    }

    public CompositeEntity getLibrary() throws Exception {
        if (this._librarySet) {
            return this._library;
        }
        MoMLParser parser = ParserAttribute.getParser(this);
        parser.reset();
        NamedObj library = parser.parse(this.value());
        if (!(library instanceof CompositeEntity)) {
            throw new IllegalActionException((Nameable)this, "Expected library to be in an instance of CompositeEntity, but it is: " + library.getClass().getName());
        }
        Attribute marker = library.getAttribute("_libraryMarker");
        if (marker == null) {
            new SingletonAttribute(library, "_libraryMarker");
        }
        return (CompositeEntity)library;
    }

    public void setLibrary(CompositeEntity library) {
        Attribute marker;
        this._library = library;
        this._librarySet = true;
        if (this._library != null && (marker = this._library.getAttribute("_libraryMarker")) == null) {
            try {
                new SingletonAttribute(this._library, "_libraryMarker");
            }
            catch (KernelException ex) {
                throw new InternalErrorException("Can't add library marker: " + ex);
            }
        }
    }
}

