/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.media.javasound;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class SoundWriter {
    private File outFile;
    private String _fileName;
    private int _bitsPerSample;
    private float _sampleRate;
    private int _channels;
    private byte[] _data;
    private int _frameSizeInBytes;
    private ArrayList _toFileBuffer;
    private AudioFormat _playToFileFormat;
    private int _bytesPerSample;
    private boolean _isAudioWriterActive = false;
    private boolean _debug = false;

    public SoundWriter(String fileName, float sampleRate, int bitsPerSample, int channels, int putSamplesArraySize) {
        this._fileName = fileName;
        this._bitsPerSample = bitsPerSample;
        this._sampleRate = sampleRate;
        this._channels = channels;
        this._initializeAudio();
        this._isAudioWriterActive = true;
        if (this._debug) {
            System.out.println("SoundWriter: constructor : fileName = " + fileName);
            System.out.println("SoundWriter: constructor : bitsPerSample = " + bitsPerSample);
            System.out.println("SoundWriter: constructor : sampleRate = " + sampleRate);
            System.out.println("SoundWriter: constructor : channels = " + channels);
            System.out.println("SoundWriter: constructor : putSamplesArraySize = " + putSamplesArraySize);
        }
    }

    public void putSamples(double[][] putSamplesArray) throws IllegalStateException {
        if (this._isAudioWriterActive) {
            this._data = this._doubleArrayToByteArray(putSamplesArray, this._bytesPerSample, this._channels);
            for (int i = 0; i < this._data.length; ++i) {
                this._toFileBuffer.add(this._data[i]);
            }
        } else {
            throw new IllegalStateException("SoundWriter: putSamples() was called while audio playback was inactive (startPlayback() was never called or stopPlayback has already been called).");
        }
    }

    public void closeFile() throws IOException {
        if (this._debug) {
            System.out.println("SoundWriter: stopPlayback(): invoked");
        }
        if (this._isAudioWriterActive) {
            this._stopPlaybackToFile();
        }
        this._isAudioWriterActive = false;
    }

    private void _initializeAudio() {
        this._toFileBuffer = new ArrayList();
        boolean signed = true;
        boolean bigEndian = true;
        this._playToFileFormat = new AudioFormat(this._sampleRate, this._bitsPerSample, this._channels, signed, bigEndian);
        this._frameSizeInBytes = this._playToFileFormat.getFrameSize();
        this._bytesPerSample = this._bitsPerSample / 8;
    }

    private void _stopPlaybackToFile() throws IOException {
        block9: {
            int size = this._toFileBuffer.size();
            byte[] audioBytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                Byte j = (Byte)this._toFileBuffer.get(i);
                audioBytes[i] = j;
            }
            ByteArrayInputStream byteInputArrayStream = new ByteArrayInputStream(audioBytes);
            AudioInputStream audioInputStream = new AudioInputStream(byteInputArrayStream, this._playToFileFormat, audioBytes.length / this._frameSizeInBytes);
            this.outFile = new File(this._fileName);
            try {
                StringTokenizer st = new StringTokenizer(this._fileName, ".");
                if (st.countTokens() != 2) {
                    throw new IOException("Error: Incorrect file name format. Format: filename.extension");
                }
                st.nextToken();
                String fileExtension = st.nextToken();
                if (fileExtension.equalsIgnoreCase("au")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.AU, this.outFile);
                    break block9;
                }
                if (fileExtension.equalsIgnoreCase("aiff")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.AIFF, this.outFile);
                    break block9;
                }
                if (fileExtension.equalsIgnoreCase("wave")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, this.outFile);
                    break block9;
                }
                if (fileExtension.equalsIgnoreCase("wav")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, this.outFile);
                    break block9;
                }
                if (fileExtension.equalsIgnoreCase("aifc")) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.AIFC, this.outFile);
                    break block9;
                }
                throw new IOException("Error saving file: Unknown file format: " + fileExtension);
            }
            catch (IOException e) {
                throw new IOException("SoundWriter: error saving file: " + e);
            }
        }
    }

    private byte[] _doubleArrayToByteArray(double[][] doubleArray, int bytesPerSample, int channels) {
        int lengthInSamples = doubleArray[0].length;
        double maxSample = bytesPerSample == 2 ? 32768.0 : (bytesPerSample == 1 ? 128.0 : (bytesPerSample == 3 ? 8388608.0 : (bytesPerSample == 4 ? 1.47483648E17 : 0.0)));
        double maxDoubleValuedSample = (maxSample - 2.0) / maxSample;
        byte[] byteArray = new byte[lengthInSamples * bytesPerSample * channels];
        byte[] b = new byte[bytesPerSample];
        for (int currSamp = 0; currSamp < lengthInSamples; ++currSamp) {
            for (int currChannel = 0; currChannel < channels; ++currChannel) {
                int l = doubleArray[currChannel][currSamp] >= maxDoubleValuedSample ? (int)maxSample - 2 : (doubleArray[currChannel][currSamp] <= -maxDoubleValuedSample ? (int)(-maxSample) + 2 : (int)(doubleArray[currChannel][currSamp] * maxSample));
                int i = 0;
                while (i < bytesPerSample) {
                    b[bytesPerSample - i - 1] = (byte)l;
                    ++i;
                    l >>= 8;
                }
                for (i = 0; i < bytesPerSample; ++i) {
                    byteArray[currSamp * bytesPerSample * channels + bytesPerSample * currChannel + i] = b[i];
                }
            }
        }
        return byteArray;
    }
}

