/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.media.javasound;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundCapture {
    private AudioInputStream _properFormatAudioInputStream;
    private AudioInputStream _audioInputStream;
    private int _productionRate;
    private double[][] _audioInDoubleArray;
    private int[][] _audioInIntArray;
    private byte[] _data;
    private int _frameSizeInBytes;
    private boolean _isRealTime;
    private String _pathName;
    private int _sampleSizeInBits;
    private float _sampleRate;
    private int _channels;
    private int _bufferSize;
    private TargetDataLine _targetLine;
    private int _bytesPerSample;
    private boolean _isAudioCaptureActive = false;
    private byte[] _b = new byte[1];
    private double[][] _doubleArray = new double[1][1];
    private int[][] _intArray = new int[1][1];

    public SoundCapture(float sampleRate, int sampleSizeInBits, int channels, int bufferSize, int getSamplesSize) {
        this._isRealTime = true;
        this._sampleSizeInBits = sampleSizeInBits;
        this._sampleRate = sampleRate;
        this._channels = channels;
        this._bufferSize = bufferSize;
        this._productionRate = getSamplesSize;
    }

    public SoundCapture(String pathName, int getSamplesSize) {
        this._isRealTime = false;
        this._pathName = pathName;
        this._productionRate = getSamplesSize;
    }

    public int getChannels() throws IllegalStateException {
        if (this._isAudioCaptureActive) {
            return this._channels;
        }
        throw new IllegalStateException("SoundCapture: getChannels() was called while audio capture was inactive (startCapture() was never called).");
    }

    public float getSampleRate() throws IllegalStateException {
        if (this._isAudioCaptureActive) {
            return this._sampleRate;
        }
        throw new IllegalStateException("SoundCapture: getSampleRate() was called while audio capture was inactive (startCapture() was never called).");
    }

    public double[][] getSamples() throws IOException, IllegalStateException {
        if (this._isAudioCaptureActive) {
            int numBytesRead = this._isRealTime ? this._targetLine.read(this._data, 0, this._productionRate * this._frameSizeInBytes) : this._properFormatAudioInputStream.read(this._data);
            if (numBytesRead == this._data.length) {
                this._audioInDoubleArray = this._byteArrayToDoubleArray(this._data, this._bytesPerSample, this._channels);
                return this._audioInDoubleArray;
            }
            if (numBytesRead != this._data.length) {
                this._audioInDoubleArray = this._byteArrayToDoubleArray(this._data, this._bytesPerSample, this._channels);
                return this._audioInDoubleArray;
            }
            if (numBytesRead == -1) {
                return null;
            }
            return null;
        }
        throw new IllegalStateException("SoundCapture: getSamples() was called while audio capture was inactive (startCapture() was never called or stopCapture has already been called).");
    }

    public int[][] getSamplesInt() throws IOException, IllegalStateException {
        if (this._isAudioCaptureActive) {
            int numBytesRead = this._isRealTime ? this._targetLine.read(this._data, 0, this._productionRate * this._frameSizeInBytes) : this._properFormatAudioInputStream.read(this._data);
            if (numBytesRead == this._data.length) {
                this._audioInIntArray = this._byteArrayToIntArray(this._data, this._bytesPerSample, this._channels);
                return this._audioInIntArray;
            }
            if (numBytesRead != this._data.length) {
                return null;
            }
            if (numBytesRead == -1) {
                return null;
            }
            return null;
        }
        throw new IllegalStateException("SoundCapture: getSamples() was called while audio capture was inactive (startCapture() was never called or stopCapture has already been called).");
    }

    public void startCapture() throws IOException, IllegalStateException {
        if (!this._isAudioCaptureActive) {
            if (this._isRealTime) {
                this._startCaptureRealTime();
            } else {
                this._startCaptureFromFile();
            }
        } else {
            throw new IllegalStateException("SoundCapture: startCapture() was called while audio capture was already active (startCapture() was called more than once between invocations of stopCapture()).");
        }
        this._isAudioCaptureActive = true;
    }

    public void stopCapture() throws IOException {
        if (this._isAudioCaptureActive) {
            if (this._audioInputStream != null) {
                this._audioInputStream.close();
                this._audioInputStream = null;
            }
            if (this._properFormatAudioInputStream != null) {
                this._properFormatAudioInputStream.close();
                this._properFormatAudioInputStream = null;
            }
            if (this._targetLine != null && this._targetLine.isOpen()) {
                this._targetLine.stop();
                this._targetLine.close();
                this._targetLine = null;
            }
        }
        this._isAudioCaptureActive = false;
    }

    public int getSampleSizeInBits() throws IllegalStateException {
        if (this._isAudioCaptureActive) {
            return this._sampleSizeInBits;
        }
        throw new IllegalStateException("SoundCapture: getSampleSizeInBits() was called while audio capture was inactive (startCapture() was never called).");
    }

    private void _startCaptureRealTime() throws IOException {
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(this._sampleRate, this._sampleSizeInBits, this._channels, signed, bigEndian);
        this._frameSizeInBytes = format.getFrameSize();
        DataLine.Info targetInfo = new DataLine.Info(TargetDataLine.class, format, -1);
        try {
            this._targetLine = (TargetDataLine)AudioSystem.getLine(targetInfo);
            this._targetLine.open(format, this._bufferSize * this._frameSizeInBytes);
        }
        catch (LineUnavailableException ex) {
            throw new IOException("Unable to open the line for real-time audio capture: " + ex);
        }
        this._data = new byte[this._productionRate * this._frameSizeInBytes];
        this._bytesPerSample = this._sampleSizeInBits / 8;
        this._targetLine.start();
    }

    private void _startCaptureFromFile() throws IOException {
        URL soundURL = new URL(this._pathName);
        if (soundURL != null) {
            try {
                this._audioInputStream = AudioSystem.getAudioInputStream(soundURL);
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException("Unsupported AudioFile :" + e);
            }
        }
        if (this._audioInputStream == null) {
            throw new IOException("No loaded audio to play back");
        }
        AudioFormat origFormat = this._audioInputStream.getFormat();
        float sampleRate = origFormat.getSampleRate();
        this._sampleSizeInBits = origFormat.getSampleSizeInBits();
        this._bytesPerSample = this._sampleSizeInBits / 8;
        this._channels = origFormat.getChannels();
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(sampleRate, this._sampleSizeInBits, this._channels, signed, bigEndian);
        this._properFormatAudioInputStream = AudioSystem.getAudioInputStream(format, this._audioInputStream);
        this._frameSizeInBytes = format.getFrameSize();
        this._data = new byte[this._productionRate * this._frameSizeInBytes];
    }

    private double[][] _byteArrayToDoubleArray(byte[] byteArray, int bytesPerSample, int channels) {
        int lengthInSamples = byteArray.length / (bytesPerSample * channels);
        if (channels != this._doubleArray.length || lengthInSamples != this._doubleArray[0].length) {
            this._doubleArray = new double[channels][lengthInSamples];
        }
        double maxSampleReciprocal = bytesPerSample == 2 ? 3.0517578125E-5 : (bytesPerSample == 1 ? 0.0078125 : (bytesPerSample == 3 ? 1.1920928955E7 : (bytesPerSample == 4 ? 4.655661287308E-10 : 0.0)));
        if (bytesPerSample != this._b.length) {
            this._b = new byte[bytesPerSample];
        }
        for (int currSamp = 0; currSamp < lengthInSamples; ++currSamp) {
            for (int currChannel = 0; currChannel < channels; ++currChannel) {
                for (int i = 0; i < bytesPerSample; ++i) {
                    this._b[i] = byteArray[currSamp * bytesPerSample * channels + bytesPerSample * currChannel + i];
                }
                int result = this._b[0] >> 7;
                for (int i = 0; i < bytesPerSample; ++i) {
                    result = (result << 8) + (this._b[i] & 0xFF);
                }
                this._doubleArray[currChannel][currSamp] = (double)result * maxSampleReciprocal;
            }
        }
        return this._doubleArray;
    }

    private int[][] _byteArrayToIntArray(byte[] byteArray, int bytesPerSample, int channels) {
        int lengthInSamples = byteArray.length / (bytesPerSample * channels);
        if (channels != this._doubleArray.length || lengthInSamples != this._doubleArray[0].length) {
            this._intArray = new int[channels][lengthInSamples];
        }
        if (bytesPerSample != this._b.length) {
            this._b = new byte[bytesPerSample];
        }
        for (int currSamp = 0; currSamp < lengthInSamples; ++currSamp) {
            for (int currChannel = 0; currChannel < channels; ++currChannel) {
                for (int i = 0; i < bytesPerSample; ++i) {
                    this._b[i] = byteArray[currSamp * bytesPerSample * channels + bytesPerSample * currChannel + i];
                }
                int result = this._b[0] >> 7;
                for (int i = 0; i < bytesPerSample; ++i) {
                    result = (result << 8) + (this._b[i] & 0xFF);
                }
                this._intArray[currChannel][currSamp] = result;
            }
        }
        return this._intArray;
    }
}

