/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.util.Random;
import ptolemy.math.DoubleArrayMath;
import ptolemy.math.ExtendedMath;

public class DoubleArrayStat
extends DoubleArrayMath {
    private static Random _random;

    protected DoubleArrayStat() {
    }

    public static final double[] autoCorrelation(double[] x, int N, int startLag, int endLag) {
        int outputLength = endLag - startLag + 1;
        double[] returnValue = new double[outputLength];
        for (int lag = startLag; lag <= endLag; ++lag) {
            int start = Math.max(0, -lag);
            int limit = Math.min(x.length, N);
            limit = Math.min(limit, x.length - lag);
            double sum = 0.0;
            for (int i = start; i < limit; ++i) {
                sum += x[i] * x[i + lag];
            }
            returnValue[lag - startLag] = sum;
        }
        return returnValue;
    }

    public static double autoCorrelationAt(double[] x, int N, int lag) {
        int start = Math.max(0, -lag);
        int limit = Math.min(x.length, N);
        limit = Math.min(limit, x.length - lag);
        double sum = 0.0;
        for (int i = start; i < limit; ++i) {
            sum += x[i] * x[i + lag];
        }
        return sum;
    }

    public static final double[] crossCorrelation(double[] x, double[] y, int N, int startLag, int endLag) {
        int outputLength = endLag - startLag + 1;
        double[] returnValue = new double[outputLength];
        for (int lag = startLag; lag <= endLag; ++lag) {
            int start = Math.max(0, -lag);
            int limit = Math.min(x.length, N);
            limit = Math.min(limit, y.length - lag);
            double sum = 0.0;
            for (int i = start; i < limit; ++i) {
                sum += x[i] * y[i + lag];
            }
            returnValue[lag - startLag] = sum;
        }
        return returnValue;
    }

    public static double crossCorrelationAt(double[] x, double[] y, int N, int lag) {
        int start = Math.max(0, -lag);
        int limit = Math.min(x.length, N);
        limit = Math.min(limit, y.length - lag);
        double sum = 0.0;
        for (int i = start; i < limit; ++i) {
            sum += x[i] * y[i + lag];
        }
        return sum;
    }

    public static final double entropy(double[] p) {
        int length = DoubleArrayStat._nonZeroLength(p, "DoubleArrayStat.entropy");
        double h = 0.0;
        for (int i = 0; i < length; ++i) {
            if (p[i] < 0.0) {
                throw new IllegalArgumentException("ptolemy.math.DoubleArrayStat.entropy() : Negative probability encountered.");
            }
            if (p[i] == 0.0) continue;
            h -= p[i] * ExtendedMath.log2(p[i]);
        }
        return h;
    }

    public static final double geometricMean(double[] array) {
        if (array.length < 1) {
            return 1.0;
        }
        return Math.pow(DoubleArrayStat.productOfElements(array), 1.0 / (double)array.length);
    }

    public static final double max(double[] array) {
        Object[] maxReturn = DoubleArrayStat.maxAndIndex(array);
        return (Double)maxReturn[0];
    }

    public static final Object[] maxAndIndex(double[] array) {
        int length = DoubleArrayStat._nonZeroLength(array, "DoubleArrayStat.maxAndIndex");
        int maxIndex = 0;
        double maxElement = array[0];
        for (int i = 1; i < length; ++i) {
            if (!(array[i] > maxElement)) continue;
            maxElement = array[i];
            maxIndex = i;
        }
        return new Object[]{maxElement, maxIndex};
    }

    public static final double mean(double[] array) {
        DoubleArrayStat._nonZeroLength(array, "DoubleArrayStat.mean");
        return DoubleArrayStat.sumOfElements(array) / (double)array.length;
    }

    public static final double min(double[] array) {
        Object[] minReturn = DoubleArrayStat.minAndIndex(array);
        return (Double)minReturn[0];
    }

    public static final Object[] minAndIndex(double[] array) {
        int length = DoubleArrayStat._nonZeroLength(array, "DoubleArrayStat.minAndIndex");
        int minIndex = 0;
        double minElement = array[0];
        for (int i = 1; i < length; ++i) {
            if (!(array[i] < minElement)) continue;
            minElement = array[i];
            minIndex = i;
        }
        return new Object[]{minElement, minIndex};
    }

    public static final double productOfElements(double[] array) {
        double product = 1.0;
        for (int i = 0; i < array.length; ++i) {
            product *= array[i];
        }
        return product;
    }

    public static final double[] randomBernoulli(double p, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            returnValue[i] = _random.nextDouble() < p ? 1.0 : 0.0;
        }
        return returnValue;
    }

    public static final double[] randomExponential(double lambda, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            double r;
            while ((r = _random.nextDouble()) == 0.0) {
            }
            returnValue[i] = -Math.log(r) / lambda;
        }
        return returnValue;
    }

    public static final double[] randomGaussian(double mean, double standardDeviation, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            returnValue[i] = mean + _random.nextGaussian() * standardDeviation;
        }
        return returnValue;
    }

    public static final double[] randomPoisson(double mean, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            double p;
            double j = 0.0;
            double f = p = Math.exp(-mean);
            double u = _random.nextDouble();
            while (f <= u) {
                f += (p *= mean / (j + 1.0));
                j += 1.0;
            }
            returnValue[i] = j;
        }
        return returnValue;
    }

    public static double[] randomUniform(double a, double b, int N) {
        double range = b - a;
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        for (int i = 0; i < N; ++i) {
            returnValue[i] = _random.nextDouble() * range + a;
        }
        return returnValue;
    }

    public static final double relativeEntropy(double[] p, double[] q) {
        DoubleArrayStat._nonZeroLength(p, "DoubleArrayStat.relativeEntropy");
        int length = DoubleArrayStat._commonLength(p, q, "DoubleArrayStat.relativeEntropy");
        double d = 0.0;
        for (int i = 0; i < length; ++i) {
            if (p[i] < 0.0 || q[i] < 0.0) {
                throw new IllegalArgumentException("ptolemy.math.DoubleArrayStat.relativeEntropy() : Negative probability encountered.");
            }
            if (p[i] == 0.0) continue;
            if (q[i] == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            d += p[i] * ExtendedMath.log2(p[i] / q[i]);
        }
        return d;
    }

    public static double standardDeviation(double[] array) {
        return Math.sqrt(DoubleArrayStat.variance(array, false));
    }

    public static double standardDeviation(double[] array, boolean sample) {
        return Math.sqrt(DoubleArrayStat.variance(array, sample));
    }

    public static final double sumOfElements(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static double variance(double[] array) {
        return DoubleArrayStat.variance(array, false);
    }

    public static double variance(double[] array, boolean sample) {
        int length = DoubleArrayStat._nonZeroLength(array, "DoubleArrayStat.variance");
        if (sample && array.length < 2) {
            throw new IllegalArgumentException("ptolemy.math.DoubleArrayStat.variance() : sample variance and standard deviation of an array of length less than 2 are not defined.");
        }
        double ex2 = 0.0;
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            ex2 += array[i] * array[i];
            sum += array[i];
        }
        double norm = sample ? (double)(length - 1) : (double)length;
        double sumSquaredOverLength = sum * sum / (double)length;
        return (ex2 - sumSquaredOverLength) / norm;
    }

    protected static final int _nonZeroLength(double[] array, String methodName) {
        if (array == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input array is null.");
        }
        if (array.length <= 0) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input array has length 0.");
        }
        return array.length;
    }
}

