/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.gui.Query;
import ptolemy.gui.StatusBar;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public abstract class Top
extends JFrame {
    protected static final int _SAVED = 0;
    protected static final int _DISCARDED = 1;
    protected static final int _CANCELED = 2;
    protected static final int _FAILED = 3;
    protected static File _directory = null;
    protected FileFilter _fileFilter = null;
    protected JMenu _fileMenu = new JMenu("File");
    protected JMenuItem[] _fileMenuItems = new JMenuItem[]{new JMenuItem("Open File", 79), new JMenuItem("Open URL", 85), new JMenu("New"), new JMenuItem("Save", 83), new JMenuItem("SaveAs", 65), new JMenuItem("Print", 80), new JMenuItem("Close", 67), new JMenuItem("Exit", 88)};
    protected JMenu _helpMenu = new JMenu("Help");
    protected JMenuItem[] _helpMenuItems = new JMenuItem[]{new JMenuItem("About", 65), new JMenuItem("Help", 72)};
    protected JMenuBar _menubar = new JMenuBar();
    protected StatusBar _statusBar = null;
    private static boolean _actionsDeferred = false;
    private static List _deferredActions = new LinkedList();
    private File _file = null;
    private boolean _hideMenuBar = false;
    private String _lastURL = "http://ptolemy.eecs.berkeley.edu/xml/models/";
    private boolean _menuPopulated = false;
    private boolean _modified = false;
    private boolean _centering = true;

    public Top() {
        this(new StatusBar());
    }

    public Top(StatusBar statusBar) {
        this._statusBar = statusBar;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Top.this._close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        GraphicalMessageHandler.setContext(this);
    }

    public static void setDirectory(File dir) {
        _directory = dir;
    }

    public void centerOnScreen() {
        Runnable doCenter = new Runnable(){

            @Override
            public void run() {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Top.this.setLocation((tk.getScreenSize().width - Top.this.getSize().width) / 2, (tk.getScreenSize().height - Top.this.getSize().height) / 2);
                GraphicalMessageHandler.setContext(Top.this);
            }
        };
        Top.deferIfNecessary(doCenter);
    }

    public final void close() {
        Runnable doClose = new Runnable(){

            @Override
            public void run() {
                Top.this._close();
            }
        };
        Top.deferIfNecessary(doClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deferIfNecessary(Runnable action) {
        if (EventQueue.isDispatchThread()) {
            action.run();
        } else {
            List list = _deferredActions;
            synchronized (list) {
                _deferredActions.add(action);
                if (!_actionsDeferred) {
                    Runnable doActions = new Runnable(){

                        @Override
                        public void run() {
                            Top._executeDeferredActions();
                        }
                    };
                    try {
                        SwingUtilities.invokeLater(doActions);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    _actionsDeferred = true;
                }
            }
        }
    }

    public boolean getCentering() {
        return this._centering;
    }

    public void hideMenuBar() {
        this._hideMenuBar = true;
    }

    public synchronized boolean isMenuPopulated() {
        return this._menuPopulated;
    }

    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void pack() {
        Runnable doPack = new Runnable(){

            @Override
            public void run() {
                if (!Top.this._menuPopulated) {
                    Top.this._fileMenu.setMnemonic(70);
                    Top.this._helpMenu.setMnemonic(72);
                    Top.this._fileMenuItems[0].setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                    Top.this._fileMenuItems[2].setMnemonic(78);
                    Top.this._fileMenuItems[2].setEnabled(false);
                    Top.this._fileMenuItems[3].setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                    Top.this._fileMenuItems[5].setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                    if (Top.this instanceof Printable || Top.this instanceof Pageable) {
                        Top.this._fileMenuItems[5].setEnabled(true);
                    } else {
                        Top.this._fileMenuItems[5].setEnabled(false);
                    }
                    Top.this._fileMenuItems[6].setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                    FileMenuListener fileMenuListener = new FileMenuListener();
                    for (int i = 0; i < Top.this._fileMenuItems.length; ++i) {
                        Top.this._fileMenuItems[i].setActionCommand(Top.this._fileMenuItems[i].getText());
                        Top.this._fileMenuItems[i].addActionListener(fileMenuListener);
                        Top.this._fileMenu.add(Top.this._fileMenuItems[i]);
                    }
                    Top.this._menubar.add(Top.this._fileMenu);
                    HelpMenuListener helpMenuListener = new HelpMenuListener();
                    for (int i = 0; i < Top.this._helpMenuItems.length; ++i) {
                        Top.this._helpMenuItems[i].setActionCommand(Top.this._helpMenuItems[i].getText());
                        Top.this._helpMenuItems[i].addActionListener(helpMenuListener);
                        Top.this._helpMenu.add(Top.this._helpMenuItems[i]);
                    }
                    Top.this._addMenus();
                    Top.this._menubar.add(Top.this._helpMenu);
                    if (!Top.this._hideMenuBar) {
                        Top.this.setJMenuBar(Top.this._menubar);
                    }
                    if (Top.this._statusBar != null) {
                        Top.this.getContentPane().add((Component)Top.this._statusBar, "South");
                    }
                }
                Top.super.pack();
                if (Top.this._centering) {
                    Top.this.centerOnScreen();
                }
                Top.this._menuPopulated = true;
            }
        };
        Top.deferIfNecessary(doPack);
    }

    public void report(Throwable throwable) {
        this.report("", throwable);
    }

    public void report(final String message) {
        Runnable doReport = new Runnable(){

            @Override
            public void run() {
                if (Top.this._statusBar != null) {
                    Top.this._statusBar.setMessage(message);
                }
            }
        };
        Top.deferIfNecessary(doReport);
    }

    public void report(final String message, final Throwable throwable) {
        Runnable doReport = new Runnable(){

            @Override
            public void run() {
                if (Top.this._statusBar != null) {
                    Top.this._statusBar.setMessage(MessageHandler.shortDescription(throwable) + ". " + message);
                }
                MessageHandler.error(message, throwable);
            }
        };
        Top.deferIfNecessary(doReport);
    }

    @Override
    public void setBackground(final Color background) {
        Runnable doSet = new Runnable(){

            @Override
            public void run() {
                Top.super.setBackground(background);
                if (Top.this._statusBar != null) {
                    Top.this._statusBar.setBackground(background);
                }
            }
        };
        Top.deferIfNecessary(doSet);
    }

    public void setCentering(boolean centering) {
        this._centering = centering;
    }

    public void setModified(boolean modified) {
        this._modified = modified;
    }

    @Override
    public void show() {
        Runnable doShow = new Runnable(){

            @Override
            public void run() {
                Top.this.setState(0);
                Top.super.show();
            }
        };
        Top.deferIfNecessary(doShow);
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "Ptolemy II " + this.getClass().getName() + "\n" + "By: Claudius Ptolemaeus, ptolemy@eecs.berkeley.edu\n" + "For more information, see\n" + "http://ptolemy.eecs.berkeley.edu/ptolemyII\n\n" + "Copyright (c) 1997-2008, " + "The Regents of the University of California.", "About Ptolemy II", 1);
    }

    protected void _addMenus() {
    }

    protected boolean _clear() {
        int result = this._queryForSave();
        return result == 0 || result == 1;
    }

    protected boolean _close() {
        if (this.isModified()) {
            int result = this._queryForSave();
            if (result == 0 || result == 1) {
                this.dispose();
                return true;
            }
            return false;
        }
        this.dispose();
        return true;
    }

    protected void _exit() {
        if (this.isModified()) {
            int result = this._queryForSave();
            if (result == 0 || result == 1) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    protected String _getName() {
        if (this._file == null) {
            return "Unnamed";
        }
        return this._file.getName();
    }

    protected void _help() {
        this._about();
    }

    protected void _open() {
        block11: {
            JFileChooser fileDialog = new JFileChooser();
            if (this._fileFilter != null) {
                fileDialog.addChoosableFileFilter(this._fileFilter);
            }
            fileDialog.setDialogTitle("Select a model file.");
            if (_directory != null) {
                fileDialog.setCurrentDirectory(_directory);
            } else {
                String currentWorkingDirectory = StringUtilities.getProperty("user.dir");
                if (currentWorkingDirectory != null) {
                    fileDialog.setCurrentDirectory(new File(currentWorkingDirectory));
                }
            }
            if (fileDialog.showOpenDialog(this) == 0) {
                _directory = fileDialog.getCurrentDirectory();
                try {
                    File file = fileDialog.getSelectedFile().getCanonicalFile();
                    long startTime = System.currentTimeMillis();
                    this._read(file.toURI().toURL());
                    long endTime = System.currentTimeMillis();
                    if (endTime > startTime + 10000L) {
                        System.out.println("Opened " + file + " in " + (System.currentTimeMillis() - startTime) + " ms.");
                    }
                }
                catch (Error error) {
                    try {
                        throw new RuntimeException(error);
                    }
                    catch (Exception ex2) {
                        this.report("Error while reading input:", ex2);
                    }
                }
                catch (Exception ex) {
                    if (ex.getMessage() == null || ex.getMessage().startsWith("*** Canceled.")) break block11;
                    this.report("Error reading input", ex);
                }
            }
        }
    }

    protected void _openURL() {
        Query query = new Query();
        query.setTextWidth(60);
        query.addLine("url", "URL", this._lastURL);
        ComponentDialog dialog = new ComponentDialog((Frame)this, "Open URL", query);
        if (dialog.buttonPressed().equals("OK")) {
            this._lastURL = query.getStringValue("url");
            try {
                URL url = new URL(this._lastURL);
                this._read(url);
            }
            catch (Exception ex) {
                this.report("Error reading URL:\n" + this._lastURL, ex);
            }
        }
    }

    protected void _print() {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        PrinterJob job = PrinterJob.getPrinterJob();
        if (this instanceof Pageable) {
            job.setPageable((Pageable)((Object)this));
        } else if (this instanceof Printable) {
            job.setPrintable((Printable)((Object)this));
        } else {
            return;
        }
        if (job.printDialog(aset)) {
            try {
                job.print(aset);
            }
            catch (Exception ex) {
                MessageHandler.error("Printing Failed", ex);
            }
        }
    }

    protected int _queryForSave() {
        Object[] options = new Object[]{"Save", "Discard changes", "Cancel"};
        String query = "Save changes to " + StringUtilities.split(this._getName()) + "?";
        int selected = JOptionPane.showOptionDialog(this, query, "Save Changes?", 1, 3, null, options, options[0]);
        if (selected == 0) {
            if (this._save()) {
                return 0;
            }
            return 3;
        }
        if (selected == 1) {
            return 1;
        }
        return 2;
    }

    protected abstract void _read(URL var1) throws Exception;

    protected boolean _save() {
        if (this._file != null) {
            try {
                this._writeFile(this._file);
                this.setModified(false);
                return true;
            }
            catch (IOException ex) {
                this.report("Error writing file", ex);
                return false;
            }
        }
        return this._saveAs();
    }

    protected boolean _saveAs() {
        JFileChooser fileDialog = this._saveAsFileDialog();
        int returnVal = fileDialog.showSaveDialog(this);
        if (returnVal == 0) {
            String query;
            int selected;
            this._file = fileDialog.getSelectedFile();
            if (this._file.exists() && (selected = JOptionPane.showOptionDialog(this, query = "Overwrite " + this._file.getName() + "?", "Save Changes?", 0, 3, null, null, null)) == 1) {
                return false;
            }
            this.setTitle(StringUtilities.abbreviate(this._getName()));
            _directory = fileDialog.getCurrentDirectory();
            return this._save();
        }
        return false;
    }

    protected JFileChooser _saveAsFileDialog() {
        JFileChooser fileDialog = new JFileChooser();
        if (this._fileFilter != null) {
            fileDialog.addChoosableFileFilter(this._fileFilter);
        }
        fileDialog.setDialogTitle("Save as...");
        if (_directory != null) {
            fileDialog.setCurrentDirectory(_directory);
        } else {
            String currentWorkingDirectory = StringUtilities.getProperty("user.dir");
            if (currentWorkingDirectory != null) {
                fileDialog.setCurrentDirectory(new File(currentWorkingDirectory));
            }
        }
        return fileDialog;
    }

    protected abstract void _writeFile(File var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _executeDeferredActions() {
        List list = _deferredActions;
        synchronized (list) {
            try {
                for (Runnable action : _deferredActions) {
                    action.run();
                }
            }
            finally {
                _actionsDeferred = false;
                _deferredActions.clear();
            }
        }
    }

    class HelpMenuListener
    implements ActionListener {
        HelpMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicalMessageHandler.setContext(Top.this);
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            try {
                if (actionCommand.equals("About")) {
                    Top.this._about();
                } else if (actionCommand.equals("Help")) {
                    Top.this._help();
                }
            }
            catch (Exception exception) {
                MessageHandler.error("Help Menu Exception:", exception);
            }
            Top.this.repaint();
        }
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicalMessageHandler.setContext(Top.this);
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            try {
                if (actionCommand.equals("Open File")) {
                    Top.this._open();
                } else if (actionCommand.equals("Open URL")) {
                    Top.this._openURL();
                } else if (actionCommand.equals("Save")) {
                    Top.this._save();
                } else if (actionCommand.equals("SaveAs")) {
                    Top.this._saveAs();
                } else if (actionCommand.equals("Print")) {
                    Top.this._print();
                } else if (actionCommand.equals("Close")) {
                    Top.this._close();
                } else if (actionCommand.equals("Exit")) {
                    Top.this._exit();
                }
            }
            catch (Exception exception) {
                MessageHandler.error("File Menu Exception:", exception);
            }
            Top.this.repaint();
        }
    }
}

