/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.sched;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import ptolemy.graph.sched.ScheduleElement;

public class Firing
extends ScheduleElement {
    private Object _firingElement;
    private List _firing = null;

    public Firing() {
    }

    public Firing(Object firingElement) {
        super(firingElement.getClass());
        this._firingElement = firingElement;
    }

    public Firing(Class firingElementClass) {
        super(firingElementClass);
    }

    @Override
    public Iterator firingElementIterator() {
        return new FiringElementIterator();
    }

    @Override
    public Iterator firingIterator() {
        if (this._firing == null) {
            this._firing = new LinkedList();
            this._firing.add(this);
        }
        return this._firing.iterator();
    }

    public Object getFiringElement() {
        return this._firingElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFiringElement(Object firingElement) {
        if (this.firingElementClass() != null) {
            if (!this.firingElementClass().isAssignableFrom(firingElement.getClass())) throw new RuntimeException("Attempt to add a non authorized firing element");
            this._incrementVersion();
            this._firingElement = firingElement;
            if (this._firing == null) return;
            this._firing.clear();
            this._firing.add(this);
            return;
        } else {
            this._incrementVersion();
            this._firingElement = firingElement;
            if (this._firing == null) return;
            this._firing.clear();
            this._firing.add(this);
        }
    }

    @Override
    public String toParenthesisString(Map nameMap, String delimiter) {
        String name = (String)nameMap.get(this.getFiringElement());
        int iterations = this.getIterationCount();
        if (iterations > 1) {
            return "(" + iterations + delimiter + name + ")";
        }
        return name;
    }

    public String toString() {
        String result = "Fire firing element " + this._firingElement;
        if (this.getIterationCount() > 1) {
            result = result + " " + this.getIterationCount() + " times";
        }
        return result;
    }

    private class FiringElementIterator
    implements Iterator {
        private long _startingVersion;
        private int _currentElement;

        public FiringElementIterator() {
            this._startingVersion = Firing.this._getVersion();
            this._currentElement = 0;
        }

        @Override
        public boolean hasNext() {
            if (this._startingVersion != Firing.this._getVersion()) {
                throw new ConcurrentModificationException("Schedule structure changed while iterator is active.");
            }
            return this._currentElement <= Firing.this.getIterationCount();
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element to return.");
            }
            if (this._startingVersion != Firing.this._getVersion()) {
                throw new ConcurrentModificationException("Schedule structure changed while iterator is active.");
            }
            ++this._currentElement;
            return Firing.this.getFiringElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

