/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.analyzer.ClusterNodesTransformer;
import ptolemy.graph.analysis.strategy.CachedStrategy;

public class ClusterNodesTransformerStrategy
extends CachedStrategy
implements ClusterNodesTransformer {
    private Node _superNode;
    private Collection _nodeCollection;

    public ClusterNodesTransformerStrategy(Graph graph, Collection nodeCollection, Node superNode) {
        super(graph);
        this._nodeCollection = nodeCollection;
        this._superNode = superNode;
    }

    @Override
    public Graph clusterNodes() {
        return (Graph)this._result();
    }

    @Override
    public boolean hasBackwardMapping() {
        return false;
    }

    @Override
    public boolean hasForwardMapping() {
        return false;
    }

    @Override
    public Object originalVersionOf(Object dummy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object transformedVersionOf(Object dummy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    protected Object _compute() {
        Graph graph = this.graph();
        Graph subgraph = graph.subgraph(this._nodeCollection);
        graph.addNode(this._superNode);
        HashSet nodesToRemove = new HashSet(this._nodeCollection);
        Iterator edges = graph.edges().iterator();
        ArrayList<Edge> removeList = new ArrayList<Edge>();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            if (!nodesToRemove.contains(edge.source()) || !nodesToRemove.contains(edge.sink())) continue;
            removeList.add(edge);
        }
        Iterator edgesToRemove = removeList.iterator();
        while (edgesToRemove.hasNext()) {
            graph.removeEdge((Edge)edgesToRemove.next());
        }
        removeList.clear();
        ArrayList<Edge> addList = new ArrayList<Edge>();
        for (Edge edge : graph.edges()) {
            Edge newEdge = null;
            if (nodesToRemove.contains(edge.source())) {
                newEdge = edge.hasWeight() ? new Edge(this._superNode, edge.sink(), edge.getWeight()) : new Edge(this._superNode, edge.sink());
            } else if (nodesToRemove.contains(edge.sink())) {
                newEdge = edge.hasWeight() ? new Edge(edge.source(), this._superNode, edge.getWeight()) : new Edge(edge.source(), this._superNode);
            }
            if (newEdge == null) continue;
            removeList.add(edge);
            addList.add(newEdge);
        }
        Iterator edgesToAdd = addList.iterator();
        while (edgesToAdd.hasNext()) {
            graph.addEdge((Edge)edgesToAdd.next());
        }
        edgesToRemove = removeList.iterator();
        while (edgesToRemove.hasNext()) {
            graph.removeEdge((Edge)edgesToRemove.next());
        }
        Iterator nodes = this._nodeCollection.iterator();
        while (nodes.hasNext()) {
            graph.removeNode((Node)nodes.next());
        }
        return subgraph;
    }
}

