/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis;

import ptolemy.graph.Graph;
import ptolemy.graph.analysis.Analysis;
import ptolemy.graph.analysis.analyzer.Analyzer;
import ptolemy.graph.analysis.analyzer.NegativeLengthCycleAnalyzer;
import ptolemy.graph.analysis.strategy.FloydWarshallNegativeLengthCycleStrategy;
import ptolemy.graph.mapping.ToDoubleMapping;

public class NegativeLengthCycleAnalysis
extends Analysis {
    public NegativeLengthCycleAnalysis(Graph graph, ToDoubleMapping edgeLengths) {
        super(new FloydWarshallNegativeLengthCycleStrategy(graph, edgeLengths));
    }

    public NegativeLengthCycleAnalysis(NegativeLengthCycleAnalyzer analyzer) {
        super(analyzer);
    }

    public boolean hasNegativeLengthCycle() {
        return ((NegativeLengthCycleAnalyzer)this.analyzer()).hasNegativeLengthCycle();
    }

    @Override
    public String toString() {
        return "Negative-length cycle analysis using the following analyzer:\n" + this.analyzer().toString();
    }

    @Override
    public boolean validAnalyzerInterface(Analyzer analyzer) {
        return analyzer instanceof NegativeLengthCycleAnalyzer;
    }
}

