/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ptolemy.graph.Element;
import ptolemy.graph.Graph;
import ptolemy.graph.GraphException;
import ptolemy.graph.GraphWeightException;
import ptolemy.graph.LabeledList;

public class ElementList
extends LabeledList {
    private String _descriptor;
    private Graph _graph;
    private static final Collection _emptyCollection = Collections.unmodifiableCollection(new ArrayList(0));
    private HashSet _unweightedSet;
    private HashMap _weightMap;

    public ElementList(String descriptor, Graph graph) {
        this._descriptor = descriptor;
        this._graph = graph;
        this._weightMap = new HashMap();
        this._unweightedSet = new HashSet();
    }

    public ElementList(String descriptor, Graph graph, int elementCount) {
        this._descriptor = descriptor;
        this._graph = graph;
        this._weightMap = new HashMap(elementCount);
        this._unweightedSet = new HashSet(elementCount);
    }

    public boolean cancelWeight(Element element) {
        boolean removed = false;
        if (element.hasWeight()) {
            Object weight = element.getWeight();
            ArrayList sameWeightList = (ArrayList)this._weightMap.get(weight);
            if (sameWeightList == null) {
                return false;
            }
            removed = sameWeightList.remove(element);
            if (sameWeightList.size() == 0) {
                this._weightMap.remove(weight);
            }
        } else {
            removed = this._unweightedSet.remove(element);
        }
        return removed;
    }

    public boolean changeWeight(Element element) {
        Object newWeight;
        boolean weightValueHasChanged = false;
        boolean found = false;
        Object object = newWeight = element.hasWeight() ? element.getWeight() : null;
        if (this._unweightedSet.contains(element)) {
            boolean bl = weightValueHasChanged = newWeight != null;
            if (weightValueHasChanged) {
                this._unweightedSet.remove(element);
                this.registerWeight(element);
            }
        } else {
            Iterator weights = this._weightMap.keySet().iterator();
            Object nextWeight = null;
            List nextList = null;
            while (weights.hasNext() && !found) {
                nextWeight = weights.next();
                nextList = (List)this._weightMap.get(nextWeight);
                found = nextList.contains(element);
            }
            if (found) {
                boolean bl = weightValueHasChanged = !nextWeight.equals(newWeight);
                if (weightValueHasChanged) {
                    nextList.remove(element);
                    if (nextList.size() == 0) {
                        this._weightMap.remove(nextWeight);
                    }
                    this.registerWeight(element);
                }
            } else {
                throw new RuntimeException("Internal error: the specified " + this._descriptor + " is neither unweighted nor associated " + "with a weight." + GraphException.elementDump(element, this._graph));
            }
        }
        return weightValueHasChanged;
    }

    @Override
    public void clear() {
        super.clear();
        this._weightMap.clear();
        this._unweightedSet.clear();
    }

    public boolean containsWeight(Object weight) {
        return this._weightMap.containsKey(weight);
    }

    public Element element(Object weight) {
        Collection elements = this.elements(weight);
        if (elements.size() == 0) {
            throw new GraphWeightException(weight, null, this._graph, "Invalid weight argument, the number of elements for this weight is zero.");
        }
        return (Element)elements.iterator().next();
    }

    public Collection elements() {
        return Collections.unmodifiableCollection(this);
    }

    public Collection elements(Object weight) {
        if (weight == null) {
            return Collections.unmodifiableCollection(this._unweightedSet);
        }
        Collection sameWeightElements = (Collection)this._weightMap.get(weight);
        if (sameWeightElements == null) {
            return _emptyCollection;
        }
        return Collections.unmodifiableCollection(sameWeightElements);
    }

    public void registerWeight(Element element) {
        if (element.hasWeight()) {
            Object weight = element.getWeight();
            ArrayList<Element> sameWeightList = (ArrayList<Element>)this._weightMap.get(weight);
            if (sameWeightList == null) {
                sameWeightList = new ArrayList<Element>();
                this._weightMap.put(weight, sameWeightList);
            }
            sameWeightList.add(element);
        } else {
            this._unweightedSet.add(element);
        }
    }

    public boolean remove(Element element) {
        boolean removed = super.remove(element);
        if (removed) {
            this.cancelWeight(element);
        }
        return removed;
    }

    public boolean validateWeight(Element element, Object oldWeight) {
        Object newWeight;
        boolean changed = false;
        Object object = newWeight = element.hasWeight() ? element.getWeight() : null;
        if (oldWeight == null) {
            if (!this._unweightedSet.contains(element)) {
                throw new GraphWeightException(null, null, this._graph, "Incorrect previous weight specified.");
            }
            if (newWeight == null) {
                return false;
            }
            this._unweightedSet.remove(element);
            changed = true;
        } else {
            List elementList = (List)this._weightMap.get(oldWeight);
            if (elementList == null || !elementList.remove(element)) {
                throw new GraphWeightException(oldWeight, null, this._graph, "Incorrect previous weight specified.");
            }
            changed = !oldWeight.equals(newWeight);
        }
        this.registerWeight(element);
        return changed;
    }
}

