/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sr.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class NonStrictThreeBitAdder
extends TypedAtomicActor {
    public TypedIOPort inputBits = new TypedIOPort(this, "inputBits", true, false);
    public TypedIOPort highBit;
    public TypedIOPort lowBit;

    public NonStrictThreeBitAdder(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.inputBits.setMultiport(true);
        this.highBit = new TypedIOPort(this, "highBit", false, true);
        this.lowBit = new TypedIOPort(this, "lowBit", false, true);
        this.inputBits.setTypeEquals(BaseType.INT);
        this.highBit.setTypeEquals(BaseType.INT);
        this.lowBit.setTypeEquals(BaseType.INT);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int numKnown = 0;
        int numOnes = 0;
        int width = this.inputBits.getWidth();
        if (width != 3) {
            throw new IllegalActionException((Nameable)this, "inputBits must have exactly 3 connected channels.");
        }
        for (int i = 0; i < width; ++i) {
            if (!this.inputBits.isKnown(i)) continue;
            ++numKnown;
            if (!this.inputBits.hasToken(i)) continue;
            int value = ((IntToken)this.inputBits.get(i)).intValue();
            if (value != 0 && value != 1) {
                throw new IllegalActionException((Nameable)this, "Inputs can only be 0 or 1.");
            }
            if (value != 1) continue;
            ++numOnes;
        }
        IntToken high = null;
        IntToken low = null;
        if (numKnown == 3) {
            low = numOnes == 0 || numOnes == 2 ? new IntToken(0) : new IntToken(1);
        }
        if (numKnown >= 2) {
            high = numOnes >= 2 ? new IntToken(1) : new IntToken(0);
        }
        if (high != null) {
            this.highBit.send(0, high);
        }
        if (low != null) {
            this.lowBit.send(0, low);
        }
    }

    @Override
    public boolean isStrict() {
        return false;
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.inputBits, this.highBit);
    }
}

